/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Graphics;

/**
 * AWT եå桼ƥƥ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class GraphicsUtils
{
	/** ʿ */
	public static final int HORIZONTAL = 1;
	/** ľ */
	public static final int VERTICAL   = 2;
	
	/** ߡ */
	private GraphicsUtils()
	{
	}
	
	/**
	 * 褷ޤ
	 * 
	 * @param     g      եå
	 * @param     x      x
	 * @param     y      y
	 * @param     width  
	 * @param     height ⤵
	 * @param     on     褹ϰ
	 * @param     off    ɽϰ
	 * @param     sense  褹
	 */
	public static void drawDashed(Graphics g,
	                              int x, int y, int width, int height,
	                              int on, int off, int sense)
	{
		int offset = 0;
		int p      = 0;
		int end    = 0;
		boolean isOn       = true;
		boolean horizontal = false;
		
		switch (sense) {
		case HORIZONTAL:
			p   = x;
			end = x + width;
			horizontal = true;
			break;
		case VERTICAL:
			p   = y;
			end = y + height;
			horizontal = false;
			break;
		}
		
		while (p < end) {
			if (isOn) {
				offset = on;
				if (p + offset > end)
					offset = end - p;
				
				if (horizontal)
					g.fillRect(p, y, offset, height);
				else
					g.fillRect(x, p, width , offset);
			} else {
				offset = off;
			}
			
			isOn = (!isOn);
			p += offset;
		}
	}
}
