/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.awt.event.StateEvent;
import net.hizlab.kagetaka.awt.event.StateListener;
import net.hizlab.kagetaka.awt.event.TabEvent;
import net.hizlab.kagetaka.awt.event.TabListener;

import java.util.EventListener;

/**
 * AWT 桼ƥƥ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class AWTEventMulticaster
	extends java.awt.AWTEventMulticaster
	implements TabListener
{
	/**
	 * ꥹ <code>a</code> ȥꥹ <code>b</code> Ĥʤ
	 * ٥ȡޥ㥹ȡ󥹥󥹤ޤ
	 * 
	 * @param     a ꥹ <code>a</code>
	 * @param     b ꥹ <code>b</code>
	 */
	protected AWTEventMulticaster(EventListener a, EventListener b)
	{
		super(a, b);
	}
	
	public static StateListener add(StateListener a, StateListener b)
	{
		return (StateListener)addInternal(a, b);
	}
	
	public static StateListener remove(StateListener l, StateListener oldl)
	{
		return (StateListener)removeInternal(l, oldl);
	}
	
	public void stateChanged(StateEvent e)
	{
		((StateListener)a).stateChanged(e);
		((StateListener)b).stateChanged(e);
	}
	
	public static TabListener add(TabListener a, TabListener b)
	{
		return (TabListener)addInternal(a, b);
	}
	
	public static TabListener remove(TabListener l, TabListener oldl)
	{
		return (TabListener)removeInternal(l, oldl);
	}
	
	public void activeChanged(TabEvent e)
	{
		((TabListener)a).activeChanged(e);
		((TabListener)b).activeChanged(e);
	}
	
	public void tabAdded(TabEvent e)
	{
		((TabListener)a).tabAdded(e);
		((TabListener)b).tabAdded(e);
	}
	
	public void tabRemoved(TabEvent e)
	{
		((TabListener)a).tabRemoved(e);
		((TabListener)b).tabRemoved(e);
	}
	
	public void tabChanged(TabEvent e)
	{
		((TabListener)a).tabChanged(e);
		((TabListener)b).tabChanged(e);
	}
}
