/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.applet;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.ParserManager;
import net.hizlab.kagetaka.cookie.CookieStore;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.HawkEngine;
import net.hizlab.kagetaka.rendering.HawkPanel;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.PanelListener;
import net.hizlab.kagetaka.rendering.PostData;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.util.Environment;
import net.hizlab.kagetaka.util.URLHistory;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ΥץåȤǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public class HawkApplet
	extends Applet
{
	private static final String RESOURCE = "net.hizlab.kagetaka.applet.Resource";
	private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
	static {
		Environment.isApplet = true;
	}
	
	/** @serial ݡȥץȥ */
	private Hashtable supportProtocol = new Hashtable();
	{
		StringTokenizer st = new StringTokenizer(Resource.getMessage("config.support.protocol", null), ",; ");
		while (st.hasMoreTokens())
			supportProtocol.put(st.nextToken(), "");
	}
	
	/** @serial 륳ƥ */
	private HawkAppletContext hawkContext;
	/** @serial ɥ쥹С */
	private TextField         addressBar;
	/** @serial ơСʸ */
	private String            statusText;
	/** @serial ץ */
	private Option            option     = new Option();
	/** @serial ٥ */
	private int               logLevel   = Reporter.ERROR;
	/** @serial ˬѤ URL */
	private Hashtable         visitedUrl = new Hashtable();
	/** @serial åޥ͡ */
	private CookieStore       cookieManager;
	
	/**
	 * 륢ץåȤΥ󥹥󥹤ޤ
	 */
	public HawkApplet()
	{
	}
	
	/**
	 * ץåȤޤ
	 */
	public void init() {
		this.addressBar = new TextField();
		addressBar.setEditable(false);
		
		String value = null;
		boolean useAddressBar = true;
		
		// եȤ
		if ((value = getParameter("font")) != null) {
			Font font = Font.decode(value);
			if (font != null)
				option.setDefaultFont(font);
			else
				showStatus(getMessage("parameter.nofont", new String[]{value}));
		}
		
		// ѡ
		if ((value = getParameter("parser")) != null) {
			if (ParserManager.getParser(value) != null)
				option.setInputStreamParser(value);
			else
				showStatus(getMessage("parameter.noparser", new String[]{value}));
		}
		
		// ɥ쥹С
		if ((value = getParameter("addressbar")) != null)
			useAddressBar = Boolean.valueOf(value).booleanValue();
		
		// ɥ쥹С
		if ((value = getParameter("scrollbar")) != null)
			option.setShowScrollbar(Boolean.valueOf(value).booleanValue());
		
		// GIF ž
		if ((value = getParameter("spingif")) != null)
			option.setSpinGifImage(Boolean.valueOf(value).booleanValue());
		
		// JPEG ž
		if ((value = getParameter("spinjpeg")) != null)
			option.setSpinJpegImage(Boolean.valueOf(value).booleanValue());
		
		// ƥȽ饤
		if ((value = getParameter("swapdecoration")) != null)
			option.setSwapDecoration(Boolean.valueOf(value).booleanValue());
		
		// LogLevel 
		if ((value = getParameter("loglevel")) != null)
			logLevel = Integer.valueOf(value).intValue();
		
		// URL 
		if ((value = getParameter("url")) == null) {
			showStatus(getMessage("parameter.nourl", null));
			return;
		}
		
		URL url = null;
		try {
			url = new URL(getCodeBase(), value);
		} catch (MalformedURLException e) {
			showStatus(getMessage("error.url.unknown", new String[]{value, e.toString()}));
			return;
		}
		
		// 
		this.cookieManager = CookieStore.getInstance();
		
		this.hawkContext = new HawkAppletContext();
		
		// ̤
		setLayout(new BorderLayout());
		if (useAddressBar)
			add(addressBar, BorderLayout.NORTH );
		add(hawkContext.hawkPanel, BorderLayout.CENTER);
		
		// եɤ߹
		open(url);
	}
	
	/**
	 * ٤ƤΥ꥽˴ޤ
	 */
	/*
	public void destroy() {
		super.destroy();
	}
	*/
	
	/**
	 * ץåȤμ¹Ԥ򳫻Ϥޤ
	 */
	public void start() {
		super.start();
		hawkContext.hawkPanel.requestFocus();
	}
	
	/**
	 * ץåȤμ¹Ԥߤޤ
	 */
	/*
	public void stop() {
		super.stop();
	}
	*/
	
	/**
	 * 륢ץåȤˤĤƤξ֤ޤ
	 * 
	 * @return    륢ץåȤξ
	 */
	public String getAppletInfo() {
		return Resource.getMessage("kagetaka.copyright", null);
	}
	
	/**
	 * 륢ץåȤǤѥ᡼֤ͤޤ
	 * 
	 * @return    륢ץåȤǤѥ᡼
	 */
	public String[][] getParameterInfo() {
		return new String[][] {
			{"url"       , "URL"    , "read file url."                           },
			{"font"      , "string" , "java's font string(fontname-style-size)." },
			{"parser"    , "class"  , "parser class."                            },
			{"addressbar", "boolean", "use addressbar."                          },
			{"scrollbar" , "boolean", "use scrllbar."                            },
			{"spingif"   , "boolean", "spin gif image."                          },
			{"spinjpeg"  , "boolean", "spin jpeg image."                         },
			{"loglevel"  , "int"    , "log level."                               },
		};
	}
	
//### Private
	/** ǡɽޤ */
	private void open(URL url)
	{
		hawkContext.load(url, null, null, true, false);
	}
	
	/** ꥽ʸ */
	private String getMessage(String key, String[] args)
	{
		return Resource.getMessage(RESOURCE, key, args);
	}
	
//### HawkAppletContext
	/** 륦ɥѤα륳ƥ */
	private class HawkAppletContext
		implements HawkContext,PanelListener,EngineListener
	{
		private AppletReporter reporter = new AppletReporter();
		
		private HawkEngine     hawkEngine;
		private HawkPanel      hawkPanel;
		private int            loadIndex;
		private boolean        forceLoad;
		
		private boolean        active;
		private ItemMap        itemMap;
		private URL            documentUrl;
		
		// 
		private Object         historyLock = new Object();
		private URLHistory     topURL;
		private URLHistory     currentURL;
		private URLHistory     endURL;
		
		//  URL
		private URL            newURL;          // ɤ߹߻ URL
		private URLHistory     moveURL;         // ư (,)  URL
		
		/** 󥹥󥹤 */
		private HawkAppletContext()
		{
			hawkEngine = new HawkEngine(HawkAppletContext.this);
			hawkPanel  = new HawkPanel (HawkAppletContext.this);
			
			hawkEngine.setEngineListener(HawkAppletContext.this);
			hawkPanel .setPanelListener (HawkAppletContext.this);
			
			// ˥塼ѹ
			initContextMenu();
			
			//### TODO Ȥꤢ
			active = true;
		}
		
		/** ѥͥΥƥȥ˥塼 */
		private void initContextMenu()
		{
			String   label = getMessage("contextmenu.openbrowser", null);
			Vector   items = null;
			MenuItem mi    = null;
			
			mi = new MenuItem(label);
			mi.addActionListener(new MenuActionListener(MenuActionListener.MAIN));
			items = hawkPanel.getMainMenuItems();
			items.addElement(new MenuItem("-"));
			items.addElement(mi);
			
			mi = new MenuItem(getMessage("contextmenu.dumpstatus", null));
			mi.addActionListener(new MenuActionListener(MenuActionListener.STATUS));
			items = hawkPanel.getMainMenuItems();
			items.addElement(new MenuItem("-"));
			items.addElement(mi);
			
			mi = new MenuItem(label);
			mi.addActionListener(new MenuActionListener(MenuActionListener.LINK));
			items = hawkPanel.getLinkMenuItems();
			items.addElement(new MenuItem("-"));
			items.addElement(mi);
		}
		
		/** URL  */
		private void load(URL url, PostData pd, URLHistory move, boolean reload, boolean force)
		{
			// ɹǤϤʤϡư褬ɽƤեƱå
			if (!reload) {
				synchronized (historyLock) {
					if (currentURL != null) {
						if (url != null) {
							// URL ưξ
							if (currentURL.getURL().sameFile(url)) {
								addToHistory(url, pd, url);
								moveToRef(true);
								return;
							}
						} else if (move != null) {
							// ưξ
							if (currentURL.getURL().sameFile(move.getURL())) {
								moveHistory(move);
								movePosition();
								return;
							}
						}
					}
				}
			}
			
			// ̤Υ󥯤ξ
			forceLoad = force;
			
			if (url != null) {
				newURL  = url;
				moveURL = null;
			} else if (move != null) {
				url = move.getURL     ();
				pd  = move.getPostData();
				newURL  = null;
				moveURL = move;
			} else {
				return;
			}
			
			hawkEngine.stop();
			
//System.out.println("URL=["+url+"]");
			hawkEngine.load(++loadIndex, url, pd);
		}
		
		//### HawkContext
		/** 륦ɥѤα륳ƥȤ */
		public Reporter getReporter()
		{
			return reporter;
		}
		
		/** ġ륭åȤ֤ */
		public Toolkit getToolkit()
		{
			return hawkPanel.getToolkit();
		}
		
		/** ꤷ URL ɽ */
		public void openHawk(URL url, PostData pd, boolean newWindow, boolean extension)
		{
			String protocol = url.getProtocol();
			if (supportProtocol.containsKey(protocol)) {
				load(url, pd, null, false, false);
			} else {
				// ݡȤƤʤץȥϥ֥饦ǳ
				if (newWindow)
					getAppletContext().showDocument(url, "_blank");
				else
					getAppletContext().showDocument(url);
			}
		}
		
		/** ꤵ줿 URL Υ֤ͥ */
		public URLConnection getURLConnection(URL url, PostData pd)
			throws IOException
		{
			URLConnection connection = url.openConnection();
			
			// å
			if (cookieManager != null) {
				String cookie = cookieManager.getCookie(url);
				if (cookie != null)
					connection.setRequestProperty("Cookie", cookie);
			}
			
			// POST ǡ³
			if (pd != null && connection instanceof HttpURLConnection)
				pd.send((HttpURLConnection)connection);
			
			// ³
			connection.connect();
			
			// å
			if (cookieManager != null) {
				String key;
				int    index = 1;
				
				for (;;) {
					if ((key = connection.getHeaderFieldKey(index)) == null)
						break;
					
					key = key.toLowerCase();
					if (key.compareTo("set-cookie") == 0)
						setCookie(connection.getHeaderField(index), url);
					
					index++;
				}
			}
			
			return connection;
		}
		
		/**  ꤵ줿ɥȤ */
		public void download(Document document, URLConnection connection)
		{
			getAppletContext().showDocument(document.getURL());
		}
		
		/** ᡼֤ޤ */
		public Image createImage(ImageProducer producer)
		{
			return hawkPanel.createImage(producer);
		}
		
		/** ᡼֤ޤ */
		public Image createImage(int width, int height)
		{
			return hawkPanel.createImage(width, height);
		}
		
		/** ǥȥå֤ */
		public MediaTracker getMediaTracker()
		{
			return hawkPanel.getMediaTracker();
		}
		
		/** ꡼󥤥᡼ɲ */
		public void addImage(Image image, Dimension size)
		{
			hawkPanel.addImage(image, size);
		}
		
		/** եॢƥɲ */
		public void addFormItem(FormItem item)
		{
			hawkPanel.addFormItem(item);
		}
		
		/** ѥ򥯥ꥢ */
		public void cleanCanvas()
		{
			hawkPanel.cleanCanvas();
		}
		
		/** ѥϰϤꤷƺɽ */
		public void repaint(int x, int y, int width, int height)
		{
			hawkPanel.repaintCanvas(x, y, width, height);
		}
		
		/** ѤιԤȡʸι⤵ */
		public void setScale(Dimension scale)
		{
			hawkPanel.setScale(scale);
		}
		
		/** طʤ */
		public void setBackground(Color color)
		{
			hawkPanel.setBackground(color);
		}
		
		/** طʲ */
		public void setBackground(Image image)
		{
			hawkPanel.setBackground(image);
		}
		
		/** ƥޥåפ */
		public void setItemMap(ItemMap map)
		{
			itemMap = map;
			hawkPanel.setItemMap(map);
		}
		
		/** ȥ */
		public void setTitle(String title)
		{
			// ǽʤ
		}
		
		/** ơå */
		public void setStatus(String status)
		{
			if (active)
				showStatus(status);
			statusText = status;
		}
		
		/** Ūʥơå */
		public void setTemporaryStatus(String status)
		{
			if (active) {
				if (status != null)
					showStatus(status);
				else
					showStatus(statusText);
			}
		}
		
		/**  */
		public void setCursor(int cursor)
		{
			hawkPanel.setCursor(cursor);
		}
		
		/** ӥ塼ݡȤθߤΥ֤ */
		public Dimension getViewportSize()
		{
			return hawkPanel.getViewportSize();
		}
		
		/** ץ֤ */
		public Option getOption()
		{
			return option;
		}
		
		/** ꤷ URL ˬ䤷Ȥ뤫ɤ֤ */
		public boolean haveEverVisited(URL url)
		{
			return visitedUrl.containsKey(url.toString());
		}
		
		/** å */
		public void setCookie(String value, URL url)
		{
			if (cookieManager != null)
				cookieManager.setCookie(value, url);
		}
		
		//### PanelListener
		/**  */
		public void back()
		{
			synchronized (historyLock) {
				if (canBack())
					load(null, null,
					     (moveURL == null ? currentURL : moveURL).getPreviousURLHistory(),
					     false, false);
			}
		}
		
		/** 뤫ɤ */
		public boolean canBack()
		{
			synchronized (historyLock) {
				if (topURL == null)
					return false;
				
				return ((moveURL == null ? currentURL : moveURL).getPreviousURLHistory() != null);
			}
		}
		
		/** ؿʤ */
		public void forward()
		{
			synchronized (historyLock) {
				if (canForward())
					load(null, null,
					     (moveURL == null ? currentURL : moveURL).getNextURLHistory(),
					     false, false);
			}
		}
		
		/** ؿʤ뤫ɤ */
		public boolean canForward()
		{
			synchronized (historyLock) {
				if (endURL == null)
					return false;
				
				return ((moveURL == null ? currentURL : moveURL).getNextURLHistory() != null);
			}
		}
		
		/** ɹ */
		public void reload(boolean force)
		{
			synchronized (historyLock) {
				if (canReload())
					load(null, null, currentURL, true, force);
			}
		}
		
		/** ɹǤ뤫ɤ */
		public boolean canReload()
		{
			synchronized (historyLock) {
				return (currentURL != null);
			}
		}
		
		/**  */
		public void stop()
		{
			hawkEngine.stop();
		}
		
		/** ߤǤ뤫ɤ */
		public boolean canStop()
		{
			return hawkEngine.isLoading();
		}
		
		//### EngineListener
		/** ³Ϥ˸ƤӽФ */
		public void connecting(int index)
		{
		}
		
		/** ³λȸƤӽФ */
		public void connected(int index, boolean noerror)
		{
		}
		
		/** 褬Ϥ˸ƤӽФ */
		public void renderingStarted(int index, URL openUrl, PostData pd, URL realUrl)
		{
			synchronized (historyLock) {
				if (newURL != null) {
					// ɤξ
					addToHistory(newURL, pd, realUrl);
					newURL = null;
				} else if (moveURL != null) {
					// ΰưξ
					moveURL.setRealURL(realUrl);
					moveHistory(moveURL);
					moveURL = null;
				}
			}
		}
		
		/** 褬λȸƤӽФ */
		public void renderingStopped(int index, boolean noerror)
		{
			// ȤդƤ硢뤹
			synchronized (historyLock) {
				if (currentURL != null)
					movePosition();
			}
		}
		
		/** ꤷ URL ɽ */
		public void refresh(int index, URL url)
		{
			load(url, null, null, true, false);
		}
		
		//### private
		/**  URL ɲ */
		private void addToHistory(URL openUrl, PostData pd, URL realUrl)
		{
			// ߤƱ URL ̵뤹
			if (currentURL != null && openUrl.equals(currentURL.getURL()))
				return;
			
			URLHistory h = new URLHistory(openUrl, pd, realUrl);
			
			if (currentURL != null) {
				currentURL.setPosition(hawkPanel.getScrollPosition());
				currentURL.removeAfter();
				currentURL.append(h);
			}
			
			if (topURL == null)
				topURL = h;
			
			endURL = currentURL = h;
			if (active)
				addressBar.setText(openUrl.toString());
			
			visitedUrl.put(openUrl.toString(), "");
		}
		
		/** Ȥưư */
		private void moveHistory(URLHistory move)
		{
			if (currentURL != null)
				currentURL.setPosition(hawkPanel.getScrollPosition());
			currentURL = move;
			if (active)
				addressBar.setText(currentURL.getURL().toString());
		}
		
		/** ݥư */
		private void movePosition()
		{
			Point position = currentURL.getPosition();
			if (position != null)
				hawkPanel.setScrollPosition(position.x, position.y);
			else
				moveToRef(false);
		}
		
		/** Ȱ֤إ */
		private void moveToRef(boolean force)
		{
			// ˥桼ˤ̤뤵Ƥ뤫å
			if (!force) {
				Point position = hawkPanel.getScrollPosition();
				if (position.x != 0 || position.y != 0)
					return;
			}
			
			String ref = currentURL.getURL().getRef();
			
			if (ref == null) {
				hawkPanel.setScrollPosition(0, 0);
				return;
			}
			
			if (itemMap == null)
				return;
			
			Point p = itemMap.getIdPoint(ref);
			if (p == null)
				return;
			
			hawkPanel.setScrollPosition(p.x, p.y);
		}
	}
	
//### AppletReporter
	/** 륦ɥѤΥݡ */
	private class AppletReporter
		implements Reporter
	{
		/** 󥹥󥹤 */
		private AppletReporter()
		{
		}
		
		/** 륦ɥѤΥݡ */
		public void report(int level, String message, int line, int column)
		{
			if (level < logLevel)
				return;
			
			StringBuffer sb = new StringBuffer();
			sb.append("#");
			
			switch (level) {
			case Reporter.ERROR  : sb.append("ERROR"  ); break;
			case Reporter.WARNING: sb.append("WARNING"); break;
			default: sb.append("MESSAGE");
			}
			
			sb.append(":");
			sb.append(line);
			sb.append(":");
			sb.append(column);
			sb.append(":");
			sb.append(message);
			System.out.println(sb.toString());
		}
		
		/** Υå٥֤ */
		public int getLevel()
		{
			return logLevel;
		}
	}
	
//### MenuActionListener
	/** ץꥱ󤫤鳫ѤΥꥹ */
	private class MenuActionListener
		implements ActionListener
	{
		private static final int MAIN   = 0;
		private static final int LINK   = 1;
		private static final int STATUS = 2;
		
		private int type;
		
		/** ꥹʤ */
		private MenuActionListener(int type)
		{
			this.type = type;
		}
		
		/** ϥɥ */
		public void actionPerformed(ActionEvent e)
		{
			switch (type) {
			case MAIN:
			case LINK:
				{
					URL url = (type == MAIN ? (hawkContext.currentURL != null ? hawkContext.currentURL.getURL() : null)
					                        : hawkContext.hawkPanel.getSelectedLink());
					if (url == null)
						return;
					
					getAppletContext().showDocument(url);
				}
				break;
			case STATUS:
				System.out.println(Resource.getMessage("kagetaka.name.en"  , null) + " " +
				                   Resource.getMessage("kagetaka.version"  , null) + " " +
				                   "(Build: " + Resource.getMessage(BUILD_RESOURCE, "build.number", null) + " " +
				                                Resource.getMessage(BUILD_RESOURCE, "build.date"  , null) + ")");
				System.out.println(Resource.getMessage("kagetaka.copyright", null) + " " +
				                   Resource.getMessage("kagetaka.vender.en", null));
				break;
			}
		}
	}
}
