/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.io.IOException;

/**
 * եΥ󥳡ǥ󥰤ѹ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Encoding
	extends MatchingTask
{
	private static final int BUFFER_SIZE = 2048;
	
	private String encoding     = null;       // 󥳡ǥ̾
	private String destEncoding = null;       // ϥ󥳡ǥ̾
	private File   srcDir       = null;       // ץåȥǥ쥯ȥ
	private File   destDir      = null;       // ȥץåȥǥ쥯ȥ
	private String extension    = null;       // ȥץåȥեγĥ
	
	private Mapper mapper = null;
	
	/**
	 * ͣΥ󥹥ȥ饯Ǥ
	 */
	public Encoding()
	{
	}
	
	/**
	 * եΥ󥳡ǥ󥰤ꤷޤ
	 * 
	 * @param     encoding 󥳡ǥ
	 */
	public void setEncoding(String encoding){
		this.encoding = encoding;
	}
	
	/**
	 * ϥեΥ󥳡ǥ󥰤ꤷޤ
	 * 
	 * @param     encoding 󥳡ǥ
	 */
	public void setDestEncoding(String encoding){
		this.destEncoding = encoding;
	}
	
	/**
	 * Ѵ뤿Υե뤬äƤǥ쥯ȥꤷޤ
	 * 
	 * @param     srcDir ϥեõǥ쥯ȥ
	 */
	public void setSrc(File srcDir){
		this.srcDir = srcDir;
	}
	
	/**
	 * Ѵե¸ǥ쥯ȥꤷޤ
	 * 
	 * @param     destDir ϥե¸ǥ쥯ȥ
	 */
	public void setDest(File destDir){
		this.destDir = destDir;
	}
	
	/**
	 * ѴȤΥե̾γĥҤꤷޤ
	 * 
	 * @param     ext ѴΥե̾γĥ
	 */
	public void setExt(String ext){
		this.extension = ext;
	}
	
	/**
	 * FileNameMapper  (ͥȤ mapper )
	 * 
	 * @return    ޥåѡ
	 * 
	 * @exception BuildException ӥɻ㳰
	 */
	public Mapper createMapper() throws BuildException {
		if (mapper != null)
			throw new BuildException("Cannot define more than one mapper", location);
		
		mapper = new Mapper(project);
		return mapper;
	}
	
	/**
	 * Ѵ򳫻Ϥޤ
	 * 
	 * @exception BuildException ӥɻ㳰
	 */
	public void execute()
		throws BuildException
	{
		if (encoding == null && destEncoding == null)
			throw new BuildException("The encoding or destEncoding attribute must be set.");
		
		if (srcDir == null)
			srcDir = project.resolveFile(".");
		
		if (destDir == null)
			throw new BuildException("The dest attribute must be set.");
		
		if (srcDir.equals(destDir) && extension == null && mapper == null)
			throw new BuildException("The ext attribute or a mapper must be set if"
			                         + " src and dest dirs are the same.");
		
		FileNameMapper m = null;
		if (mapper == null) {
			if (extension == null) {
				m = new IdentityMapper();
			} else {
				m = new ExtMapper();
			}
		} else {
			m = mapper.getImplementation();
		}
		
		DirectoryScanner  scanner = getDirectoryScanner(srcDir);
		String[]          files   = scanner.getIncludedFiles();
		SourceFileScanner sfs     = new SourceFileScanner(this);
		
		files = sfs.restrict(files, srcDir, destDir, m);
		int count = files.length;
		if (count == 0)
			return;
		
		log("Converting " + count + " file" + (count != 1 ? "s" : "")
		   + " from " + srcDir
		   + " to "   + destDir);
		
		for (int i = 0; i < files.length; i++)
			convert(files[i], m.mapFileName(files[i])[0]);
	}
	
	/** ѴԤ */
	private void convert(String srcName, String destName)
		throws BuildException
	{
		log("converting " + srcName, Project.MSG_VERBOSE);
		
		File srcFile  = new File(srcDir , srcName );
		File destFile = new File(destDir, destName);
		String parentName = destFile.getParent();
		if (parentName != null) {
			File parentFile = new File(parentName);
			
			if ((!parentFile.exists()) && (!parentFile.mkdirs()))
				throw new BuildException("cannot create parent directory " + parentName);
		}
		
		try {
			Reader in  = null;
			Writer out = null;
			if (encoding != null) {
				in  = new InputStreamReader(
				        new FileInputStream(srcFile), encoding);
			} else {
				in  = new InputStreamReader(
				        new FileInputStream(srcFile));
			}
			if (destEncoding != null) {
				out = new OutputStreamWriter(
				        new FileOutputStream(destFile), destEncoding);
			} else {
				out = new OutputStreamWriter(
				        new FileOutputStream(destFile));
			}
			
			char[] buffer = new char[BUFFER_SIZE];
			int    length = 0;
			
			while ((length = in.read(buffer, 0, BUFFER_SIZE)) != -1)
				out.write(buffer, 0, length);
			
			out.flush();
			out.close();
			in.close();
			
		} catch (IOException e) {
			throw new BuildException("file " + srcFile
			                         + " has error `" + e.toString() + "'");
		}
	}
	
//### ExtMapper
	/** ĥҤ١ˤޥåѡ */
	private class ExtMapper
		implements FileNameMapper
	{
		/** From  */
		public void setFrom(String s)
		{
		}
		
		/** To  */
		public void setTo(String s)
		{
		}
		
		/** ޥåԥ󥰤ե̾ */
		public String[] mapFileName(String fileName)
		{
			int lastDot = fileName.lastIndexOf('.');
			if (lastDot >= 0) {
				return new String[] {fileName.substring(0, lastDot) + extension};
			} else {
				return new String[] {fileName + extension};
			}
		}
	}
}
