/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka;

import net.hizlab.kagetaka.util.Environment;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.MissingResourceException;

/**
 * ꥽ǡ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class Resource
{
	private static final int BUFFER_SIZE = 0x4000;
	private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
	
	// ꥽Υꥹ
	private static String[] localeList;
	static {
		Vector v        = new Vector();
		Locale locale   = Locale.getDefault ();
		String variant  = locale.getVariant ();
		String language = locale.getLanguage();
		String country  = locale.getCountry ();
		if (variant  != null && variant .length() > 0)
			v.addElement("_" + language + "_" + country + "_" + variant);
		if (country  != null && country .length() > 0)
			v.addElement("_" + language + "_" + country);
		if (language != null && language.length() > 0)
			v.addElement("_" + language);
		v.addElement("");
		localeList = new String[v.size()];
		v.copyInto(localeList);
	}
	
	// å꥽
	private static Entry     base;
	private static Hashtable entryCache = new Hashtable();
	private static Hashtable bytesCache = new Hashtable();
	static {
		String path = Resource.class.getName();
		base = new Entry(path);
		entryCache.put(path, base);
	}
	
	/**
	 * ͣΥ󥹥ȥ饯
	 */
	private Resource()
	{
	}
	
	/**
	 * ɸ꥽åޤ
	 * 
	 * @param     key å꥽Υ
	 * @param     args åɲð
	 *                 ɬפʤ <code>null</code>
	 * 
	 * @return    å
	 */
	public static String getMessage(String key, Object[] args)
	{
		return base.getMessage(key, args, false, null);
	}
	
	/**
	 * ɸ꥽ǥեͤꤷƥåޤ
	 * 
	 * @param     key å꥽Υ
	 * @param     args åɲð
	 *                 ɬפʤ <code>null</code>
	 * @param     def ¸ߤʤäΥǥե
	 * 
	 * @return    å
	 */
	public static String getMessage(String key, Object[] args, String def)
	{
		return base.getMessage(key, args, true, def);
	}
	
	/**
	 * ꤷ꥽åޤ
	 * 
	 * @param     path ꥽Υѥ
	 * @param     key  å꥽Υ
	 * @param     args åɲð
	 *                 ɬפʤ <code>null</code>
	 * 
	 * @return    å
	 */
	public static String getMessage(String path, String key, Object[] args)
	{
		return getEntry(path).getMessage(key, args, false, null);
	}
	
	/**
	 * ꤷ꥽ǥեͤꤷƥåޤ
	 * 
	 * @param     path ꥽Υѥ
	 * @param     key  å꥽Υ
	 * @param     args åɲð
	 *                 ɬפʤ <code>null</code>
	 * @param     def ¸ߤʤäΥǥե
	 * 
	 * @return    å
	 */
	public static String getMessage(String path, String key, Object[] args, String def)
	{
		return getEntry(path).getMessage(key, args, true, def);
	}
	
	/**
	 * ɸ꥽Хʥ꥽ޤ
	 * 
	 * @param     key Хʥ꥽Υ
	 * 
	 * @return    Хʥ꥽¸ߤʤ <code>null</code>
	 */
	public static byte[] getBinaryResource(String key)
	{
		return base.getBinaryResource(key);
	}
	
	/**
	 * Хʥ꥽ޤ
	 * 
	 * @param     path ꥽Υѥ
	 * @param     key  Хʥ꥽Υ
	 * 
	 * @return    Хʥ꥽¸ߤʤ <code>null</code>
	 */
	public static byte[] getBinaryResource(String path, String key)
	{
		return getEntry(path).getBinaryResource(key);
	}
	
	/**
	 * ɸ꥽饤᡼꥽ޤ
	 * 
	 * @param     key ᡼꥽Υ
	 * @param     tk  ġ륭å
	 * 
	 * @return    ᡼꥽¸ߤʤ <code>null</code>
	 */
	public static Image getImageResource(String key, Toolkit tk)
	{
		return base.getImageResource(key, tk);
	}
	
	/**
	 * ᡼꥽ޤ
	 * 
	 * @param     path ꥽Υѥ
	 * @param     key  ᡼꥽Υ
	 * @param     tk   ġ륭å
	 * 
	 * @return    ᡼꥽¸ߤʤ <code>null</code>
	 */
	public static Image getImageResource(String path, String key, Toolkit tk)
	{
		return getEntry(path).getImageResource(key, tk);
	}
	
	/** ѥ饨ȥ꡼ */
	private static Entry getEntry(String path)
	{
		Entry entry = (Entry)entryCache.get(path);
		
		if (entry == null)
			entryCache.put(path, (entry = new Entry(path)));
		
		return entry;
	}
	
	/** 饤ץåȥȥ꡼ */
	private static InputStream getInputStream(String path)
	{
		try {
			ClassLoader cl = Resource.class.getClassLoader();
			if (cl != null)
				return cl.getResourceAsStream(path);
		} catch (SecurityException e) {}
		try {
			return ClassLoader.getSystemResourceAsStream(path);
		} catch (SecurityException e) {}
		
		return null;
	}
	
	/** ꥽¸ߤʤΥåѴ */
	private static String convertMessage(String key, Object[] args,
	                                     boolean assign, String def)
	{
		if (assign) {
			if (def == null || args == null)
				return def;
			else
				return MessageFormat.format(def, args);
		}
		
		if (args == null)
			return key;
		
		StringBuffer sb = new StringBuffer();
		sb.append(key);
		for (int i = 0; i < args.length; i++) {
			sb.append(", ");
			sb.append(args[i]);
		}
		return sb.toString();
	}
	
//### Entry
	/** å꥽å */
	private static class Entry
	{
		private static final String CLASS_EXTENSION = "List";
		
		private ResourceBundle messageResource;
		private Hashtable      messageFormat   = new Hashtable();
		
		/** 󥹥󥹤 */
		private Entry(String path)
		{
			ResourceBundle r = null;
			
			// ץåȻΤߡ饹꥽ɤ߹
			if (Environment.isApplet) {
				String className;
				int i = 0;
				
				// ꤬ʤ꥽ξϡ顼ʤ褦
				// դΥ饹ɤ߹ޤʤ褦ˤ
				if (path.startsWith("net.hizlab.kagetaka.util.") ||
				    path.compareTo(BUILD_RESOURCE) == 0)
					i = localeList.length - 1;
				
				for (; i < localeList.length; i++) {
					className = path + CLASS_EXTENSION + localeList[i];
					try {
						r = (ResourceBundle)Class.forName(className).newInstance();
						break;
					} catch (Exception e) {
System.out.println("Can not create message resource class `" + className + "' (" + e + ")");
					}
				}
			}
			
			if (r == null) {
				try {
					r = ResourceBundle.getBundle(path);
				} catch (MissingResourceException e) {
System.out.println("Can not load message resource file `" + path + "' (" + e + ")");
				}
			}
			
			messageResource = r;
			
/*
			// ץåȻΤߡ饹꥽ɤ߹
			if (Environment.isApplet)
				path += CLASS_EXTENSION;
			
			try {
				messageResource = ResourceBundle.getBundle(path);
			} catch (MissingResourceException e) {
System.out.println("Can not load message resource file `" + path + "' (" + e + ")");
			}
*/
		}
		
		/** ꥽å */
		private String getMessage(String key, Object[] args, boolean assign, String def)
		{
			try {
				if (messageResource != null) {
					if (args == null) {
						return messageResource.getString(key);
					} else {
						MessageFormat mf = (MessageFormat)messageFormat.get(key);
						if (mf == null) {
							mf = new MessageFormat(messageResource.getString(key));
							messageFormat.put(key, mf);
						}
						return mf.format(args);
					}
				}
			} catch (MissingResourceException e) {
			}
			return convertMessage(key, args, assign, def);
		}
		
		/** Хʥ꥽ */
		private byte[] getBinaryResource(String key)
		{
			String path = getMessage(key, null, true, null);
			if (path == null)
				return null;
			
			Bytes bytes = (Bytes)bytesCache.get(path);
			
			if (bytes == null)
				bytesCache.put(path, (bytes = new Bytes(path)));
			
			return bytes.data;
		}
		
		/** ᡼꥽ */
		private Image getImageResource(String key, Toolkit tk)
		{
			byte[] data = getBinaryResource(key);
			if (data == null)
				return null;
			
			return tk.createImage(data);
		}
	}
	
//### Bytes
	/** Хʥ꥽å */
	private static class Bytes
	{
		private static final String CLASS_EXTENSION = "Image";
		
		private byte[] data;
		
		/** 󥹥󥹤 */
		private Bytes(String path)
		{
			// ץåȻΤߡ饹꥽ɤ߹
			if (Environment.isApplet) {
				ResourceBundle r = null;
				String fixedPath = path;
				String className;
				
				// ĥҤ
				int p = path.lastIndexOf('.');
				if (p != -1)
					fixedPath = path.substring(0, p);
				fixedPath += CLASS_EXTENSION;
				
				for (int i = 0; i < localeList.length; i++) {
					className = fixedPath + localeList[i];
					try {
						r = (ResourceBundle)Class.forName(className).newInstance();
						data = (byte[])r.getObject("data");
						return;
					} catch (MissingResourceException e) {
System.out.println("Can not get binary resource from class `" + className + "' (" + e + ")");
					} catch (Exception e) {
System.out.println("Can not create binary resource class `" + className + "' (" + e + ")");
					}
				}
			}
			
			try {
				InputStream is = getInputStream(path);
				if (is == null)
					return;
				
				ByteArrayOutputStream baos = new ByteArrayOutputStream(BUFFER_SIZE);
				byte[] buffer = new byte[BUFFER_SIZE];
				int    length = 0;
				
				while ((length = is.read(buffer, 0, BUFFER_SIZE)) != -1)
					baos.write(buffer, 0, length);
				
				baos.flush();
				data = baos.toByteArray();
				
				is  .close();
				baos.close();
			} catch (IOException e) {
System.out.println("Can not load binary resource file `" + path + "' (" + e + ")");
			}
		}
	}
}
