/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.fclabs.util;

/**
 * Ūʥ塼εǽ󶡤ޤ
 * <P>
 * 塼ϡİʾΥ֥å۴ĥꥹȤˤƴƤޤ
 * ĤΥ֥åˡ֥ȤʣǼǤޤ
 * 󥹥󥹤Ȥˡ֥å<code>minBlockNum</code>ˤ
 * ֥åΥ֥Ȥο<code>blockSize</code>ˤǤޤ
 * ʤˤꤷʤ硢֥å 1֥ȿ 8 ǹޤ
 * <p>
 * 塼˥ǡꡢƤΥ֥åդˤʤȡ
 * ꤵ줿֥Ȥοĥ֥åĥꥹȤɲäޤ
 * դˡ塼饪֥ȤФΥ֥å 2 İʾ
 * ȡ 1 ĤϥꥹȤޤ
 * 
 * @author  <A HREF="mailto:hizuya@fclabs.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class Queue {
//### Variable
	private static final int DEFAULT_BLOCK_NUM  = 1;	// ɸν֥å
	private static final int DEFAULT_BLOCK_SIZE = 8;	// ɸΥ֥åꥪ֥ȿ
	private static final int BLOCK_BUFFER_NUM   = 1;	// ֥å˻Ĥ
	
	private int minBlockNum  = 0;	// ǾΥ֥å
	private int blockSize    = 0;	// ֥åΥ֥ȿ
	
	// ݥ
	private Block firstBlock = null;		// ǽΥ֥å
	private Block lastBlock  = null;		// ǸΥ֥å
	private int firstBlockIndex = 0;	// ǽΥ֥åΥ֥ȤΥǥå
	private int lastBlockIndex  = 0;	// ǸΥ֥åΥ֥ȤΥǥå
	
	// ưŪ
	private int total         = 0;	// ƤΥ֥Ȥο
	private int usedBlockNum  = 0;	// Υ֥åο
	private int totalBlockNum = 0;	// ݤƤ֥å
	
//### Constructor
	/**
	 * Υ塼ޤ
	 */
	public Queue() {
		this(DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_NUM);
	}
	
	/**
	 * ֥å̤ꤷơΥ塼ޤ
	 * 
	 * @param     blockSize ꥹΰĤΥ֥å˳ǼǤ륪֥ȿ
	 */
	public Queue(int blockSize) {
		this(blockSize, DEFAULT_BLOCK_NUM);
	}
	
	/**
	 * ֥å̤ȡ֥åꤷơΥ塼ޤ
	 * ̤ϡblockSize x minBlockNum ˤʤޤ
	 * 
	 * @param     blockSize ꥹΰĤΥ֥å˳ǼǤ륪֥ȿ
	 * @param     minBlockNum ꥹȤ֥åο
	 */
	public Queue(int blockSize, int minBlockNum) {
		this.blockSize   = (blockSize   > 0 ? blockSize   : DEFAULT_BLOCK_SIZE);
		this.minBlockNum = (minBlockNum > 0 ? minBlockNum : DEFAULT_BLOCK_NUM );
		init();
	}
	
//### Method
	/**
	 * ꥹȹ¤ޤ
	 */
	private synchronized void init() {
		// ͤ
		firstBlock = null;
		lastBlock  = null;
		firstBlockIndex = 0;
		lastBlockIndex  = 0;
		total           = 0;
		usedBlockNum  = 0;
		totalBlockNum = 0;
		
		firstBlock = new Block(blockSize);
		lastBlock  = firstBlock;
		totalBlockNum++;
		for(int i = 1; i < minBlockNum; i++) {
			lastBlock.next      = new Block(blockSize);
			lastBlock.next.prev = lastBlock;
			lastBlock           = lastBlock.next;
			totalBlockNum++;
		}
		lastBlock.next  = firstBlock;
		firstBlock.prev = lastBlock;
		
		// ꥹȤκǸƬ˰ư
		lastBlock      = firstBlock;
		
		usedBlockNum   =  1;
		lastBlockIndex = -1;
	}
	
	/**
	 * 塼˥֥ȤǼޤ
	 *
	 * @param     data 塼˳Ǽ륪֥
	 */
	public synchronized void put(Object data) {
		lastBlockIndex++;
		if (lastBlockIndex == blockSize) {	// ֥åդˤʤä
			if (usedBlockNum == totalBlockNum) { // ֥å
				// ֤
				Block block     = new Block(blockSize);
				block.next      = lastBlock.next;
				block.prev      = lastBlock;
				block.next.prev = block;
				lastBlock.next  = block;
				totalBlockNum++;
			}
			lastBlockIndex = 0;
			lastBlock      = lastBlock.next;
			usedBlockNum++;
		}
		lastBlock.items[lastBlockIndex] = data;
		total++;
		notify();
	}
	
	/**
	 * 塼Ƭ饪֥Ȥ
	 * Υǡ򥭥塼ޤ
	 * 
	 * @return    塼ƬäƤǡ
	 */
	public synchronized Object get() {
		if (isEmpty()) return null;
		
		Object data = firstBlock.items[firstBlockIndex];
		firstBlockIndex++;
		if (firstBlockIndex == blockSize) {	// ֥åˤʤä
			if (totalBlockNum > minBlockNum &&
			    totalBlockNum - usedBlockNum >= BLOCK_BUFFER_NUM) {
				// פʥ֥å
				firstBlock.prev.next = firstBlock.next;
				firstBlock.next.prev = firstBlock.prev;
				totalBlockNum--;
			}
			firstBlock = firstBlock.next;
			firstBlockIndex = 0;
			usedBlockNum--;
		}
		total--;
		return data;
	}
	
	/**
	 * 塼ƬΥ֥Ȥޤ
	 * Υǡϥ塼ޤ
	 * 
	 * @return    塼ƬäƤǡ
	 */
	public synchronized Object peek() {
		if (isEmpty()) return null;
		
		return firstBlock.items[firstBlockIndex];
	}
	
	/**
	 * 塼饪֥Ȥ塼ޤ
	 * 塼ξϡ˥塼˳ǼΤԵޤ
	 * 
	 * @return    塼ƬäƤǡ
	 * 
	 * @exception InterruptedException Ե˳ߤä
	 */
	public synchronized Object waitObject() throws InterruptedException {
		while (isEmpty()) {
			wait();
		}
		return get();
	}
	
	/**
	 * 塼ɤƥȤޤ
	 * 
	 * @return    塼ξ <code>true</code>
	 *            ʳ <code>false</code>
	 */
	public synchronized boolean isEmpty() {
		return (total == 0);
	}
	
	/**
	 * 塼ˤԤο֤ޤ
	 * 
	 * @return    Ԥο
	 */
	public synchronized int size() {
		return total;
	}
	
	/**
	 * 塼ˤԤ˴ޤ
	 */
	public synchronized void clear() {
		init();
	}
	
	/**
	 * 塼Υǡʸ󲽤ޤ
	 * 塼Υǡ̤˱ơ̤礷ޤ
	 * 
	 * @return    塼Υǡʸ󲽤
	 */
	public synchronized String toString( ) {
		Block  currentBlock = firstBlock;
		int    currentIndex = firstBlockIndex;
		StringBuffer sb = new StringBuffer("Queue[");
	
		for (int i = 0; i < total; ++i) {
			if (i != 0) sb.append(", ");
			sb.append(currentBlock.items[currentIndex++]);
			if(currentIndex == blockSize) {
				currentIndex = 0;
				currentBlock = currentBlock.next;
			}
		}
		sb.append(']');
		return sb.toString();
	}
	
//### ֥å 饹
	/**
	 * 塼Ѥ롢ꥹȤΥ֥å
	 */
	private static class Block {
		Block  next;	// Υ֥å
		Block  prev;	// Υ֥å
		Object items[];	// ֥
		/**
		 * ꤵ줿 size ΥꥹȤޤ
		 *
		 * @param     size ֥Ȥ礭
		 */
		Block (int size) {
			items = new Object[size];
		}
	}
}
