/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.io.FileUtils;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.ViewerToolbar;
import net.hizlab.kagetaka.viewer.option.InvalidValueException;
import net.hizlab.kagetaka.viewer.option.Setter;
import net.hizlab.kagetaka.viewer.option.ViewerOption;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.PrintWriter;
import java.io.IOException;

/**
 * {@link ViewerOption} ΥƥȤ򤹤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class ViewerOptionTester extends Tester {
    /**
     * 󥹥󥹤ޤ
     */
    protected ViewerOptionTester() {
    }

    /* γפ֤ޤ*/
    /** {@inheritDoc} */
    protected String getArgumentsSummary() {
        return "[-s file] [-u file] -o directory";
    }

    /* ξܺ٤<code>out</code> ˽Ϥޤ*/
    /** {@inheritDoc} */
    protected void printArgumentsDescription(PrintWriter out) {
        out.println("  -s file");
        out.println("      ȥץѥƥեؤΥѥ");
        out.println("  -u file");
        out.println("      桼ץѥƥեؤΥѥ");
        out.println("  -o directory");
        out.println("      ϥǥ쥯ȥ");
    }

    /**
     * ץեɤ߹ߡ¸ޤ
     *
     * <p>
     * : [-s file] [-u file] -o directory
     * </p>
     * <dl>
     *   <dt>-s file</dt>
     *   <dd>ȥץѥƥեؤΥѥ</dd>
     *   <dt>-u file</dt>
     *   <dd>桼ץѥƥեؤΥѥ</dd>
     *   <dt>-o directory</dt>
     *   <dd>ϥǥ쥯ȥ</dd>
     * </dl>
     *
     * @param  args {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    protected int execute(String[] args) {
        String sitePath = null;
        String userPath = null;
        String outDir   = null;
        for (int i = 0; i < args.length; i++) {
            // -s ȥץѥƥ
            if (args[i].compareTo("-s") == 0) {
                if (++i < args.length) {
                    sitePath = args[i];
                    continue;
                }
            }
            // -u 桼ץѥƥ
            if (args[i].compareTo("-u") == 0) {
                if (++i < args.length) {
                    userPath = args[i];
                    continue;
                }
            }
            // -o ϥǥ쥯ȥ
            if (args[i].compareTo("-o") == 0) {
                if (++i < args.length) {
                    outDir = args[i];
                    continue;
                }
            }
            return showUsage();
        }
        if (outDir == null) {
            return showUsage();
        }

        File sitePathFile = null;
        File userPathFile = null;
        File outDirFile   = new File(outDir);

        // ϥǥ쥯ȥ
        if (!outDirFile.isDirectory() && !outDirFile.mkdirs()) {
            log("Can not make directory(" + outDir + ")");
            return 1;
        }

        // ԡ
        try {
            if (sitePath != null) {
                File src = new File(sitePath);
                File dst = new File(outDirFile, src.getName());
                FileUtils.copy(src, dst);
                sitePathFile = dst;
            }
            if (userPath != null) {
                File src = new File(userPath);
                File dst = new File(outDirFile, src.getName());
                FileUtils.copy(src, dst);
                userPathFile = dst;
            }
        } catch (IOException e) {
            log(e);
            return 2;
        }

        // ץ
        ViewerOption option = new ViewerOption(sitePathFile, userPathFile);
        Setter setter = option.getSetter();
        try {
            setter.putPropertyBoolean  (ViewerOption.KEY_HTTP_STRICT,
                                        true);
            setter.putPropertyInteger  (ViewerOption.KEY_CACHE_STORE_MAXSIZE,
                                        10);
            setter.putPropertyString   (ViewerOption.KEY_SHOW_SCROLLBAR,
                                        HawkViewer.SCROLLBAR_NO);
            setter.putPropertyStrings  (ViewerOption.KEY_SHOW_LINKBAR_BUTTONS,
                                        new String[]{ViewerToolbar.BOOKMARK,
                                                     ViewerToolbar.HOME});
            setter.putPropertyFile     (ViewerOption.KEY_CACHE_STORE_PATH,
                                        new File("/tmp/test"));
            setter.putPropertyPoint    (ViewerOption.KEY_WINDOW_POSITION,
                                        new Point(1, 2));
            setter.putPropertyDimension(ViewerOption.KEY_WINDOW_SIZE,
                                        new Dimension(100, 200));
        } catch (InvalidValueException e) {
            log(e);
        }
        setter.commit();
        option.save();
        return 0;
    }
}
