/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.net.URLEncoder;

import java.io.PrintWriter;

/**
 * {@link URLEncoder} ΥƥȤ򤹤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class URLEncoderTester extends Tester {
    /**
     * 󥹥󥹤ޤ
     */
    protected URLEncoderTester() {
    }

    /* γפ֤ޤ*/
    /** {@inheritDoc} */
    protected String getArgumentsSummary() {
        return "-e|-d string [encoding]";
    }

    /* ξܺ٤<code>out</code> ˽Ϥޤ*/
    /** {@inheritDoc} */
    protected void printArgumentsDescription(PrintWriter out) {
        out.println("  -e");
        out.println("      󥳡ɤ");
        out.println("  -d");
        out.println("      ǥɤ");
        out.println("  string");
        out.println("      оȤʸ");
        out.println("  encoding");
        out.println("      󥳡ǥ");
    }

    /**
     * URL 󥳡ɡǥɤԤޤ
     *
     * <p>
     * : -e|-d string [encoding]
     * </p>
     * <dl>
     *   <dt>-e</dt>
     *   <dd>󥳡ɤ</dd>
     *   <dt>-d</dt>
     *   <dd>ǥɤ</dd>
     *   <dt>string</dt>
     *   <dd>оȤʸ</dd>
     *   <dt>encoding</dt>
     *   <dd>󥳡ǥ</dd>
     * </dl>
     *
     * @param  args {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    protected int execute(String[] args) {
        if (args.length < 2) {
            return showUsage();
        }
        boolean isEncode;
        if (args[0].compareTo("-e") == 0) {
            isEncode = true;
        } else if (args[0].compareTo("-d") == 0) {
            isEncode = false;
        } else {
            return showUsage();
        }
        String value    = args[1];
        String encoding = (args.length > 2 ? args[2] : null);

        try {
            log(value + " => "
              + (isEncode
                 ? URLEncoder.encode(value, encoding)
                 : URLEncoder.decode(value, encoding)));
        } catch (Exception e) {
            log(e);
            return 1;
        }
        return 0;
    }
}
