/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.IOException;

/**
 * ƥδ쥯饹Ǥ
 * ƤΥƥϤΥ饹
 * abstract ᥽åɤɬפޤ
 * <p>
 * ƥȼ¹ԻˤϡΥ饹ƥƥɤ
 * {@param #execute(String[])} ᥽åɤƤӽФޤ
 * <p>
 * ƥϤȤϡɬΥ饹
 * <code>log</code> ᥽åɤѤɬפޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public abstract class Tester {
    private static final String LOG_NEWLINE_PREFIX  = "**LOG** : ";
    private static final String LOG_CONTINUE_PREFIX = "**LOG** > ";
    private static final String CLASS_PREFIX = "net.hizlab.kagetaka.test.";
    private static final String CLASS_SUFFIX = "Tester";

    /** ν */
    private static PrintStream logOutput = System.out;

    /**
     * ¹Ԥ򳫻Ϥޤ
     *
     * @param  args ¹Ի
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            log("Usage: java " + CLASS_PREFIX + CLASS_SUFFIX + " class_name [args...]");
            System.exit(101);
        }

        Tester tester = null;

        // 󥹥󥹤
        String className = args[0];
        if (!className.startsWith(CLASS_PREFIX)) {
            className = CLASS_PREFIX + className;
        }
        if (!className.endsWith(CLASS_SUFFIX)) {
            className += CLASS_SUFFIX;
        }

        try {
            // 󥹥󥹤
            tester = (Tester) Class.forName(className).newInstance();
        } catch (ClassNotFoundException e) {
            System.err.println("Class not found `" + className + "'");
            System.exit(102);
        } catch (InstantiationException e) {
            System.err.println("Invalid class constructor `" + className + "'");
            System.exit(103);
        } catch (IllegalAccessException e) {
            System.err.println("Illegal access `" + e + "'");
            System.exit(104);
        } catch (IllegalArgumentException e) {
            System.err.println("Illegal argument `" + e + "'");
            System.exit(105);
        } catch (ClassCastException e) {
            System.err.println("Invalid super class `" + className + "'");
            System.exit(106);
        } catch (SecurityException e) {
            System.err.println("Security exception `" + e + "'");
            System.exit(107);
        }

        // ¹Ԥ򳫻
        String[] execArgs = new String[args.length - 1];
        System.arraycopy(args, 1, execArgs, 0, args.length - 1);
        try {
            System.exit(tester.execute(execArgs));
        } catch (RuntimeException e) {
            log(e);
            System.exit(255);
        }
    }

    /**
     * ꤵ줿֥ȤʸɽȤƽϤޤ
     *
     * @param  value ֥
     */
    protected static void log(Object value) {
        if (value != null) {
            logImpl(value.toString());
        }
    }

    /**
     * ꤵ줿㳰ȤƽϤޤ
     *
     * @param  throwable 㳰
     */
    protected static void log(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter  out          = new PrintWriter(stringWriter);
        throwable.printStackTrace(out);
        out.flush();
        out.close();
        log(stringWriter);
    }

    /**
     * ꤵ줿ʸȤƽϤޤ
     *
     * @param  value ʸ
     */
    private static void logImpl(String value) {
        PrintStream out = Tester.logOutput;
        synchronized (out) {
            BufferedReader br = new BufferedReader(new StringReader(value));
            try {
                String line = br.readLine();
                if (line != null) {
                    out.print  (LOG_NEWLINE_PREFIX);
                    out.println(line);
                    while ((line = br.readLine()) != null) {
                        out.print  (LOG_CONTINUE_PREFIX);
                        out.println(line);
                    }
                }
            } catch (IOException e) {
                // ̵
            }
        }
    }

    /**
     * 󥹥󥹤ޤ
     */
    protected Tester() {
    }

    /**
     * γפ֤ޤ
     *
     * @return γס
     *         ̵ <code>null</code>
     */
    protected abstract String getArgumentsSummary();

    /**
     * ξܺ٤<code>out</code> ˽Ϥޤ
     *
     * @param  out ξܺ٤ν
     */
    protected abstract void printArgumentsDescription(PrintWriter out);

    /**
     * ¹Ԥޤ
     *
     * @param  args ޥɥ饤
     *
     * @return ޥɤ͡
     *           <code>0</code> ǡ顼ξ <code>1 - 100</code>
     */
    protected abstract int execute(String[] args);

    /**
     * ΥƥȤμ¹ˡɽޤ
     *
     * @return ̵ɸŪʥ顼
     */
    public int showUsage() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter  out          = new PrintWriter(stringWriter);

        String className = this.getClass().getName();
        boolean cutPrefix = className.startsWith(CLASS_PREFIX);
        boolean cutSuffix = className.endsWith  (CLASS_SUFFIX);
        if (cutPrefix || cutSuffix) {
            className = className.substring(
                (cutPrefix ? CLASS_PREFIX.length() : 0),
                (cutSuffix ? className.length() - CLASS_SUFFIX.length() : 0)
            );
        }
        out.print("Usage: java ");
        out.print(CLASS_PREFIX);
        out.print(CLASS_SUFFIX);
        out.print(" ");
        out.print(className);
        String summary = getArgumentsSummary();
        if (summary != null) {
            out.print(summary);
        }
        out.println();
        printArgumentsDescription(out);
        out.flush();
        out.close();

        log(stringWriter);
        return 254;
    }
}
