/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Request;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

/**
 * ߡ {@link HawkContext} 륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class HawkContextAdapter implements HawkContext {
    /** ƤӽФ */
    protected PrintWriter out;
    /** ݡ */
    protected Reporter reporter;
    /** ץ */
    protected Option option;

    private int imageIndex;

    /**
     * ꤷ˸ƤӽФϤ륢ץޤ
     *
     * @param  out 
     */
    HawkContextAdapter(PrintWriter out) {
        this.out      = out;
        this.reporter = new ReporterAdapter(out);
        this.option   = new Option();
    }

    /* 륦ɥѤα륳ƥȤ */
    /** {@inheritDoc} */
    public Reporter getReporter() {
        return reporter;
    }

    /* ġ륭åȤ֤ */
    /** {@inheritDoc} */
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    /* ꤷ URL ɽ */
    /** {@inheritDoc} */
    public void openHawk(Request request) {
    }

    /* ꤵ줿 URL Υ֤ͥ */
    /** {@inheritDoc} */
    public Content getContent(Request request)
            throws IOException, InterruptedException {
        URLConnection connection = request.url.openConnection();

        // POST ǡ³
        if (request.postData != null && connection instanceof HttpURLConnection) {
            request.postData.send(connection);
        }

        // ³
        try {
            connection.connect();
        } finally {
            if (Thread.interrupted()) {
                throw new InterruptedException("connect");
            }
        }

        return new Content(connection);
    }

    /*  ꤵ줿ƥĤ */
    /** {@inheritDoc} */
    public void download(Content content) {
    }

    /* ᡼֤ޤ */
    /** {@inheritDoc} */
    public Image createImage(int width, int height) {
        return null;
    }

    /* ǥȥå֤ */
    /** {@inheritDoc} */
    public MediaTracker getMediaTracker() {
        return null;
    }

    /* ꡼󥤥᡼ɲ */
    /** {@inheritDoc} */
    public int setImage(int index, int reason, int tag,
                        Image image, int width, int height, ItemMap itemMap) {
        return (index > 0 ? index : ++imageIndex);
    }

    /* եॢƥɲ */
    /** {@inheritDoc} */
    public void addFormItem(FormItem item) {
    }

    /* ѥͥ򥻥åȥå */
    /** {@inheritDoc} */
    public void setupPanel(Document document) {
    }

    /* ѥͥե졼Ѥ˥åȥå */
    /** {@inheritDoc} */
    public void setupPanel(Document document, FrameItem rootItem) {
    }

    /* ѥͥ */
    /** {@inheritDoc} */
    public void commitPanel(Document document, int tag) {
    }

    /* ХϰϤꤷƺɽ */
    /** {@inheritDoc} */
    public void repaint(int x, int y, int width, int height) {
    }

    /* ơå */
    /** {@inheritDoc} */
    public void setStatus(String status) {
    }

    /* Ūʥơå */
    /** {@inheritDoc} */
    public void setTemporaryStatus(String status) {
    }

    /* ӥ塼ݡȤθߤΥ֤ */
    /** {@inheritDoc} */
    public Dimension getViewportSize(boolean def) {
        return new Dimension(500, 500);
    }

    /* ץ֤ */
    /** {@inheritDoc} */
    public Option getOption() {
        return option;
    }

    /* ꤷ URL ˬ䤷Ȥ뤫ɤ֤ */
    /** {@inheritDoc} */
    public boolean haveEverVisited(URL url) {
        return false;
    }

    /* å */
    /** {@inheritDoc} */
    public void setCookie(String value, URL url) {
    }
}
