/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.addin.cookie.Cookie;

import java.io.PrintWriter;
import java.net.URL;
import java.net.MalformedURLException;
import java.text.ParseException;

/**
 * {@link Cookie} ΥƥȤ򤹤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class CookieTester extends Tester {
    /**
     * 󥹥󥹤ޤ
     */
    protected CookieTester() {
    }

    /* γפ֤ޤ*/
    /** {@inheritDoc} */
    protected String getArgumentsSummary() {
        return "[-s|-l] url cookie...";
    }

    /* ξܺ٤<code>out</code> ˽Ϥޤ*/
    /** {@inheritDoc} */
    protected void printArgumentsDescription(PrintWriter out) {
        out.println("  -s");
        out.println("      å򸷤᤹ʥǥեȡ");
        out.println("  -l");
        out.println("      åβˤ");
        out.println("  url");
        out.println("      åäƤۥȤ URL");
        out.println("  cookie");
        out.println("      åɽʸ");
    }

    /**
     * åϤ̤ɽԤޤ
     *
     * <p>
     * : [-s|-l] url cookie...
     * </p>
     * <dl>
     *   <dt>-s</dt>
     *   <dd>å򸷤᤹ʥǥեȡ</dd>
     *   <dt>-l</dt>
     *   <dd>åβˤ</dd>
     *   <dt>url</dt>
     *   <dd>åäƤۥȤ URL</dd>
     *   <dt>cookie</dt>
     *   <dd>åɽʸ</dd>
     * </dl>
     *
     * @param  args {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    protected int execute(String[] args) {
        if (args.length < 2) {
            return showUsage();
        }

        URL     url;
        boolean isStrict = true;

        int i = 0;
        if (args[i].compareTo("-s") == 0) {
            isStrict = true;
            i++;
        } else if (args[i].compareTo("-l") == 0) {
            isStrict = false;
            i++;
        }

        try {
            url = new URL(args[i++]);
        } catch (MalformedURLException e) {
            log(e);
            return 1;
        }

        boolean hasError = false;
        for (; i < args.length; i++) {
            try {
                log(new Cookie(args[i], url, isStrict));
            } catch (ParseException e) {
                log(e);
                hasError = true;
            }
        }

        return (hasError ? 1 : 0);
    }
}
