/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.DocumentExposer;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.addin.style.CSSParserExposer;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

/**
 * {@link net.hizlab.kagetaka.addin.style.CSSParser} ΥƥȤ򤹤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class CSSParserTester extends Tester {
    /**
     * 󥹥󥹤ޤ
     */
    protected CSSParserTester() {
    }

    /* γפ֤ޤ*/
    /** {@inheritDoc} */
    protected String getArgumentsSummary() {
        return "file...";
    }

    /* ξܺ٤<code>out</code> ˽Ϥޤ*/
    /** {@inheritDoc} */
    protected void printArgumentsDescription(PrintWriter out) {
        out.println("  file");
        out.println("      CSS ե");
    }

    /**
     * CSS եѡɽޤ
     *
     * <p>
     * : file...
     * </p>
     * <dl>
     *   <dt>file</dt>
     *   <dd>CSS ե</dd>
     * </dl>
     *
     * @param  args {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    protected int execute(String[] args) {
        if (args.length == 0) {
            return showUsage();
        }
        try {
            for (int i = 0; i < args.length; i++) {
                String path = args[i];
                log("*** CSSParser : [" + path + "]");

                URL          url  = new URL("file:/" + (new File(path)).getCanonicalPath());
                StringWriter sw   = new StringWriter();
                PrintWriter  out  = new PrintWriter(sw);

                HawkContextAdapter context  = new HawkContextAdapter(out);
                Content            content  = new Content(url.openConnection());
                DocumentExposer    document = new DocumentExposer(context, content);
                Request            request  = new Request(url, null, null, null,
                                                          Request.OPEN_DEFAULT,
                                                          Request.CACHE_NORMAL);
                CSSParserExposer   parser   = new CSSParserExposer(context,
                                                                   document,
                                                                   content,
                                                                   request);
                parser.dump(out);
                out.flush();
                out.close();
                log(sw);
                log("*** CSSParser.getEncoding : [" + parser.getEncoding() + "]");
            }
        } catch (Exception e) {
            log(e);
            return 1;
        }
        return 0;
    }
}
