/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * {@link Tree} ΥƥȤ򤹤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class AwtTreeTester extends Tester {
    /**
     * 󥹥󥹤ޤ
     */
    protected AwtTreeTester() {
    }

    /* γפ֤ޤ*/
    /** {@inheritDoc} */
    protected String getArgumentsSummary() {
        return "";
    }

    /* ξܺ٤<code>out</code> ˽Ϥޤ*/
    /** {@inheritDoc} */
    protected void printArgumentsDescription(PrintWriter out) {
    }

    /**
     * ĥ꡼ݡͥȤɽޤ
     *
     * @param  args {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    protected int execute(String[] args) {
        TreeFrame treeFrame = new TreeFrame("Tree Tester");
        treeFrame.show();

        try {
            synchronized (this) {
                wait();
            }
        } catch (InterruptedException e) {
            treeFrame.dispose();
        }

        return 0;
    }

    /**
     * ĥ꡼ݡͥȤɽ뤿Υե졼Ǥ
     */
    private final class TreeFrame extends Frame implements ItemListener {

        /**
         * ե졼ޤ
         *
         * @param  title ե졼Υȥ
         */
        private TreeFrame(String title) {
            super(title);

            Tree tree = new Tree(10, 20);
            add(tree);
            tree.addItemListener(this);

            Item top = new Item("dummy");
            Item item1 = null, item2 = null;

                    top.addChild("Item   1");
                    top.addChild("Item   2");
            item1 = top.addChild("Folder 3");
                      item1.addChild("Item   3-1");
                      item1.addChild("Item   3-2");
                    top.addChild("Item   4");
            item1 = top.addChild("Folder 5");
                      item1.addChild("Item   5-1");
              item2 = item1.addChild("Folder 5-2");
                        item2.addChild("Item   5-2-1 very long value");
                      item1.addChild("Item   5-3");
            item1 = top.addChild("Folder 6");
                    top.addChild("Item   7");

            tree.setRootTreeItem(top);
            tree.selectTreeItem(new int[]{4, 1});

            pack();

            // Ĥ褦ˤ
            addWindowListener(
                new WindowAdapter() {
                    public void windowClosing(WindowEvent e) {
                        dispose();
                        System.exit(0);
                    }
                }
            );

            // ɽ
            Dimension screenSize = getToolkit().getScreenSize();
            Dimension windowSize = getSize();
            setLocation((screenSize.width  - windowSize.width ) / 2,
                        (screenSize.height - windowSize.height) / 2);
        }

        /**
         * ĥ꡼ܤ򤵤줿˸ƤФޤ
         *
         * @param  e ٥
         */
        public void itemStateChanged(ItemEvent e) {
            System.out.println(e);
        }

        /**
         * ̤򹹿ޤ
         *
         * @param  g եå
         */
        public void update(Graphics g) {
            paint(g);
        }
    }

    /**
     * ĥ꡼ɽ륢ƥޤ
     */
    private final class Item implements TreeItem {
        private String label;
        private Item   parent;
        private Vector children;

        /**
         * ƥޤ
         *
         * @param  label ٥
         */
        private Item(String label) {
            this.label = label;
        }

        /**
         * ҤΥƥɲäޤ
         *
         * @param  label ҤΥƥΥ٥
         *
         * @return ɲäҤΥƥ
         */
        private Item addChild(String label) {
            if (children == null) {
                children = new Vector();
            }
            Item child = new Item(label);
            children.addElement(child);
            return child;
        }

        /** {@inheritDoc} */
        public Image getTreeIcon(boolean opened) {
            return null;
        }

        /** {@inheritDoc} */
        public String getTreeLabel() {
            return label;
        }

        /** {@inheritDoc} */
        public Vector getTreeItems() {
            return children;
        }
    }
}
