/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.test;

import net.hizlab.kagetaka.awt.event.KeyFilter;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;

/**
 * {@link KeyFilter} ΥƥȤ򤹤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class AwtKeyFilterTester extends Tester {
    /**
     * 󥹥󥹤ޤ
     */
    protected AwtKeyFilterTester() {
    }

    /* γפ֤ޤ*/
    /** {@inheritDoc} */
    protected String getArgumentsSummary() {
        return "";
    }

    /* ξܺ٤<code>out</code> ˽Ϥޤ*/
    /** {@inheritDoc} */
    protected void printArgumentsDescription(PrintWriter out) {
    }

    /**
     * ե륿ΥƥѤΥƥȥեɤɽԤޤ
     *
     * @param  args {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    protected int execute(String[] args) {
        FilterFrame filterFrame = new FilterFrame("Key Filter Tester");
        filterFrame.show();

        try {
            synchronized (this) {
                wait();
            }
        } catch (InterruptedException e) {
            filterFrame.dispose();
        }

        return 0;
    }

    /**
     * ե륿ƥȤƥȥեɤɽ뤿Υե졼Ǥ
     */
    private final class FilterFrame extends Frame {

        /**
         * ե졼ޤ
         *
         * @param  title ե졼Υȥ
         */
        private FilterFrame(String title) {
            super(title);

            setLayout(new GridLayout(4, 1));
            addTextFiled(KeyFilter.INT   );
            addTextFiled(KeyFilter.LONG  );
            addTextFiled(KeyFilter.FLOAT );
            addTextFiled(KeyFilter.DOUBLE);

            pack();

            // Ĥ褦ˤ
            addWindowListener(
                new WindowAdapter() {
                    public void windowClosing(WindowEvent e) {
                        dispose();
                        System.exit(0);
                    }
                }
            );

            // ɽ
            Dimension screenSize = getToolkit().getScreenSize();
            Dimension windowSize = getSize();
            setLocation((screenSize.width  - windowSize.width ) / 2,
                        (screenSize.height - windowSize.height) / 2);
        }

        /**
         * ꤵ줿ե륿Υƥȥեɤɲäޤ
         *
         * @param  filter ե륿
         */
        private void addTextFiled(int filter) {
            TextField text = new TextField("", 20);
            add(text);
            (new KeyFilter(filter)).attach(text);
        }
    }
}
