/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.ssl;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.net.DistinguishedName;

import java.awt.Frame;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;

/**
 * SSL ξɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class SSLCertification
        implements net.hizlab.kagetaka.viewer.SSLCertification {

    private static final char[] DIGITS = {'0', '1', '2', '3', '4', '5', '6', '7',
                                          '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Certificate[] localCertificates;
    private Certificate[] serverCertificates;

    /**
     * SSL ޤ
     *
     * @param  localCertificates  Ϣ
     * @param  serverCertificates оϢ
     */
    SSLCertification(Certificate[] localCertificates,
                     Certificate[] serverCertificates) {
        this.localCertificates  = localCertificates;
        this.serverCertificates = serverCertificates;
    }

    /* ɽ */
    /** {@inheritDoc} */
    public void show(Frame owner) {
        CertificateDialog.show(owner, SSLCertification.convert(serverCertificates));
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
/*
    public String toString() {
if (localCertificates != null) {
    for (int i = 0; i < localCertificates.length; i++) {
        Debug.out.println("=== L ========= " + (i + 1) + " === start ==========");
        if (localCertificates[i] instanceof X509Certificate) {
            dump((X509Certificate) localCertificates[i]);
        }
        Debug.out.println("=== L ========= " + (i + 1) + " === end ============");
    }
}
if (serverCertificates != null) {
    for (int i = 0; i < serverCertificates.length; i++) {
        Debug.out.println("=== S ========= " + (i + 1) + " === start ==========");
        if (serverCertificates[i] instanceof X509Certificate) {
            dump((X509Certificate) serverCertificates[i]);
        }
        Debug.out.println("=== S ========= " + (i + 1) + " === end ============");
    }
}
        return super.toString();
    }
*/

    /**
     * X.509 פޤ
     *
     * @param  certificate פ X.509 
     */
    static void dump(X509Certificate certificate) {
        DistinguishedName dn;
        dn = new DistinguishedName(certificate.getSubjectX500Principal().getName());
        Debug.out.println("Subject.CN=[" + dn.getCommonName() + "]");
        Debug.out.println("Subject.O =[" + dn.getOrganizationName() + "]");
        Debug.out.println("Subject.OU=[" + dn.getOrganizationalUnitName() + "]");
        Debug.out.println("Subject.L =[" + dn.getLocalityName() + "]");
        Debug.out.println("Subject.ST=[" + dn.getStateOrProvinceName() + "]");
        Debug.out.println("Subject.C =[" + dn.getCountryName() + "]");
        dn = new DistinguishedName(certificate.getIssuerX500Principal().getName());
        Debug.out.println("Issuer .CN=[" + dn.getCommonName() + "]");
        Debug.out.println("Issuer .O =[" + dn.getOrganizationName() + "]");
        Debug.out.println("Issuer .OU=[" + dn.getOrganizationalUnitName() + "]");
        Debug.out.println("Issuer .L =[" + dn.getLocalityName() + "]");
        Debug.out.println("Issuer .ST=[" + dn.getStateOrProvinceName() + "]");
        Debug.out.println("Issuer .C =[" + dn.getCountryName() + "]");
        Debug.out.println("Version   =[" + certificate.getVersion() + "]");
        Debug.out.println("Serial    =[" + certificate.getSerialNumber() + "]");
        Debug.out.println("Start     =[" + certificate.getNotBefore() + "]");
        Debug.out.println("End       =[" + certificate.getNotAfter() + "]");
        Debug.out.println("SigAlgName=[" + certificate.getSigAlgName() + "]");
        Debug.out.println("SHA1      =[" + getCertFingerprint("SHA1", certificate) + "]");
        Debug.out.println("MD5       =[" + getCertFingerprint("MD5", certificate) + "]");
    }

    /**
     * ꤵ줿르ꥺλǼޤ
     *
     * @param  algorithm   르ꥺ
     * @param  certificate 
     *
     * @return 
     */
    static String getCertFingerprint(String algorithm, Certificate certificate) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(certificate.getEncoded());
            return toHexString(md.digest());
        } catch (CertificateEncodingException e) {
            return null;
        } catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    /** 16 ɽѴ */
    private static String toHexString(byte[] bytes) {
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(length * 3);
        int n;
        for (int i = 0; i < length; i++) {
            n = bytes[i];
            sb.append(DIGITS[(n & 0xF0) >> 4]);
            sb.append(DIGITS[n & 0xF]);
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    /**
     * {@link Certificate}  {@link X509Certificate} Ѵޤ
     *
     * @param  certificates Ϣ
     *
     * @return X.509 ξϢ
     */
    static X509Certificate[] convert(Certificate[] certificates) {
        if (certificates == null) {
            return null;
        }

        if (certificates instanceof X509Certificate[]) {
            return (X509Certificate[]) certificates;
        }

        // Ѵ
        ArrayList list = new ArrayList(certificates.length);
        for (int i = 0; i < certificates.length; i++) {
            if (certificates[i] instanceof X509Certificate) {
                list.add(certificates[i]);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return (X509Certificate[]) list.toArray(new X509Certificate[list.size()]);
    }
}
