/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.ssl;

import java.awt.Frame;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;
import java.util.Map;

import javax.net.ssl.X509TrustManager;

/**
 * ͻ̤ X509TrustManager 󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class LooseX509TrustManager implements X509TrustManager {
    private SSLManager       sslManager;
    private X509TrustManager x509TrustManager;
    private Frame            owner;
    private Map              trusted;

    /**
     *  TrustManager ޤ
     *
     * @param  sslManager       SSL ޥ͡
     * @param  x509TrustManager Ƥ TrustManager
     * @param  owner            ʡ
     * @param  trusted          Ѥ߾
     */
    LooseX509TrustManager(SSLManager sslManager,
                          X509TrustManager x509TrustManager,
                          Frame owner, Map trusted) {
        this.sslManager       = sslManager;
        this.x509TrustManager = x509TrustManager;
        this.owner            = owner;
        this.trusted          = trusted;
    }

    /**
     * ԥФ줿ΤޤϴʾѤơ
     * Ǥ롼Ȥؤξѥۤ
     * ǧڥפ˴Ťƥ饤 SSL ǧڤ򸡾ڤǤ뤫ɤ
     * Ǥ뤫ɤ֤ޤ
     *
     * @param  chain    ԥξ
     * @param  authType 饤Ⱦ˴Ťǧڥ
     *
     * @throws IllegalArgumentException
     *         <code>null</code> ޤĹ <code>0</code> 
     *         󤬥ѥ᡼Ϥ줿硢
     *         뤤 <code>null</code> ޤĹ <code>0</code> ʸ
     *         <code>authType</code> ѥ᡼Ϥ줿
     * @throws CertificateException
     *         ꤵ줿󤬤
     *         TrustManager ˤäƿꤵʤ
     */
    public void checkClientTrusted(X509Certificate[] chain,
                                   String authType)
            throws CertificateException {
        x509TrustManager.checkClientTrusted(chain, authType);
    }

    /**
     * ԥФ줿ΤޤϴʾѤơ
     * Ǥ롼Ȥؤξѥۤ
     * ǧڥפ˴Ťƥ SSL ǧڤ򸡾ڤǤ뤫ɤ
     * Ǥ뤫ɤ֤ޤ
     *
     * @param  chain    ԥξ
     * @param  authType Ѥ븰򴹥르ꥺ
     *
     * @throws IllegalArgumentException
     *         <code>null</code> ޤĹ <code>0</code> 
     *         󤬥ѥ᡼Ϥ줿硢
     *         뤤 <code>null</code> ޤĹ <code>0</code> ʸ
     *         <code>authType</code> ѥ᡼Ϥ줿
     * @throws CertificateException
     *         ꤵ줿󤬤
     *         TrustManager ˤäƿꤵʤ
     */
    public void checkServerTrusted(X509Certificate[] chain,
                                   String authType)
            throws CertificateException {
        synchronized (trusted) {
            // ˾ǧѤߤ
            // ʴŪˤϰǧڤȸƤӽФʤΤǰ̵̣
            if (chain.length > 0 && trusted.containsKey(chain[0])) {
                return;
            }

            try {
                x509TrustManager.checkServerTrusted(chain, authType);
            } catch (CertificateException e) {
/*
if (chain != null) {
    Debug.out.println("### chain");
    for (int i = 0; i < chain.length; i++) {
        Debug.out.println("=============== " + (i + 1) + " === start ==========");
        SSLCertification.dump(chain[i]);
        Debug.out.println("=============== " + (i + 1) + " === end ============");
    }
}
*/
                if (chain.length == 0) {
                    throw e;
                }

                switch (InvalidCertificateDialog.show(owner, chain, e)) {
                case InvalidCertificateDialog.ACCEPT_ANYTIME:
                    sslManager.addCertificateEntry(chain[0], true , owner);
                    trusted.put(chain[0], chain[0]);
                    return;
                case InvalidCertificateDialog.ACCEPT_ONETIME:
                    sslManager.addCertificateEntry(chain[0], false, owner);
                    trusted.put(chain[0], chain[0]);
                    return;
                default:
                    throw e;
                }
            }
        }
    }

    /**
     * ǧڤԥˤĤƿꤵƤ롢
     * ȯԶɤξ֤ޤ
     *
     * @return 뤳ȤǤ CA ȯԼԾΡ
     *         <code>null</code> (ξ⤢) Ǥʤ
     */
    public X509Certificate[] getAcceptedIssuers() {
        return x509TrustManager.getAcceptedIssuers();
    }
}
