/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.ssl;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Icon;
import net.hizlab.kagetaka.awt.SizedLabel;
import net.hizlab.kagetaka.net.DistinguishedName;

import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.X509Certificate;

/**
 * ۥ̾γǧ¥Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class InvalidHostDialog extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.ssl.Resources";
    private static final int    MARGIN   = 3;

    /** @serial Ϣ */
    private X509Certificate[] certificates;
    /** @serial 񥨥顼 */
    private String            host;

    /** @serial ȥ٥ */
    private SizedLabel title;
    /** @serial ٥ */
    private SizedLabel reason;
    /** @serial ٥ */
    private SizedLabel question;
    /** @serial ܺ٥ܥ */
    private Button     detail;

    /**
     * ۥ̾γǧܥåɽη̤֤ޤ
     *
     * @param  owner        ʡ
     * @param  certificates Ϣ
     * @param  host         ۥ̾
     *
     * @return Ϥ줿桼̾ȥѥɡ
     *         󥻥뤵줿 <code>null</code>
     */
    public static boolean show(Frame owner,
                               X509Certificate[] certificates,
                               String host) {
        InvalidHostDialog dialog = new InvalidHostDialog(owner);

        dialog.setup(certificates, host);
        dialog.show();

        return (dialog.getResult() == RESULT_OK);
    }

    /**
     * ۥ̾ǧܥåޤ
     *
     * @param  owner ʡ
     */
    public InvalidHostDialog(Frame owner) {
        super(owner, BUTTON_OKCANCEL);
        setTitle    (getMessage("title", null));
        setResizable(false);
        setModal    (true );

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
        mainPanel.setLayout(gbl);

        addToPanel(           new Icon      (Icon.EXCLAMATION                  ), gbl, 0, 0, 1, 4, 0, 1, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
        insets.left = 10;
        addToPanel(title    = new SizedLabel(null                              ), gbl, 1, 0, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(reason   = new SizedLabel(null                              ), gbl, 1, 1, 1, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(question = new SizedLabel(null                              ), gbl, 1, 2, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(detail   = new Button    (getMessage("button.detail" , null)), gbl, 1, 3, 1, 1, 1, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);

        // ꥹʤϿ
        detail.addActionListener(
            new ActionListener() {
                /** ܥ󤬲줿 */
                public void actionPerformed(ActionEvent e) {
                    CertificateDialog.show(InvalidHostDialog.this.owner,
                                           SSLCertification.convert(certificates));
                }
            }
        );

        // 礭
        pack();
    }

    /** ꥽ʸ */
    private String getMessage(String key, Object[] args) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "invalidhostdialog." + key, args);
    }

    /**
     * ꤵƤϢ֤ޤ
     *
     * @return Ϣ
     */
    public X509Certificate[] getX509Certificate() {
        return certificates;
    }

    /**
     * ꤵƤۥ֤̾ޤ
     *
     * @return ۥ̾
     */
    public String getHost() {
        return host;
    }

    /**
     * ξꤷޤ
     *
     * @param  certificates Ϣ
     * @param  host         ۥ̾
     */
    public void setup(X509Certificate[] certificates,
                      String host) {

        this.certificates = certificates;
        this.host         = host;

        String validHost = "?";
        if (certificates.length > 0) {
            DistinguishedName dn = new DistinguishedName(certificates[0].getSubjectX500Principal().getName());
            validHost = dn.getCommonName();
        }

        String[] args = new String[]{host, validHost};
        title   .setText(getMessage("label.title"   , args));
        reason  .setText(getMessage("label.reason"  , args));
        question.setText(getMessage("label.question", args));

        // 礭
        pack();
    }
}
