/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.ssl;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Icon;
import net.hizlab.kagetaka.awt.SizedLabel;
import net.hizlab.kagetaka.net.DistinguishedName;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;

/**
 * ʾǧ뤿ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class InvalidCertificateDialog extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.ssl.Resources";
    private static final int    MARGIN   = 3;

    /** ˵Ĥ */
    public static final int ACCEPT_ANYTIME  = 0;
    /** åΤߵ */
    public static final int ACCEPT_ONETIME  = 1;
    /** Ĥʤ */
    public static final int DENY            = 2;

    /** @serial Ϣ */
    private X509Certificate[]    certificates;
    /** @serial 񥨥顼 */
    private CertificateException exception;

    /** @serial ȥ٥ */
    private SizedLabel title;
    /** @serial ٥ */
    private SizedLabel reason;
    /** @serial ٥ */
    private SizedLabel question;
    /** @serial ܺ٥ܥ */
    private Button     detail;
    /** @serial åܥå */
    private Checkbox[] checkboxes;

    /**
     * ǧܥåɽη̤֤ޤ
     *
     * @param  owner        ʡ
     * @param  certificates Ϣ
     * @param  exception    顼
     *
     * @return Ϥ줿桼̾ȥѥɡ
     *         󥻥뤵줿 <code>null</code>
     */
    public static int show(Frame owner,
                           X509Certificate[] certificates,
                           CertificateException exception) {
        InvalidCertificateDialog dialog = new InvalidCertificateDialog(owner);

        dialog.setup(certificates, exception);
        dialog.show();

        return dialog.getSelected();
    }

    /**
     * ǧܥåޤ
     *
     * @param  owner ʡ
     */
    public InvalidCertificateDialog(Frame owner) {
        super(owner, BUTTON_OKCANCEL);
        setTitle    (getMessage("title", null));
        setResizable(false);
        setModal    (true );

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
        mainPanel.setLayout(gbl);

        checkboxes = new Checkbox[3];
        CheckboxGroup cg = new CheckboxGroup();

        addToPanel(           new Icon      (Icon.EXCLAMATION                  ), gbl, 0, 0, 1, 7, 0, 1, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
        insets.left = 10;
        addToPanel(title    = new SizedLabel(null                              ), gbl, 1, 0, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(reason   = new SizedLabel(null                              ), gbl, 1, 1, 1, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(question = new SizedLabel(null                              ), gbl, 1, 2, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(detail   = new Button    (getMessage("button.detail" , null)), gbl, 1, 3, 1, 1, 1, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
        addToPanel(checkboxes[ACCEPT_ANYTIME] = new Checkbox(getMessage("checkbox.anytime", null), false, cg), gbl, 1, 4, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        insets.top = 0;
        addToPanel(checkboxes[ACCEPT_ONETIME] = new Checkbox(getMessage("checkbox.onetime", null), true , cg), gbl, 1, 5, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(checkboxes[DENY          ] = new Checkbox(getMessage("checkbox.deny"   , null), false, cg), gbl, 1, 6, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);

        // ꥹʤϿ
        detail.addActionListener(
            new ActionListener() {
                /** ܥ󤬲줿 */
                public void actionPerformed(ActionEvent e) {
                    CertificateDialog.show(InvalidCertificateDialog.this.owner,
                                           SSLCertification.convert(certificates));
                }
            }
        );

        // 礭
        pack();
    }

    /** ꥽ʸ */
    private String getMessage(String key, Object[] args) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "invalidcertificatedialog." + key, args);
    }

    /**
     * ɤ줬򤵤Ƥ뤫֤ޤ
     *
     * @return 򤵤Ƥ
     */
    public int getSelected() {
        if (getResult() == RESULT_OK) {
            for (int i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].getState()) {
                    return i;
                }
            }
        }

        return DENY;
    }

    /**
     * ꤵƤϢ֤ޤ
     *
     * @return Ϣ
     */
    public X509Certificate[] getX509Certificate() {
        return certificates;
    }

    /**
     * ꤵƤ륨顼֤ޤ
     *
     * @return 顼
     */
    public CertificateException getCertificateException() {
        return exception;
    }

    /**
     * ξꤷޤ
     *
     * @param  certificates Ϣ
     * @param  exception    顼
     */
    public void setup(X509Certificate[] certificates,
                      CertificateException exception) {

        this.certificates = certificates;
        this.exception    = exception;

        String host = "?";
        if (certificates.length > 0) {
            DistinguishedName dn = new DistinguishedName(certificates[0].getSubjectX500Principal().getName());
            host = dn.getCommonName();
        }

        String[] args = new String[]{host};
        title   .setText(getMessage("label.title"   , args));
        reason  .setText(getMessage("label.reason"  , args));
        question.setText(getMessage("label.question", args));

        // 礭
        pack();
    }
}
