/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.ssl;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.net.DistinguishedName;

import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * ɽ뤿ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class CertificateDialog extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.ssl.Resources";
    private static final int    MARGIN   = 3;

    /** ˵Ĥ */
    public static final int ACCEPT_ANYTIME  = 0;
    /** åΤߵ */
    public static final int ACCEPT_ONETIME  = 1;
    /** Ĥʤ */
    public static final int DENY            = 2;

    /** @serial Ϣ */
    private X509Certificate[]    certificates;
    /** @serial 񥨥顼 */
    private CertificateException exception;

    /** @serial ȯ衧̾ */
    private Label subjectCN;
    /** @serial ȯ衧ȿ */
    private Label subjectO;
    /** @serial ȯ衧 */
    private Label subjectOU;
    /** @serial ȯԸ̾ */
    private Label issuerCN;
    /** @serial ȯԸȿ */
    private Label issuerO;
    /** @serial ȯԸ */
    private Label issuerOU;
    /** @serial ꥢֹ */
    private Label serial;
    /** @serial ȯ */
    private Label start;
    /** @serial ڤ */
    private Label end;
    /** @serial SHA1 */
    private Label sha1;
    /** @serial MD5 */
    private Label md5;

    /**
     * ܥåɽη̤֤ޤ
     *
     * @param  owner        ʡ
     * @param  certificates Ϣ
     */
    public static void show(Frame owner,
                           X509Certificate[] certificates) {
        CertificateDialog dialog = new CertificateDialog(owner);

        dialog.setup(certificates);
        dialog.show();
    }

    /**
     * ܥåޤ
     *
     * @param  owner ʡ
     */
    public CertificateDialog(Frame owner) {
        super(owner, BUTTON_CLOSE);
        setTitle    (getMessage("title"));
        setResizable(false);
        setModal    (true );

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, 0, MARGIN);
        mainPanel.setLayout(gbl);

        // ȯ
        insets.top = MARGIN;
        addToPanel(            new BoldLabel(getMessage("subject"     )), gbl, 0,  0, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.top = 0;
        addToPanel(            new Label    (getMessage("subject.cn"  )), gbl, 0,  1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(subjectCN = new Label    (null                      ), gbl, 1,  1, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(            new Label    (getMessage("subject.o"   )), gbl, 0,  2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(subjectO  = new Label    (null                      ), gbl, 1,  2, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(            new Label    (getMessage("subject.ou"  )), gbl, 0,  3, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(subjectOU = new Label    (null                      ), gbl, 1,  3, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);

        // ȯԸ
        insets.top = MARGIN;
        addToPanel(            new BoldLabel(getMessage("issuer"      )), gbl, 0,  4, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.top = 0;
        addToPanel(            new Label    (getMessage("issuer.cn"   )), gbl, 0,  5, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(issuerCN  = new Label    (null                      ), gbl, 1,  5, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(            new Label    (getMessage("issuer.o"    )), gbl, 0,  6, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(issuerO   = new Label    (null                      ), gbl, 1,  6, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(            new Label    (getMessage("issuer.ou"   )), gbl, 0,  7, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(issuerOU  = new Label    (null                      ), gbl, 1,  7, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);

        // 
        insets.top = MARGIN;
        addToPanel(            new BoldLabel(getMessage("valid"       )), gbl, 0,  8, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.top = 0;
        addToPanel(            new Label    (getMessage("valid.serial")), gbl, 0,  9, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(serial    = new Label    (null                      ), gbl, 1,  9, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(            new Label    (getMessage("valid.start" )), gbl, 0, 10, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(start     = new Label    (null                      ), gbl, 1, 10, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(            new Label    (getMessage("valid.end"   )), gbl, 0, 11, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(end       = new Label    (null                      ), gbl, 1, 11, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);

        // 
        insets.top = MARGIN;
        addToPanel(            new BoldLabel(getMessage("fp"          )), gbl, 0, 12, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.top = 1;
        addToPanel(            new Label    (getMessage("fp.sha1"     )), gbl, 0, 13, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(sha1      = new Label    (null                      ), gbl, 1, 13, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.bottom = MARGIN;
        addToPanel(            new Label    (getMessage("fp.md5"      )), gbl, 0, 14, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        addToPanel(md5       = new Label    (null                      ), gbl, 1, 14, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);

        // 礭
        pack();
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "certificatedialog." + key, null);
    }

    /**
     * ꤵƤϢ֤ޤ
     *
     * @return Ϣ
     */
    public X509Certificate[] getX509Certificate() {
        return certificates;
    }

    /**
     * ξꤷޤ
     *
     * @param  certificates Ϣ
     */
    public void setup(X509Certificate[] certificates) {
        this.certificates = certificates;

        if (certificates == null || certificates.length == 0) {
            return;
        }

        X509Certificate certificate = certificates[0];
        DistinguishedName dn;

        dn = new DistinguishedName(certificate.getSubjectX500Principal().getName());
        subjectCN.setText(dn.getCommonName            ());
        subjectO .setText(dn.getOrganizationName      ());
        subjectOU.setText(dn.getOrganizationalUnitName());

        dn = new DistinguishedName(certificate.getIssuerX500Principal().getName());
        issuerCN .setText(dn.getCommonName            ());
        issuerO  .setText(dn.getOrganizationName      ());
        issuerOU .setText(dn.getOrganizationalUnitName());

        serial   .setText(String.valueOf(certificate.getSerialNumber()));
        start    .setText(toString(certificate.getNotBefore()));
        end      .setText(toString(certificate.getNotAfter ()));

        sha1     .setText(SSLCertification.getCertFingerprint("SHA1", certificate));
        md5      .setText(SSLCertification.getCertFingerprint("MD5" , certificate));

        // 礭
        pack();
    }

    /** ʸ֤ */
    private String toString(Date date) {
        if (date == null) {
            return "";
        }

        String s = getMessage("date.locale");
        Locale locale = (s != null && s.length() == 5 && s.charAt(2) == '_'
                         ? new Locale(s.substring(0, 2), s.substring(3, 5))
                         : Locale.getDefault());

        return (new SimpleDateFormat(getMessage("date.format"), locale)).format(date);
    }

//### BoldLabel
    /** Υ٥ */
    private final class BoldLabel extends Label {
        /** 󥹥󥹤 */
        private BoldLabel(String label) {
            super(label);
        }

        /** եȤ */
        public void addNotify() {
            super.addNotify();

            Font font = getFont();
            font = new Font(font.getName (),
                            font.getStyle() | Font.BOLD,
                            font.getSize ());
            setFont(font);
        }
    }
}
