/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.https;

import net.hizlab.kagetaka.protocol.CacheManager;
import net.hizlab.kagetaka.protocol.CacheSupported;
import net.hizlab.kagetaka.protocol.ProxySupported;
import net.hizlab.kagetaka.protocol.URLConnectionCache;
import net.hizlab.kagetaka.rendering.PostData;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.ProtocolException;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

/**
 * å򥵥ݡȤ <code>https</code> ץȥΥͥɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class SunHttpsURLConnection extends HttpsURLConnection implements CacheSupported, ProxySupported {
    private SunDelegateHttpsURLConnection delegate;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  url        URL
     * @param  handler    ץȥϥɥ
     * @param  proxyHost  ץۥ
     * @param  proxyPort  ץݡ
     * @param  cacheEntry å奨ȥ
     *
     * @throws IOException I/O顼ȯ
     */
    SunHttpsURLConnection(URL url, SunHandler handler, String proxyHost, int proxyPort,
                          URLConnectionCache.Entry cacheEntry)
            throws IOException {
        super(url);

        this.delegate  = new SunDelegateHttpsURLConnection(url, handler, this, proxyHost, proxyPort, cacheEntry);
    }

//### CacheSupported
    /** {@inheritDoc} */
    public void setupCache(CacheManager cm, PostData pd) {
        delegate.setupCache(cm, pd);
    }

    /** {@inheritDoc} */
    public void removeCache() {
        delegate.removeCache();
    }

    /** {@inheritDoc} */
    public String getCachePath() {
        return delegate.getCachePath();
    }


//### Object
    /**
     * ֥Ȥʸɽ֤ޤ
     *
     * @return ʸɽ
     *
     * @see    Object#toString()
     */
    public String toString() {
        return delegate.toString();
    }

    /**
     * Υ֥Ȥ¾Υ֥Ȥɤ򼨤ޤ
     *
     * @param  obj оݤλȥ֥
     *
     * @return obj ˻ꤵ줿֥ȤȤΥ֥Ȥ
     *         <code>true</code>Ǥʤ <code>false</code>
     *
     * @see    Object#equals(Object)
     */
    public boolean equals(Object obj) {
        return delegate.equals(obj);
    }

    /**
     * ֥ȤΥϥå女֤ͤޤ
     *
     * @return ϥå女
     *
     * @see    Object#hashCode()
     */
    public int hashCode() {
        return delegate.hashCode();
    }

    /**
     * ١쥯ˤäƸƤӽФޤ
     *
     * @see    Object#finalize()
     */
    protected void finalize() throws Throwable {
        delegate.finalize();
    }

//### URLConnection
    /**
     * ³Ԥޤ
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     *
     * @see    java.net.URLConnection#connect()
     */
    public void connect() throws IOException {
        delegate.connect();
    }

    /**
     * URL ե֤ͤޤ
     *
     * @return URL ե
     *
     * @see    java.net.URLConnection#getURL()
     */
    public URL getURL() {
        return delegate.getURL();
    }

    /**
     * <code>content-length</code> إåեɤ֤ͤޤ
     *
     * @return ³ URL Ȥ꥽Υƥĥ
     *         ξ <code>-1</code>
     *
     * @see    java.net.URLConnection#getContentLength()
     */
    public int getContentLength() {
        return delegate.getContentLength();
    }

    /**
     * <code>content-type</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽Υƥķ
     *         ξ <code>null</code>
     *
     * @see    java.net.URLConnection#getContentType()
     */
    public String getContentType() {
        return delegate.getContentType();
    }

    /**
     * <code>content-encoding</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽ΥƥĤ沽
     *         ξ <code>null</code>
     *
     * @see    java.net.URLConnection#getContentEncoding()
     */
    public String getContentEncoding() {
        return delegate.getContentEncoding();
    }

    /**
     * <code>expires</code> إåեɤ֤ͤޤ
     *
     * @return  URL Ȥ꥽ͭ¡
     *         ξ <code>0</code>
     *         ͤϥ˥åɸ 1970 ǯ 1  1  鵯ߥÿ
     *
     * @see    java.net.URLConnection#getExpiration()
     */
    public long getExpiration() {
        return delegate.getExpiration();
    }

    /**
     * <code>date</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽
     *         ξ <code>0</code>
     *         ͤϥ˥åɸ 1970 ǯ 1  1  鵯ߥÿ
     *
     * @see    java.net.URLConnection#getDate()
     */
    public long getDate() {
        return delegate.getDate();
    }

    /**
     * <code>last-modified</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽ѹ줿ա
     *         ξ <code>0</code>
     *         ͤϥ˥åɸ 1970 ǯ 1  1  鵯ߥÿ
     *
     * @see    java.net.URLConnection#getLastModified()
     */
    public long getLastModified() {
        return delegate.getLastModified();
    }

    /**
     * ꤵ줿إåեɤ֤ͤޤ
     *
     * @param  name  إåեɤ̾
     *
     * @return ꤵ줿إåեɤ̾
     *         ꤵ줿̾ĥեɤإåˤʤ
     *         <code>null</code>
     *
     * @see    java.net.URLConnection#getHeaderField(String)
     */
    public String getHeaderField(String name) {
        return delegate.getHeaderField(name);
    }

    /**
     * إåեɤѹԲǽʥޥåפ֤ޤ
     *
     * @return إåեɤΥޥå
     *
     * @see    java.net.URLConnection#getHeaderFields()
     */
    public Map getHeaderFields() {
        return delegate.getHeaderFields();
    }

    /**
     * ꤵ줿եɤͤȤƲϤ֤ͤޤ
     *
     * @param  name إåեɤ̾
     * @param  def  ǥե
     *
     * @return ꤷեɤͤȤƲϤ͡
     *         եɤʤޤϥեɤηξˤ
     *         <code>def</code> 
     *
     * @see    java.net.URLConnection#getHeaderFieldInt(String, int)
     */
    public int getHeaderFieldInt(String name, int def) {
        return delegate.getHeaderFieldInt(name, def);
    }

    /**
     * ꤵ줿եɤդȤƲϤ֤ͤޤ
     *
     * @param  name إåեɤ̾
     * @param  def  ǥե
     *
     * @return դȤƲϤե͡
     *         եɤʤޤϥեɤηʾ
     *         <code>def</code> 
     *
     * @see    java.net.URLConnection#getHeaderFieldDate(String, long)
     */
    public long getHeaderFieldDate(String name, long def) {
        return delegate.getHeaderFieldDate(name, def);
    }

    /**
     * <code>n</code> ܤΥإåեɤΥ֤ޤ
     *
     * @param  n ǥå
     *
     * @return <code>n</code> ܤΥإåեɤΥ
     *         եɤο <code>n</code> Ĥ⾯ʤ
     *         <code>null</code>
     *
     * @see    java.net.URLConnection#getHeaderFieldKey(int)
     */
    public String getHeaderFieldKey(int n) {
        return delegate.getHeaderFieldKey(n);
    }

    /**
     * <code>n</code> ܤΥإåեɤ֤ͤޤ
     *
     * @param  n ǥå
     *
     * @return <code>n</code> ܤΥإåեɤ͡
     *         եɤο <code>n</code> Ĥ⾯ʤ
     *         <code>null</code>
     *
     * @see    java.net.URLConnection#getHeaderField(int)
     */
    public String getHeaderField(int n) {
        return delegate.getHeaderField(n);
    }

    /**
     *  URL ³ΥƥĤޤ
     *
     * @return ֥
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException
     *         ץȥ뤬Υƥķ򥵥ݡȤƤʤ
     *
     * @see    java.net.URLConnection#getContent()
     */
    public Object getContent() throws IOException {
        return delegate.getContent();
    }

    /**
     *  URL ³ΥƥĤޤ
     *
     * @param  classes ׵ᤵ줿פ򼨤 <code>Class</code> 
     *
     * @return 饹ǻꤵ줿פǽ˰פ
     *         ֥ȡ
     *         ׵ᤵ줿פݡȤƤʤ <code>null</code>
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException
     *         ץȥ뤬Υƥķ򥵥ݡȤƤʤ
     *
     * @see    java.net.URLConnection#getContent(Class[])
     */
    public Object getContent(Class[] classes) throws IOException {
        return delegate.getContent(classes);
    }

    /**
     * Υ֥Ȥɽ³μ¹Ԥɬפʥɽ
     * <code>Permission</code> ֥Ȥ֤ޤ
     *
     * @return ³Τɬפʥɽ
     *         <code>Permission</code> ֥
     *
     * @throws IOException
     *         ν˥ͥåȥ
     *         ޤϥեϤɬפʤȤˡ㳰ȯ
     *
     * @see    java.net.URLConnection#getPermission()
     */
    public Permission getPermission() throws IOException {
        return delegate.getPermission();
    }

    /**
     * ϥȥ꡼֤ޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException ץȥ뤬Ϥ򥵥ݡȤƤʤ
     *
     * @see    java.net.URLConnection#getInputStream()
     */
    public InputStream getInputStream() throws IOException {
        return delegate.getInputStream();
    }

    /**
     * ꥯȤǽϤϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException ץȥ뤬Ϥ򥵥ݡȤƤʤ
     *
     * @see    java.net.URLConnection#getOutputStream()
     */
    public OutputStream getOutputStream() throws IOException {
        return delegate.getOutputStream();
    }

    /**
     * <code>doInput</code> եͤꤷͤꤷޤ
     *
     * @param  doinput 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#setDoInput(boolean)
     */
    public void setDoInput(boolean doinput) {
        delegate.setDoInput(doinput);
    }

    /**
     * <code>doInput</code> ե饰֤ͤޤ
     *
     * @return <code>doInput</code> ե饰
     *
     * @see    java.net.URLConnection#getDoInput()
     */
    public boolean getDoInput() {
        return delegate.getDoInput();
    }

    /**
     * <code>doOutput</code> եɤͤ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  dooutput 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#setDoOutput(boolean)
     */
    public void setDoOutput(boolean dooutput) {
        delegate.setDoOutput(dooutput);
    }

    /**
     * <code>doOutput</code> ե饰֤ͤޤ
     *
     * @return <code>doOutput</code> ե饰
     *
     * @see    java.net.URLConnection#getDoOutput()
     */
    public boolean getDoOutput() {
        return delegate.getDoOutput();
    }

    /**
     * <code>allowUserInteraction</code> եͤꤷޤ
     *
     * @param  allowuserinteraction 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#setAllowUserInteraction(boolean)
     */
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        delegate.setAllowUserInteraction(allowuserinteraction);
    }

    /**
     * <code>allowUserInteraction</code> ե֤ͤޤ
     *
     * @return <code>allowUserInteraction</code> ե
     *
     * @see    java.net.URLConnection#getAllowUserInteraction()
     */
    public boolean getAllowUserInteraction() {
        return delegate.getAllowUserInteraction();
    }

    /**
     * <code>useCaches</code> եɤ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  usecaches 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#setUseCaches(boolean)
     */
    public void setUseCaches(boolean usecaches) {
        delegate.setUseCaches(usecaches);
    }

    /**
     * <code>useCaches</code> ե֤ͤޤ
     *
     * @return <code>useCaches</code> ե
     *
     * @see    java.net.URLConnection#getUseCaches()
     */
    public boolean getUseCaches() {
        return delegate.getUseCaches();
    }

    /**
     * <code>ifModifiedSince</code> եͤ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  ifmodifiedsince 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#setIfModifiedSince(long)
     */
    public void setIfModifiedSince(long ifmodifiedsince) {
        delegate.setIfModifiedSince(ifmodifiedsince);
    }

    /**
     * <code>ifModifiedSince</code> ե֤ͤޤ
     *
     * @return <code>ifModifiedSince</code> ե
     *
     * @see    java.net.URLConnection#getIfModifiedSince()
     */
    public long getIfModifiedSince() {
        return delegate.getIfModifiedSince();
    }

    /**
     * <code>useCaches</code> ե饰Υǥե֤ͤޤ
     *
     * @return <code>useCaches</code> ե饰Υǥե
     *
     * @see    java.net.URLConnection#getDefaultUseCaches()
     */
    public boolean getDefaultUseCaches() {
        return delegate.getDefaultUseCaches();
    }

    /**
     * <code>useCaches</code> եɤΥǥեͤ
     * ꤵ줿ͤꤷޤ
     *
     * @param  defaultusecaches 
     *
     * @see    java.net.URLConnection#setDefaultUseCaches(boolean)
     */
    public void setDefaultUseCaches(boolean defaultusecaches) {
        delegate.setDefaultUseCaches(defaultusecaches);
    }

    /**
     * ꥯȥץѥƥꤷޤ
     *
     * @param  key   
     * @param  value 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     * @throws NullPointerException  <code>null</code> ξ
     *
     * @see    java.net.URLConnection#setRequestProperty(String, String)
     */
    public void setRequestProperty(String key, String value) {
        delegate.setRequestProperty(key, value);
    }

    /**
     * ꥯȥץѥƥɲäޤ
     *
     * @param  key   
     * @param  value 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     * @throws NullPointerException  <code>null</code> ξ
     *
     * @see    java.net.URLConnection#addRequestProperty(String, String)
     */
    public void addRequestProperty(String key, String value) {
        delegate.addRequestProperty(key, value);
    }

    /**
     * ꥯȥץѥƥ֤ޤ
     *
     * @param  key   
     *
     * @return ꥽
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#getRequestProperty(String)
     */
    public String getRequestProperty(String key) {
        return delegate.getRequestProperty(key);
    }

    /**
     * ꥯȥץѥƥ֤ޤ
     *
     * @return ꥯȥץѥƥ
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    java.net.URLConnection#getRequestProperties()
     */
    public Map getRequestProperties() {
        return delegate.getRequestProperties();
    }

//### HttpURLConnection
    /**
     * 쥯ȤԤɤꤷޤ
     *
     * @param  followRedirects 쥯Ȥ <code>true</code>
     *                         ʤ <code>false</code>
     *
     * @see    java.net.HttpURLConnection#setInstanceFollowRedirects(boolean)
     */
    public void getInstanceFollowRedirects(boolean followRedirects) {
        delegate.setInstanceFollowRedirects(followRedirects);
    }

    /**
     * 쥯ȤԤɤ֤ޤ
     *
     * @return 쥯Ȥ <code>true</code>
     *         ʤ <code>false</code>
     *
     * @see    java.net.HttpURLConnection#getInstanceFollowRedirects()
     */
    public boolean getInstanceFollowRedirects() {
        return delegate.getInstanceFollowRedirects();
    }

    /**
     * URL ׵Υ᥽åɤꤷޤ
     *
     * @param  method HTTP ᥽å
     *
     * @throws ProtocolException ᥽åɤꥻåȤǤʤ硢
     *                           ޤ׵ᤷ᥽åɤ̵ξ
     *
     * @see    java.net.HttpURLConnection#setRequestMethod(String)
     */
    public void setRequestMethod(String method) throws ProtocolException {
        delegate.setRequestMethod(method);
    }

    /**
     * ׵᥽åɤޤ
     *
     * @return HTTP ׵᥽å
     *
     * @see    java.net.HttpURLConnection#getRequestMethod()
     */
    public String getRequestMethod() {
        return delegate.getRequestMethod();
    }

    /**
     * HTTP 쥹ݥ󥹥ɤ֤ޤ
     *
     * @return HTTP 쥹ݥ󥹥
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     *
     * @see    java.net.HttpURLConnection#getResponseCode()
     */
    public int getResponseCode() throws IOException {
        return delegate.getResponseCode();
    }

    /**
     * Фαɤ HTTP åޤޤƤ硢
     * ֤ޤ
     *
     * @return HTTP åޤ <code>null</code>
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     *
     * @see    java.net.HttpURLConnection#getResponseMessage()
     */
    public String getResponseMessage() throws IOException {
        return delegate.getResponseMessage();
    }

    /**
     * Ǥޤ
     *
     * @see    java.net.HttpURLConnection#disconnect()
     */
    public void disconnect() {
        delegate.disconnect();
    }

    /**
     * ץѤ뤫ɤ֤ޤ
     *
     * @return ץѤ <code>true</code>
     *         Ѥʤ <code>false</code>
     *
     * @see    java.net.HttpURLConnection#usingProxy()
     */
    public boolean usingProxy() {
        return delegate.usingProxy();
    }

    /**
     * HTTP 顼ȯʥ쥹ݥ󥹥ɤ 400 ʾˤˡ
     * ϥȥ꡼֤ޤ
     *
     * @return 顼ξϥȥ꡼
     *
     * @see    java.net.HttpURLConnection#getErrorStream()
     */
    public InputStream getErrorStream() {
        return delegate.getErrorStream();
    }

//### HttpsURLConnection
    /**
     * ³ǻѤƤ沽֤ޤ
     *
     * @return 沽
     *
     * @see    HttpsURLConnection#getCipherSuite()
     */
    public String getCipherSuite() {
        return delegate.getCipherSuite();
    }

    /**
     * ϥɥ˥Ф줿֤ޤ
     *
     * @return 
     *         饤ȼȤξ񡢾ȯԶɤν¤Ǥ롣
     *         ʤä <code>null</code>
     *
     * @see    HttpsURLConnection#getLocalCertificates()
     */
    public Certificate[] getLocalCertificates() {
        return delegate.getLocalCertificates();
    }

    /**
     * åȤꤵ줿Фξ֤ޤ
     *
     * @return о
     *         ԥȤξ񡢾ȯԶɤν¤Ǥ
     *
     * @throws SSLPeerUnverifiedException ԥǧʤä
     *
     * @see    HttpsURLConnection#getServerCertificates()
     */
    public Certificate[] getServerCertificates()
            throws SSLPeerUnverifiedException {
        return delegate.getServerCertificates();
    }

//### sun.net.www.protocol.http.HttpURLConnection
    /**
     *  HTTPS 饤Ȥޤ
     *
     * @param  url URL
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     */
    protected void setNewClient(URL url) throws IOException {
        delegate.setNewClient(url, false);
    }

    /**
     *  HTTPS 饤Ȥޤ
     *
     * @param  url      URL
     * @param  useCache åѤǤ <code>true</code>
     *                  ʳξ <code>false</code>
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     */
    protected void setNewClient(URL url, boolean useCache) throws IOException {
        delegate.setNewClient(url, useCache);
    }

    /**
     * ץͳ HTTPS 饤Ȥޤ
     *
     * @param  url       URL
     * @param  proxyHost ץΥۥ
     * @param  proxyPort ץΥݡ
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     */
    protected void setProxiedClient(URL url, String proxyHost, int proxyPort)
            throws IOException {
        delegate.setProxiedClient(url, proxyHost, proxyPort);
    }

    /**
     * ץͳ HTTPS 饤Ȥޤ
     *
     * @param  url       URL
     * @param  proxyHost ץΥۥ
     * @param  proxyPort ץΥݡ
     * @param  useCache  åѤǤ <code>true</code>
     *                   ʳξ <code>false</code>
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     */
    protected void setProxiedClient(URL url, String proxyHost, int proxyPort,
                                    boolean useCache) throws IOException {
        delegate.setProxiedClient(url, proxyHost, proxyPort, useCache);
    }

//### sun.net.www.protocol.https.AbstractDelegateHttpsURLConnection
    /**
     * ³椫֤ޤ
     *
     * @return ³ξ <code>true</code>
     *         ʳξ <code>false</code>
     *
     */
    protected boolean isConnected() {
        return delegate.isConnected();
    }

    /**
     * ³֤ѹޤ
     *
     * @param  conn ³ˤ <code>true</code>
     *              ʳξ <code>false</code>
     */
    protected void setConnected(boolean conn) {
        delegate.setConnected(conn);
    }

    /**
     * åȤꤵ줿Фξ֤ޤ
     *
     * @return о
     *         ԥȤξ񡢾ȯԶɤν¤Ǥ
     */
    public X509Certificate[] getServerCertificateChain() {
        try {
            return delegate.getServerCertificateChain();
        } catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }
}
