/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.https;


import java.io.BufferedOutputStream;
import java.io.PrintStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;

/**
 * Sun  <code>https</code> 饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class SunHttpsClient
        extends sun.net.www.http.HttpClient
        implements HandshakeCompletedListener {

    private static final int DEFAULT_PORT       = 443;
    private static final int DEFAULT_PROXY_PORT = 80;

    private HostnameVerifier hv;
    private SSLSocketFactory sslSocketFactory;

    private String      instTunnelHost;
    private int         instTunnelPort;

    private SSLSession  session;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  sf        åȥեȥ
     * @param  url       URL
     * @param  proxy     ץۥ
     * @param  proxyPort ץݡ
     *
     * @throws IOException I/O顼ȯ
     */
    SunHttpsClient(SSLSocketFactory sf, URL url, String proxy, int proxyPort)
            throws IOException {
        setSSLSocketFactory(sf);
        if (proxy != null) {
            setTunnelProxy(proxy, proxyPort);
        }

        this.proxyDisabled = true;
        this.url           = url;
        this.host          = url.getHost();
        this.port          = url.getPort();
        if (this.port == -1) {
            this.port = getDefaultPort();
        }

        openServer();
    }

    /**
     * Keep-Alive ¸ߤϤ֤
     * ̵ϥ󥹥󥹤ޤ
     *
     * @param  sf  åȥեȥ
     * @param  url URL
     * @param  hv  ۥ̾٥ե
     *
     * @return 󥹥
     *
     * @throws IOException I/O顼ȯ
     */
    static SunHttpsClient getInstance(SSLSocketFactory sf, URL url, HostnameVerifier hv)
            throws IOException {
        return SunHttpsClient.getInstance(sf, url, hv, (String) null, -1, true);
    }

    /**
     * Keep-Alive ¸ߤϤ֤
     * ̵ϥ󥹥󥹤ޤ
     *
     * @param  sf        åȥեȥ
     * @param  url       URL
     * @param  hv        ۥ̾٥ե
     * @param  proxy     ץۥ
     * @param  proxyPort ץݡ
     * @param  useCache  åѤ뤫
     *
     * @return 󥹥
     *
     * @throws IOException I/O顼ȯ
     */
    static SunHttpsClient getInstance(SSLSocketFactory sf, URL url, HostnameVerifier hv,
                                      String proxy, int proxyPort, boolean useCache)
            throws IOException {
        SunHttpsClient ret = null;
        if (useCache) {
            if ((ret = (SunHttpsClient) kac.get(url, sf)) != null) {
                ret.cachedHttpClient = true;
            }
        }

        if (ret == null) {
            ret = new SunHttpsClient(sf, url, proxy, proxyPort);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(url.getHost(), url.getPort());
            }
            ret.url = url;
        }
        ret.setHostnameVerifier(hv);

        return ret;
    }

    /**
     * Ф³ޤ
     * ʥ硼ȥåȡϥС饤ɤɬפ̵
     *
     * @throws IOException I/O顼ȯ
     */
    protected synchronized void openServer()
            throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(host, port);
        }

        if (isKeepingAlive()) {
            return;
        }

        openServer(host, port);
        usingProxy = false;
    }

    /**
     * ǥեȥݡȤ֤ޤ
     *
     * @return ǥեȥݡ
     */
    protected int getDefaultPort() {
        return DEFAULT_PORT;
    }

    /**
     * ۥ̾٥եꤷޤ
     *
     * @param  hv ۥ̾٥ե
     */
    void setHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    /**
     * SSL åȥեȥޤ
     *
     * @return SSL åȥեȥ
     */
    SSLSocketFactory getSSLSocketFactory() {
        return sslSocketFactory;
    }

    /**
     * SSL åȥեȥꤷޤ
     *
     * @param sf SSL åȥեȥ
     */
    void setSSLSocketFactory(SSLSocketFactory sf) {
        sslSocketFactory = sf;
    }

    /**
     * ץꤷޤ
     *
     * @param  proxy     ץۥ
     * @param  proxyPort ץݡ
     */
    void setTunnelProxy(String proxy, int proxyPort) {
        instTunnelHost = proxy;
        instTunnelPort = (proxyPort < 0) ? getDefaultPort() : proxyPort;
    }

    /**
     * ȥͥ󥰤ɬפ뤫֤ޤ
     *
     * @return ȥͥ󥰤ɬפ <code>true</code>
     *         ɬפʤ <code>false</code>
     */
    public boolean needsTunneling() {
        return (instTunnelHost != null);
    }

    /**
     * ΥץΥۥ֤̾ޤ
     *
     * @return ץۥ
     */
    public String getProxyHostUsed() {
        if (!needsTunneling()) {
            return null;
        }
        return instTunnelHost;
    }

    /**
     * ΥץΥݡȤ֤ޤ
     *
     * @return ץݡ
     */
    public int getProxyPortUsed() {
        return instTunnelPort;
    }

    /**
     * ºݤ³ޤ
     *
     * @param  host ۥ
     * @param  port ݡ
     *
     * @return å
     *
     * @throws IOException I/O顼ȯ
     * @throws java.net.UnknownHostException ۥȤ¸ߤʤä
     */
    protected Socket doConnect(String host, int port) throws IOException {
        instTunnelHost = ((instTunnelHost != null) ? instTunnelHost : getProxyHost());
        instTunnelPort = ((instTunnelPort != 0   ) ? instTunnelPort : getProxyPort());

        Socket           s       = null;
        SSLSocketFactory factory = sslSocketFactory;

        if (instTunnelHost == null) {
            s = factory.createSocket(host, port);
        } else {
            try {
                s = (Socket) AccessController.doPrivileged(
                    new PrivilegedExceptionAction() {
                        /** ¹ */
                        public Object run()
                                throws IOException {
                            return new Socket(instTunnelHost, instTunnelPort);
                        }
                    }
                );
            } catch (PrivilegedActionException e) {
                try {
                    s = (SSLSocket) factory.createSocket(host, port);
                } catch (IOException ignored) {
                    throw (IOException) e.getException();
                }
            }
        }
        return s;
    }

    /**
     * ³Ԥޤ
     *
     * @throws IOException I/O顼ȯ
     * @throws java.net.UnknownHostException ۥȤ¸ߤʤä
     */
    public void afterConnect() throws IOException {
        if (!isCachedConnection()) {
            SSLSocket        s       = null;
            SSLSocketFactory factory = sslSocketFactory;
            try {
                s = (serverSocket instanceof SSLSocket)
                    ? (SSLSocket) serverSocket
                    : (SSLSocket) factory.createSocket(serverSocket, host, port, true);
            } catch (IOException e) {
                try {
                    s = (SSLSocket) factory.createSocket(host, port);
                } catch (IOException ignored) {
                    throw e;
                }
            }

            com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl.checkCreate(s);

            String [] protocols = getProtocols   ();
            String [] ciphers   = getCipherSuites();
            if (protocols != null) { s.setEnabledProtocols   (protocols); }
            if (ciphers   != null) { s.setEnabledCipherSuites(ciphers  ); }

            s.addHandshakeCompletedListener(this);
            s.startHandshake();
            session = s.getSession();
            serverSocket = s;
            try {
                serverOutput = new PrintStream(new BufferedOutputStream(serverSocket.getOutputStream()), false, encoding);
            } catch (UnsupportedEncodingException e) {
                throw new InternalError(encoding + " encoding not found");
            }

            checkURLSpoofing(hv);
        } else {
            session = ((SSLSocket) serverSocket).getSession();
        }
    }

    /** URL åRFC 2818: HTTP over TLS Section 3.1 Server Identity */
    private void checkURLSpoofing(HostnameVerifier hostnameVerifier)
            throws IOException {
        String  host = url.getHost();

        if (host != null && host.startsWith("[") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }

        Certificate[] peerCerts = null;
        try {
            peerCerts = session.getPeerCertificates();

            X509Certificate peerCert;
            if (peerCerts[0] instanceof X509Certificate) {
                peerCert = (X509Certificate) peerCerts[0];
            } else {
                throw new SSLPeerUnverifiedException("");
            }

            sun.security.util.HostnameChecker checker
                = sun.security.util.HostnameChecker.getInstance(sun.security.util.HostnameChecker.TYPE_TLS);

            checker.match(host, peerCert);
            return;
        } catch (SSLPeerUnverifiedException e) {
        } catch (CertificateException cpe) {
        }

        String cipher = session.getCipherSuite();
        if ((cipher != null) && (cipher.indexOf("_anon_") != -1)) {
            return;
        }

        if ((hostnameVerifier != null) && (hostnameVerifier.verify(host, session))) {
            return;
        }

        serverSocket.close();
        session.invalidate();

        throw new IOException("HTTPS hostname wrong:  should be <" + url.getHost() + ">");
    }

    /**
     * ץ饤֤Υå˼ʬϿޤ
     */
    protected void putInKeepAliveCache() {
        kac.put(url, sslSocketFactory, this);
    }

    /**
     * ??
     *
     * @return ??
     */
    String getCipherSuite() {
        return session.getCipherSuite();
    }

    /**
     * ??
     *
     * @return ??
     */
    public Certificate [] getLocalCertificates() {
        return session.getLocalCertificates();
    }

    /**
     * ??
     *
     * @return ??
     *
     * @throws SSLPeerUnverifiedException ??
     */
    Certificate [] getServerCertificates()
            throws SSLPeerUnverifiedException {
        return session.getPeerCertificates();
    }

    /**
     * ??
     *
     * @return ??
     *
     * @throws SSLPeerUnverifiedException ??
     */
    javax.security.cert.X509Certificate [] getServerCertificateChain()
                throws SSLPeerUnverifiedException {
        return session.getPeerCertificateChain();
    }

    /**
     * ??
     *
     * @param event ??
     */
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        session = event.getSession();
    }

    /**
     * ץѥƥץۥȤ֤ޤ
     *
     * @return ץۥ
     */
    private String getProxyHost() {
        String host = (String) AccessController.doPrivileged(new sun.security.action.GetPropertyAction("https.proxyHost"));
        if (host != null && host.length() == 0) {
            host = null;
        }
        return host;
    }

    /** ץݡȤʥץѥƥ */
    private int getProxyPort() {
        final int[] port = {0};
        AccessController.doPrivileged(
            new PrivilegedAction() {
                /** ¹ */
                public Object run() {
                    if (System.getProperty("https.proxyHost") != null) {
                        port[0] = Integer.getInteger("https.proxyPort", DEFAULT_PROXY_PORT).intValue();
                    }
                    return null;
                }
            }
        );
        return (port[0] < 0) ? super.getDefaultPort() : port[0];
    }

    /** HTTPS ǥݡȤץȥ */
    private String [] getProtocols() {
        String[] protocols;
        String   protocolString = (String) AccessController.doPrivileged(new sun.security.action.GetPropertyAction("https.protocols"));

        if (protocolString == null || "".equals(protocolString)) {
            protocols = null;
        } else {
            StringTokenizer tokenizer;
            Vector          v = new Vector();

            tokenizer = new StringTokenizer(protocolString, ",");
            while (tokenizer.hasMoreElements()) {
                v.addElement(tokenizer.nextElement());
            }
            protocols = new String [v.size()];
            for (int i = 0; i < protocols.length; i++) {
                protocols [i] = (String) v.elementAt(i);
            }
        }
        return protocols;
    }

    /** HTTPS ǥݡȤŹ沽 */
    private String [] getCipherSuites() {
        String[] ciphers;
        String   cipherString = (String) AccessController.doPrivileged(new sun.security.action.GetPropertyAction("https.cipherSuites"));

        if (cipherString == null || "".equals(cipherString)) {
            ciphers = null;
        } else {
            StringTokenizer tokenizer;
            Vector          v = new Vector();

            tokenizer = new StringTokenizer(cipherString, ",");
            while (tokenizer.hasMoreElements()) {
                v.addElement(tokenizer.nextElement());
            }
            ciphers = new String [v.size()];
            for (int i = 0; i < ciphers.length; i++) {
                ciphers [i] = (String) v.elementAt(i);
            }
        }
        return ciphers;
    }
}
