/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.https;

import net.hizlab.kagetaka.protocol.SuperHandler;
import net.hizlab.kagetaka.protocol.URLConnectionCache;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;

/**
 * Sun  <code>https</code> ץȥϥɥåѡǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class SunHandler extends sun.net.www.protocol.https.Handler implements SuperHandler {
    /**
     * 󥹥󥹤ޤ
     */
    public SunHandler() {
        super();
    }

    /**
     * ֤ͥޤ
     *
     * @param  url URL
     *
     * @return ͥ
     *
     * @throws IOException ³γΩ I/O顼ȯ
     */
    public synchronized URLConnection openConnection(URL url)
            throws IOException {
        String proxyHost = null;
        int    proxyPort = -1;
        String path = url.getFile();
        if (path != null && path.startsWith("https://")) {
            String ref = url.getRef();
            if (ref != null) {
                path += "#" + ref;
            }
            try {
                proxyHost = url.getHost();
                proxyPort = url.getPort();
                url = new URL(path);
            } catch (MalformedURLException e) {
                proxyHost = null;
                proxyPort = -1;
            }
        }

        path = url.getFile();
        if (path == null || path.length() == 0) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/");
        }

        URLConnectionCache.Entry cacheEntry = URLConnectionCache.getEntry(url);

        if (proxyHost == null) {
            proxyHost = cacheEntry.getProxyHost();
            proxyPort = cacheEntry.getProxyPort();
        } else {
            cacheEntry.setProxy(proxyHost, proxyPort);
        }

        return new SunHttpsURLConnection(url, this, proxyHost, proxyPort, cacheEntry);
    }
}
