/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.https;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.io.TeeInputStream;
import net.hizlab.kagetaka.protocol.CacheFile;
import net.hizlab.kagetaka.protocol.CacheManager;
import net.hizlab.kagetaka.protocol.CacheSupported;
import net.hizlab.kagetaka.protocol.ProxySupported;
import net.hizlab.kagetaka.protocol.URLConnectionCache;
import net.hizlab.kagetaka.rendering.PostData;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Map;

import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

/**
 * å򥵥ݡȤ <code>https</code> ץȥΥͥɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class SunDelegateHttpsURLConnection
        extends sun.net.www.protocol.https.AbstractDelegateHttpsURLConnection
        implements CacheSupported, ProxySupported {
    private static final String HTTP_VERSION = "HTTP/1.1";
    private static final int    DEFAULT_PORT = 80;
    private static final int    CODE_300     = 300;
    private static final int    CODE_400     = 400;

    private HttpsURLConnection httpsURLConnection;
    private String             proxyHost;
    private int                proxyPort;
    private String             proxyAuthorization;

    private sun.net.www.MessageHeader responses;
    private URLConnectionCache.Entry  cacheEntry;
    private CacheManager              cacheManager;
    private CacheFile                 cacheFile;
    private boolean                   validCacheFile;
    private PostData                  postData;
    private InputStream               inputStream;
    private boolean                   reentrantInputStream;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  url                URL
     * @param  handler            ץȥϥɥ
     * @param  httpsURLConnection ͥ
     * @param  proxyHost          ץۥ
     * @param  proxyPort          ץݡ
     * @param  cacheEntry         å奨ȥ
     *
     * @throws IOException I/O顼ȯ
     */
    SunDelegateHttpsURLConnection(URL url,
                                  sun.net.www.protocol.http.Handler handler,
                                  HttpsURLConnection httpsURLConnection,
                                  String proxyHost, int proxyPort,
                                  URLConnectionCache.Entry cacheEntry)
            throws IOException {
        super(url, handler);
        this.httpsURLConnection = httpsURLConnection;
        this.proxyHost          = proxyHost;
        this.proxyPort          = proxyPort;
Debug.out.println("@url=" + url);

        // إå
        cacheEntry.setupURLConnection(this);
        this.cacheEntry = cacheEntry;
    }

//### CacheSupported
    /** {@inheritDoc} */
    public void setupCache(CacheManager cm, PostData pd) {
        this.cacheManager = cm;
        this.postData     = pd;
    }

    /** {@inheritDoc} */
    public void removeCache() {
        cacheEntry.dispose();
        if (validCacheFile && cacheManager != null) {
            cacheManager.removeEntry(this, postData);
        }
    }

    /** {@inheritDoc} */
    public String getCachePath() {
        if (cacheFile != null) {
            return cacheFile.getPath();
        }

        return null;
    }

//### SSL
    /**
     * SSL åȥեȥޤ
     *
     * @return SSL åȥեȥ
     */
    protected SSLSocketFactory getSSLSocketFactory() {
        return httpsURLConnection.getSSLSocketFactory();
    }

    /**
     * ۥ̾٥եޤ
     *
     * @return ۥ̾٥ե
     */
    protected HostnameVerifier getHostnameVerifier() {
        return httpsURLConnection.getHostnameVerifier();
    }

//### URLConnection
    /**
     * ³Ԥޤ
     *
     * @throws IOException IO 顼ȯ
     */
    public void connect()
            throws IOException {
        if (connected) {
            return;
        }

        // Connector ƤФ줿ȤʳΤߡå夫ɤ߹
        if (cacheManager == null
                && (cacheFile = cacheEntry.getCacheFile()) != null) {
            try {
                inputStream     = cacheFile.getInputStream();
Debug.out.println("isHit=" + cacheFile.getName() + "," + url);
                validCacheFile  = true;
                connected       = true;
                responseCode    = HTTP_OK;
                responseMessage = "OK";
                return;
            } catch (IOException e) {
Debug.out.println(e);
            }
        }

        connect(true);
    }

    /** ³ */
    private void connect(boolean useCache)
            throws IOException {
        if (proxyHost == null) {
            plainConnect();
        } else {
            proxiedConnect(url, proxyHost, proxyPort, useCache);
            if (!http.isCachedConnection()) {
                doTunneling();
            }
        }

        if (inputStream == null) {
            ((SunHttpsClient) http).afterConnect();
        }
    }

    /**
     * ľ³μºݤνԤޤ
     *
     * @throws IOException IO 顼ȯ
     */
    protected void plainConnect()
            throws IOException {
        if (connected) {
            return;
        }

        http = SunHttpsClient.getInstance(getSSLSocketFactory(),
                                          url,
                                          getHostnameVerifier());
        connected = true;
    }

    /**
     * ץͳ³μºݤνԤޤ
     *
     * @param  url       ³ URL
     * @param  proxyHost ץۥ
     * @param  proxyPort ץݡ
     * @param  useCache  åѤ <code>true</code>
     *                   ʤ <code>false</code>
     *
     * @throws IOException IO 顼ȯ
     */
    protected void proxiedConnect(URL url, String proxyHost, int proxyPort, boolean useCache)
            throws IOException {
        if (connected) {
            return;
        }

        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(proxyHost, proxyPort);
        }
        http = SunHttpsClient.getInstance(getSSLSocketFactory(),
                                          url,
                                          getHostnameVerifier(),
                                          proxyHost, proxyPort, useCache);
        connected = true;
    }

    /**
     * HTTPS 饤Ȥޤ
     *
     * @param  url      ³ URL
     * @param  useCache åѤ <code>true</code>
     *                  ʤ <code>false</code>
     *
     * @throws IOException IO 顼ȯ
     */
    public void setNewClient(URL url, boolean useCache)
            throws IOException {
        http = SunHttpsClient.getInstance(getSSLSocketFactory(),
                                          url,
                                          getHostnameVerifier(),
                                          proxyHost, proxyPort, useCache);

        if (inputStream == null) {
            ((SunHttpsClient) http).afterConnect();
        }
    }

    /**
     * ץѤ褦ꤷޤ
     *
     * @param  url       ³ URL
     * @param  proxyHost ץۥ
     * @param  proxyPort ץݡ
     * @param  useCache  åѤ <code>true</code>
     *                   ʤ <code>false</code>
     *
     * @throws IOException IO 顼ȯ
     */
    public void setProxiedClient(URL url, String proxyHost, int proxyPort, boolean useCache)
            throws IOException {
        proxiedConnect(url, proxyHost, proxyPort, useCache);
        if (!http.isCachedConnection()) {
            doTunneling();
        }
        ((SunHttpsClient) http).afterConnect();
    }

    /**
     * ȥͥޤ
     *
     * @throws IOException IO 顼ȯ
     */
    protected synchronized void doTunneling()
            throws IOException {
        sun.net.www.MessageHeader responses = new sun.net.www.MessageHeader();

        if (!connected) {
            proxiedConnect(url, proxyHost, proxyPort, false);
        }

        sendCONNECTRequest();
        http.parseHTTP(responses, new sun.net.ProgressEntry(url.getFile(), null));

        StringTokenizer st = new StringTokenizer(responses.getValue(0));
        st.nextToken();

        int respCode = Integer.parseInt(st.nextToken().trim());

        // HTTP 200 OK
        if (respCode == HTTP_OK) {
            return;
        }

        this.responseCode = respCode;
        this.responses    = responses;
        this.inputStream  = new HttpInputStream(http.getInputStream());
    }

    /** CONNECT  */
    private void sendCONNECTRequest()
            throws IOException {
        sun.net.www.MessageHeader requests = new sun.net.www.MessageHeader();

        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }

        requests.prepend("CONNECT " + url.getHost() + ":" + port + " " + HTTP_VERSION, null);

        String host = url.getHost();
        if (port != -1 && port != DEFAULT_PORT) {
            host += ":" + String.valueOf(port);
        }
        requests.set("Host", host);

        copyRequestProperty(requests, "User-Agent"     );
        copyRequestProperty(requests, "Accept"         );
        copyRequestProperty(requests, "Accept-Language");
        copyRequestProperty(requests, "Accept-Encoding");
        copyRequestProperty(requests, "Accept-Charset" );

        if (proxyAuthorization != null) {
            requests.set("Proxy-Authorization", proxyAuthorization);
        }

        http.writeRequests(requests, null);
    }

    /** ꤵƤ */
    private void copyRequestProperty(sun.net.www.MessageHeader requests, String key) {
        String value = getRequestProperty(key);
        if (value != null) {
            requests.set(key, value);
        }
    }

    /**
     * ꥯȥץѥƥꤷޤ
     *
     * @param  key   
     * @param  value 
     */
    public void setRequestProperty(String key, String value) {
        if (key.equalsIgnoreCase("proxy-authorization")) {
            this.proxyAuthorization = value;
        } else {
            super.setRequestProperty(key, value);
        }

        // 󥹥ȥ饯 cacheEntry.setupURLConnection(this);
        // ƤФ줿ϡϿʤ褦ˤ
        if (cacheEntry != null) {
            cacheEntry.setRequestProperty(key, value);
        }
    }

    /**
     * ꥯȥץѥƥɲäޤ
     *
     * @param  key   
     * @param  value 
     */
    public void addRequestProperty(String key, String value) {
        if (key.equalsIgnoreCase("proxy-authorization")) {
            this.proxyAuthorization = value;
        } else {
            super.addRequestProperty(key, value);
        }

        // 󥹥ȥ饯ƤФ줿ϡϿʤ褦ˤ
        if (cacheEntry != null) {
            cacheEntry.addRequestProperty(key, value);
        }
    }

    /**
     * 쥹ݥ󥹤ɤ߹ϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized InputStream getInputStream()
            throws IOException {
        if (!connected) {
            connect();
        }

        if (inputStream != null) {
            return inputStream;
        }

        if (reentrantInputStream) {
            return super.getInputStream();
        }

        reentrantInputStream = true;
        try {
            InputStream is = super.getInputStream();

            if (cacheManager != null && responseCode < CODE_300) {
                if ((cacheFile = cacheManager.getFile(this)) != null) {
                    is = new TeeInputStream(is, new CacheOutputStream(cacheFile), getContentLength());
                }
            }

if (responseCode == HTTP_NOT_MODIFIED) {
Debug.out.println("isNmod=," + url);
} else {
Debug.out.println("isMiss=" + (cacheFile != null ? cacheFile.getName() : "") + "," + url);
}
            return (inputStream = is);
        } finally {
            reentrantInputStream = false;
        }
    }

    /**
     * 顼ξ˥쥹ݥ󥹤ɤ߹ϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     */
    public InputStream getErrorStream() {
        if (connected && responseCode >= CODE_400 && inputStream != null) {
            return inputStream;
        }

        return super.getErrorStream();
    }

    /**
     * إå̾б쥹ݥ󥹥إåޤ
     *
     * @param  name إå̾
     *
     * @return 쥹ݥ󥹥إå
     */
    public String getHeaderField(String name) {
        try {
            getInputStream();
        } catch (IOException e) { }

        return (responses != null)
               ? responses.findValue(name)
               : super.getHeaderField(name);
    }

    /**
     * 쥹ݥ󥹥إåޤ
     *
     * @return 쥹ݥ󥹥إå
     */
    public Map getHeaderFields() {
        try {
            getInputStream();
        } catch (IOException e) { }

        return (responses != null)
               ? responses.getHeaders()
               : super.getHeaderFields();
    }

    /**
     * إåΰ֤б쥹ݥ󥹥إåޤ
     *
     * @param  n إå
     *
     * @return 쥹ݥ󥹥إå
     */
    public String getHeaderField(int n) {
        try {
            getInputStream();
        } catch (IOException e) { }

        return (responses != null)
               ? responses.getValue(n)
               : super.getHeaderField(n);
    }

    /**
     * إåΰ֤б쥹ݥ󥹥إå̾ޤ
     *
     * @param  n إå
     *
     * @return 쥹ݥ󥹥إå̾
     */
    public String getHeaderFieldKey(int n) {
        try {
            getInputStream();
        } catch (IOException e) { }

        return (responses != null)
               ? responses.getKey(n)
               : super.getHeaderFieldKey(n);
    }

//### HttpInputStream
    /** ץåȥȥ꡼ */
    private final class HttpInputStream extends FilterInputStream {
        /** 󥹥󥹤 */
        private HttpInputStream(InputStream is) {
            super(is);
        }

        /** Ĥ */
        public void close()
                throws IOException {
            try {
                super.close();
            } finally {
                SunDelegateHttpsURLConnection.this.http = null;
            }
        }
    }

//### CacheOutputStream
    /** åϥȥ꡼ */
    private final class CacheOutputStream extends FileOutputStream {
        /** 󥹥󥹤 */
        private CacheOutputStream(File file)
                throws IOException {
            super(file);
        }

        /** Ĥ */
        public void close()
                throws IOException {
            synchronized (SunDelegateHttpsURLConnection.this) {
                if (validCacheFile) {
                    return;
                }
                super.close();

                validCacheFile = true;

                // åɲ
                cacheEntry.setCacheFile(cacheFile);
                if (cacheManager != null) {
                    cacheManager.addEntry(SunDelegateHttpsURLConnection.this, postData, cacheFile);
                }
            }
        }
    }
}
