/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.https;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.net.HttpsClient;
import net.hizlab.kagetaka.net.MessageHeader;
import net.hizlab.kagetaka.net.SSL;
import net.hizlab.kagetaka.protocol.URLConnectionCache;
import net.hizlab.kagetaka.protocol.http.Hawk2HttpURLConnection;

import java.io.InputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.security.cert.Certificate;
import java.util.StringTokenizer;

import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLPeerUnverifiedException;

/**
 * Java2 εǽ HTTPS 饤ȤδŪʵǽ󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class Hawk2DelegateHttpsURLConnection extends Hawk2HttpURLConnection {
    private Hawk2HttpsURLConnection httpsURLConnection;

    /**
     * HTTP URL ͥޤ
     *
     * @param  url        ³ URL
     * @param  proxyHost  ץۥ
     * @param  proxyPort  ץݡ
     * @param  cacheEntry å奨ȥ
     * @param  httpsURLConnection HTTPS ͥ
     *
     * @throws IOException ³ΩǤʤ
     */
    Hawk2DelegateHttpsURLConnection(URL url, String proxyHost, int proxyPort,
                                    URLConnectionCache.Entry cacheEntry,
                                    Hawk2HttpsURLConnection httpsURLConnection)
            throws IOException {
        super(url, proxyHost, proxyPort, cacheEntry);
        this.httpsURLConnection = httpsURLConnection;
    }

//### Object
    /**
     * ١쥯ˤäƸƤӽФޤ
     *
     * @see    Object#finalize()
     */
    protected void finalize() throws Throwable {
        // ̵
    }

//### HttpsURLConnection
    /**
     * ³ǻѤƤ沽֤ޤ
     *
     * @return 沽
     */
    public String getCipherSuite() {
        HttpsClient https = (HttpsClient) http;
        if (https == null) {
            throw new IllegalStateException("connection not yet open");
        }
        SSLSession sslSession = https.getSSLSession();
        return (sslSession != null ? sslSession.getCipherSuite() : null);
    }

    /**
     * ϥɥ˥Ф줿֤ޤ
     *
     * @return 
     *         饤ȼȤξ񡢾ȯԶɤν¤Ǥ롣
     *         ʤä <code>null</code>
     */
    public Certificate[] getLocalCertificates() {
        HttpsClient https = (HttpsClient) http;
        if (https == null) {
            throw new IllegalStateException("connection not yet open");
        }
        SSLSession sslSession = https.getSSLSession();
        return (sslSession != null ? sslSession.getLocalCertificates() : null);
    }

    /**
     * åȤꤵ줿Фξ֤ޤ
     *
     * @return о
     *         ԥȤξ񡢾ȯԶɤν¤Ǥ
     *
     * @throws SSLPeerUnverifiedException ԥǧʤä
     */
    public Certificate[] getServerCertificates()
            throws SSLPeerUnverifiedException {
        HttpsClient https = (HttpsClient) http;
        if (https == null) {
            throw new IllegalStateException("connection not yet open");
        }
        SSLSession sslSession = https.getSSLSession();
        return (sslSession != null ? sslSession.getPeerCertificates() : null);
    }

//### original
    /**
     * ľ³ޤ
     *
     * @throws IOException IO 顼ȯ
     */
    protected synchronized void plainConnect() throws IOException {
        http = HttpsClient.getInstance(url.getProtocol(),
                                       url.getHost(),
                                       url.getPort(),
                                       httpsURLConnection.getSSLSocketFactory(),
                                       httpsURLConnection.getHostnameVerifier());
    }

    /**
     * ץͳ³ޤ
     *
     * @throws IOException IO 顼ȯ
     */
    protected synchronized void proxiedConnect() throws IOException {
        try {
            InputStream in;

            int redirects = 0;

            // 쥯ѤΥ롼
            do {
                MessageHeader requests = null;

                // ƻԥ롼
                for (;;) {
                    http = HttpsClient.getInstance(url.getProtocol(),
                                                   url.getHost(),
                                                   url.getPort(),
                                                   proxyHost,
                                                   proxyPort,
                                                   httpsURLConnection.getSSLSocketFactory(),
                                                   httpsURLConnection.getHostnameVerifier());
                    // Keep-Alive ͭä
                    if (!http.usingProxy()) {
                        return;
                    }

                    // ץѤΥꥯȤ
                    if (requests == null) {
                        requests = setupProxyRequests();
                    }

                    // ץ³ꥯȤ
                    try {
                        in = http.send(requests, null, responses, false, false);
                        break;
                    } catch (IOException e) {
                        try {
                            // ƻԤɬפ̵ϡ顼
                            if (!http.needRetry()) {
                                throw e;
                            }
                        } finally {
                            release();
                        }
                    }
                }

                // HTTP 쥹ݥ󥹥ɤǧ
                CODE_CHECK:
                {
                    String statusLine = responses.get(0);
                    StringTokenizer st = new StringTokenizer(statusLine);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        if (st.hasMoreTokens()) {
                            int code = Integer.parseInt(st.nextToken().trim());

                            // 쥯Ȥξ
                            if (followRedirectProxy(code)) {
                                release();
                                responses.reset();
                                redirects++;
                                continue;
                            }

                            // OK
                            if (code == HTTP_OK) {
                                break CODE_CHECK;
                            }

                            // ץ OK ʳ֤ϡ쥹ݥ󥹤Ȥ
                            inputStream = in;

                            // 400 ʾϥ顼ˤ
                            if (responseException && code >= 400) {
                                if (code == 404 || code == 410) {
                                    rememberedException = new FileNotFoundException(url.toString());
                                } else {
                                    rememberedException = new IOException("Proxy returned HTTP response code: " + code + " for URL: " + url.toString());
                                }
                            }

                            return;
                        }
                    }

                    throw new IOException("Proxy returned invalid HTTP response: " + statusLine);
                }

                // ȥͥ
                http = HttpsClient.getInstance(url.getProtocol(),
                                               url.getHost(),
                                               url.getPort(),
                                               http,
                                               httpsURLConnection.getSSLSocketFactory(),
                                               httpsURLConnection.getHostnameVerifier());
                // إå򥯥ꥢ
                responses.reset();
                return;
            } while (redirects < maxRedirects);

            throw new ProtocolException("Proxy redirected too many times (" + redirects + ")");
        } catch (RuntimeException e) {
Debug.err.println("### ERROR ### Hawk2DelegateHttpsURLConnection.proxiedConnect : " + e);
e.printStackTrace(Debug.err);
            release();
            rememberedException = e;
            throw e;
        } catch (IOException e) {
Debug.out.println("### WARNING ### Hawk2DelegateHttpsURLConnection.proxiedConnect : " + e);
e.printStackTrace(Debug.out);
            release();
            rememberedException = e;
            throw e;
        }
    }

    /** ץǥ쥯Ȥ뤫ɤ֤ */
    private boolean followRedirectProxy(int code) throws IOException {
        if (!getInstanceFollowRedirects()) {
            return false;
        }

        if (code < 300 || code == HTTP_NOT_MODIFIED || code == 306 || code > 307) {
            return false;
        }

        String location = getHeaderField("Location");
        if (location == null) {
            return false;
        }

        URL locationUrl;
        try {
            locationUrl = new URL(location);
            if (!url.getProtocol().equalsIgnoreCase(locationUrl.getProtocol())) {
                return false;
            }
        } catch (MalformedURLException e) {
            locationUrl = new URL(url, location);
        }

        proxyHost = locationUrl.getHost();
        proxyPort = locationUrl.getPort();

        return true;
    }

    /* HTTP ꥯȤ˻Ѥꥯʸ֤ */
    /** {@inheritDoc} */
    protected String getConnectURL() {
        return url.getFile();
    }

    /* ǥեȥݡȤ֤ */
    /** {@inheritDoc} */
    protected int getDefaultPort() {
        return HttpsClient.DEFAULT_PORT;
    }

    /* HTTP ꥯȥإå򥻥åȥå */
    /** {@inheritDoc} */
    protected MessageHeader setupRequests() {
        MessageHeader requests = super.setupRequests();

        // Proxy- ǻϤޤإå
        String key;
        for (int i = 0; ; i++) {
            if ((key = requests.keyAt(i)) == null) {
                break;
            }
            if (key.toLowerCase().startsWith("proxy-")) {
                requests.remove(i--);
            }
        }

        return requests;
    }

    /** ץͳ HTTPS ꥯȥإå򥻥åȥå */
    private MessageHeader setupProxyRequests() {
        MessageHeader src      = this.requests;
        MessageHeader requests = new MessageHeader();

        requests.prepend("CONNECT " + getHostHeader(true) + " "  + HTTP_VERSION, null);
        requests.add    ("Host", getHostHeader(false));

        String userAgent = this.requests.get("user-agent");
        if (userAgent != null) {
            requests.set("User-Agent", userAgent);
        }

        if (http.candoHttpKeepAlive()) {
            requests.add("Proxy-Connection", "keep-alive");
        }

        // Proxy- ǻϤޤإå򥳥ԡ
        String key;
        for (int i = 0; ; i++) {
            if ((key = src.keyAt(i)) == null) {
                break;
            }
            if (key.toLowerCase().startsWith("proxy-")) {
                requests.add(key, src.get(i));
            }
        }

        return requests;
    }

    /* 㳰򥹥 */
    /** {@inheritDoc} */
    protected void checkIOException(IOException exception) throws IOException {
        if (SSL.hasCertificateException(exception)) {
            throw exception;
        }
    }
}
