/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.http;

import net.hizlab.kagetaka.protocol.URLConnectionCache;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

/**
 * Java2 εǽ HTTP 饤ȤδŪʵǽ󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Hawk2HttpURLConnection extends HawkHttpURLConnection {
    /**
     * HTTP URL ͥޤ
     *
     * @param  url        ³ URL
     * @param  proxyHost  ץۥ
     * @param  proxyPort  ץݡ
     * @param  cacheEntry å奨ȥ
     */
    protected Hawk2HttpURLConnection(URL url, String proxyHost, int proxyPort,
                                     URLConnectionCache.Entry cacheEntry) {
        super(url, proxyHost, proxyPort, cacheEntry);

        responseException = true;
    }

//### URLConnection
    /**
     * إåեɤѹԲǽʥޥåפ֤ޤ
     *
     * @return إåեɤΥޥå
     *
     * @see    java.net.URLConnection#getHeaderFields()
     */
    public Map getHeaderFields() {
        try {
            getInputStream();
        } catch (IOException e) { }

        return convertToJava2(responses.getHeaders());
    }

    /**
     * ꥯȥץѥƥɲäޤ
     *
     * @param  key   
     * @param  value 
     */
    public void addRequestProperty(String key, String value) {
        super.addRequestProperty(key, value);

        checkMessageHeader(key, value);
        requests.add(key, value);

        // 󥹥ȥ饯ƤФ줿ϡϿʤ褦ˤ
        if (cacheEntry != null) {
            cacheEntry.addRequestProperty(key, value);
        }
    }

//### HttpURLConnection
    /**
     * ꥯȥץѥƥ֤ޤ
     *
     * @return ꥯȥץѥƥ
     */
    public Map getRequestProperties() {
        if (connected) {
            throw new IllegalStateException("Already connected");
        }

        return convertToJava2(requests.getHeaders(EXCLUDE_HEADERS));
    }

//### private
    /** Hashtable  MapVector  List Ѵ */
    private Map convertToJava2(Hashtable hash) {
        Map       map  = new HashMap();
        String    key;
        Vector    v;
        ArrayList l;
        int       i;
        for (Enumeration e = hash.keys(); e.hasMoreElements();) {
            key = (String) e.nextElement();
            v   = (Vector) hash.get(key);
            l   = new ArrayList();
            for (i = 0; i < v.size(); i++) {
                l.add(v.elementAt(i));
            }
            map.put(key, Collections.unmodifiableList(l));
        }

        return Collections.unmodifiableMap(map);
    }
}
