/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Map;

/**
 * Java21.2 ʹߡˤεǽ {@link URLConnection} åѡǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class URLConnectionWrapper12 extends URLConnectionWrapper {
    /**
     * 󥹥󥹤ޤ
     *
     * @param  url        URL
     * @param  connection ͥ
     * @param  is         ϥȥ꡼ࡣ
     *                    <code>connection</code> 
     *                    <code>null</code>
     */
    public URLConnectionWrapper12(URL url, URLConnection connection,
                                  InputStream is) {
        super(url, connection, is);
    }

//### URLConnection
    /**
     *  URL ³ΥƥĤޤ
     *
     * @param  classes ׵ᤵ줿פ򼨤 <code>Class</code> 
     *
     * @return 饹ǻꤵ줿פǽ˰פ
     *         ֥ȡ
     *         ׵ᤵ줿פݡȤƤʤ <code>null</code>
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException
     *         ץȥ뤬Υƥķ򥵥ݡȤƤʤ
     *
     * @see    URLConnection#getContent(Class[])
     */
    public Object getContent(Class[] classes) throws IOException {
        return connection.getContent(classes);
    }

    /**
     * Υ֥Ȥɽ³μ¹Ԥɬפʥɽ
     * <code>Permission</code> ֥Ȥ֤ޤ
     *
     * @return ³Τɬפʥɽ
     *         <code>Permission</code> ֥
     *
     * @throws IOException
     *         ν˥ͥåȥ
     *         ޤϥեϤɬפʤȤˡ㳰ȯ
     *
     * @see    URLConnection#getPermission()
     */
    public Permission getPermission() throws IOException {
        return connection.getPermission();
    }

    /**
     * ꥯȥץѥƥɲäޤ
     *
     * @param  key   
     * @param  value 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     * @throws NullPointerException  <code>null</code> ξ
     *
     * @see    URLConnection#addRequestProperty(String, String)
     */
    public void addRequestProperty(String key, String value) {
        connection.addRequestProperty(key, value);
    }

    /**
     * ꥯȥץѥƥ֤ޤ
     *
     * @return ꥯȥץѥƥ
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#getRequestProperties()
     */
    public Map getRequestProperties() {
        return connection.getRequestProperties();
    }
}
