/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.InputStream;
import java.io.IOException;
import java.net.UnknownHostException;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

/**
 * HTTPS 饤ȤδŪʵǽ󶡤ޤ
 * Υ饹ϥåɥդǤϤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public final class HttpsClient extends HttpClient {
    private static final int HTTP_CONTINUE = 100;

    /** ǥեȥݡ */
    public static final int DEFAULT_PORT = 443;

    private HttpClient       tunnel;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private SSLSocket        sslSocket;
    private SSLSession       sslSession;

    /**
     * HTTPS ץȥľ³饤ȤΥ󥹥󥹤ޤ
     *
     * @param  protocol         ץȥ
     * @param  host             ФΥۥ
     * @param  port             ФΥݡ
     * @param  sslSocketFactory SSL åȥեȥ
     * @param  hostnameVerifier ۥ̾٥ե
     *
     * @return HTTPS 饤
     *
     * @throws UnknownHostException ʥۥȤꤷ
     * @throws IOException IO 顼ȯ
     */
    public static HttpsClient getInstance(String protocol, String host, int port,
                                          SSLSocketFactory sslSocketFactory,
                                          HostnameVerifier hostnameVerifier)
            throws UnknownHostException, IOException {
        if (port == -1) {
            port = DEFAULT_PORT;
        }

        return new HttpsClient(getConnection(protocol,
                                             host, port,
                                             host, port,
                                             false,
                                             sslSocketFactory,
                                             hostnameVerifier));
    }

    /**
     * HTTPS ץȥ³ѤΥץФ³
     * ȥͥ륯饤ȤΥ󥹥󥹤ޤ
     *
     * @param  protocol         ץȥ
     * @param  originHost       ꥸ󥵡ФΥۥ
     * @param  originPort       ꥸ󥵡ФΥݡ
     * @param  proxyHost        ץФΥۥ
     * @param  proxyPort        ץФΥݡ
     * @param  sslSocketFactory SSL åȥեȥ
     * @param  hostnameVerifier ۥ̾٥ե
     *
     * @return HTTPS ȥͥ륯饤
     *
     * @throws UnknownHostException ʥۥȤꤷ
     * @throws IOException IO 顼ȯ
     */
    public static HttpClient getInstance(String protocol,
                                         String originHost, int originPort,
                                         String proxyHost, int proxyPort,
                                         SSLSocketFactory sslSocketFactory,
                                         HostnameVerifier hostnameVerifier)
            throws UnknownHostException, IOException {
        if (originPort == -1) {
            originPort = DEFAULT_PORT;
        }

        return new HttpsClient(getConnection(protocol,
                                             originHost, originPort,
                                             proxyHost, proxyPort,
                                             true,
                                             sslSocketFactory,
                                             hostnameVerifier));
    }

    /**
     * HTTPS ץȥ³ѤΥץФ³
     * 饤ȤΥ󥹥󥹤ޤ
     *
     * @param  protocol         ץȥ
     * @param  host             ꥸ󥵡ФΥۥ
     * @param  port             ꥸ󥵡ФΥݡ
     * @param  tunnel           ȥͥ
     * @param  sslSocketFactory SSL åȥեȥ
     * @param  hostnameVerifier ۥ̾٥ե
     *
     * @return ȥͥͳ HTTPS 饤
     *
     * @throws UnknownHostException ʥۥȤꤷ
     * @throws IOException IO 顼ȯ
     */
    public static HttpsClient getInstance(String protocol, String host, int port,
                                          HttpClient tunnel,
                                          SSLSocketFactory sslSocketFactory,
                                          HostnameVerifier hostnameVerifier)
            throws UnknownHostException, IOException {
        if (port == -1) {
            port = DEFAULT_PORT;
        }

        // ȥͥ뼫ΤϺѤ뤳ȤϤꤨʤΤǡ˿ͥ
        HttpsConnection connection = new HttpsConnection(protocol, host, port,
                                                         tunnel,
                                                         sslSocketFactory,
                                                         hostnameVerifier);
        connection.open();

        return new HttpsClient(connection);
    }

    /** ͥ */
    private static HttpsConnection getConnection(String protocol,
                                                 String originHost,
                                                 int originPort,
                                                 String connectHost,
                                                 int connectPort,
                                                 boolean proxy,
                                                 SSLSocketFactory sslSocketFactory,
                                                 HostnameVerifier hostnameVerifier)
            throws IOException {
        HttpsConnection connection;
        if ((connection = (HttpsConnection) findInstance(protocol, originHost, originPort)) == null) {
            // ץξ
            connection = new HttpsConnection(protocol, connectHost, connectPort, proxy,
                                             sslSocketFactory, hostnameVerifier);
            connection.open();
        } else {
            connection.setHostnameVerifier(hostnameVerifier);
        }

        return connection;
    }

    /**
     * ꤷۥȤȥݡȤ³ HTTPS 饤Ȥޤ
     *
     * @param  connection HTTPS ͥ
     */
    HttpsClient(HttpsConnection connection) {
        super(connection);
    }

    /* HTTP ꥯȤ򥵡Фꡢ쥹ݥ󥹤֤ */
    /** {@inheritDoc} */
    public synchronized InputStream send(MessageHeader requests,
                                         PosterOutputStream poster,
                                         MessageHeader responses,
                                         boolean isEmpty,
                                         boolean canRelease)
            throws IOException {
        // ȥͥѤƤϡȥͥ Keep-Alive ̵ˤ
        if (tunnel != null) {
            synchronized (tunnel) {
                if (tunnel.connection != null) {
                    tunnel.connection.setKeepAliveTimeout(-1);
                }
            }
        }

        return super.send(requests, poster, responses, isEmpty, canRelease);
    }

    /**
     * SSL Υå֤ޤ
     *
     * @return SSL å
     */
    public SSLSession getSSLSession() {
        return ((HttpsConnection) connection).getSSLSession();
    }
}
