/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.security.cert.X509Certificate;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/**
 * ۥ̾ΥåԤ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
final class HostnameChecker {
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP  = 7;

    /** ߡ */
    private HostnameChecker() {
    }

    /**
     * X.509 ζ̾Τ
     * <code>expectedName</code> åޤ
     *
     * @param  expectedName Ԥ̾
     * @param  certificate  
     *
     * @return  <code>true</code>
     *         ʤ <code>false</code>
     */
    static boolean match(String expectedName, X509Certificate certificate) {
        return (NetUtils.isIpAddress(expectedName)
                ? matchIP (expectedName, certificate)
                : matchDNS(expectedName, certificate));
    }

    /** IP ɥ쥹Ȥƥå */
    private static boolean matchIP(String ip, X509Certificate certificate) {
        Collection sans = null;
        try {
            sans = certificate.getSubjectAlternativeNames();
        } catch (CertificateParsingException e) { }

        if (sans == null) {
            return false;
        }

        for (Iterator iterator = sans.iterator(); iterator.hasNext();) {
            List next = (List) iterator.next();
            if (((Integer) next.get(0)).intValue() == ALTNAME_IP) {
                if (ip.equalsIgnoreCase((String) next.get(1))) {
                    return true;
                }
            }
        }

        return false;
    }

    /** DNS ̾Ȥƥå */
    private static boolean matchDNS(String dns, X509Certificate certificate) {
        Collection sans = null;
        try {
            sans = certificate.getSubjectAlternativeNames();
        } catch (CertificateParsingException e) { }

        if (sans != null) {
            boolean foundDNS = false;
            for (Iterator iterator = sans.iterator(); iterator.hasNext();) {
                List next = (List) iterator.next();
                if (((Integer) next.get(0)).intValue() == ALTNAME_DNS) {
                    foundDNS = true;
                    if (isMatched(dns, (String) next.get(1))) {
                        return true;
                    }
                }
            }
            if (foundDNS) {
                return false;
            }
        }

        DistinguishedName dn = new DistinguishedName(certificate.getSubjectX500Principal().getName());
        String cn = dn.getCommonName();
        if (cn != null && isMatched(dns, cn)) {
            return true;
        }

        return false;
    }
    /** name  template* ޤˤ˥ޥå뤫å. ڤ */
    private static boolean isMatched(String name, String template) {
        name     = name    .toLowerCase();
        template = template.toLowerCase();
        StringTokenizer nameSt     = new StringTokenizer(name    , ".");
        StringTokenizer templateSt = new StringTokenizer(template, ".");

        if (nameSt.countTokens() != templateSt.countTokens()) {
            return false;
        }

        while (nameSt.hasMoreTokens()) {
            if (!matchWildCards(nameSt    .nextToken(),
                                templateSt.nextToken())) {
                return false;
            }
        }

        return true;
    }

    /** name  template* ޤˤ˥ޥå뤫å */
    private static boolean matchWildCards(String name, String template) {

        int wildcardIndex = template.indexOf("*");
        if (wildcardIndex == -1) {
            return (name.compareTo(template) == 0);
        }

        String beforeWildcard = template.substring(0, wildcardIndex);
        String afterWildcard  = template.substring(wildcardIndex + 1);

        // Ƭ˰
        if (!name.startsWith(beforeWildcard)) {
            return false;
        }

        int beforeIndex = 0;
        for (;;) {
            name = name.substring(beforeIndex + beforeWildcard.length());
            if ((wildcardIndex = afterWildcard.indexOf("*")) == -1) {
                break;
            }

            beforeWildcard = afterWildcard.substring(0, wildcardIndex);
            afterWildcard  = afterWildcard.substring(wildcardIndex + 1);

            if ((beforeIndex = name.indexOf(beforeWildcard)) == -1) {
                return false;
            }
        }

        return name.endsWith(afterWildcard);
    }
}
