/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.util.Iterator;
import java.util.LinkedHashMap;

/**
 * X.500 Principal ʸɽ饹Ǥ
 *
 * @see     javax.security.auth.x500.X500Principal
 * @see     <a href="http://www.ietf.org/rfc/rfc2253.html">RFC2253</a>
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class DistinguishedName {
    private LinkedHashMap values;

    /**
     * X509  Subject Ϥޤ
     *
     * <!--
     *   [CN=xxx xxx, OU="xxx, xxx"; O=xxx\, xxx, C = JP ]
     * -->
     *
     * @see     <a href="http://www.ietf.org/rfc/rfc2253.html">RFC2253</a>
     */
    public DistinguishedName(String name) {
        values = new LinkedHashMap();

        char c;
        int length = name.length();
        StringBuffer key   = new StringBuffer();
        StringBuffer value = new StringBuffer();
        StringBuffer sb    = key;
        boolean isQuote  = false;
        boolean isEscape = false;
        int     space    = 0;
        for (int i = 0; i < length; i++) {
            c = name.charAt(i);

            // ƬΥڡɤФ
            if (space < 0) {
                if (c == ' ' || c == 0x0D) {
                    continue;
                }
                space = 0;
            }

            if (isEscape) {
                isEscape = false;
            } else if (isQuote) {
                if (c == '"') {
                    isQuote = false;
                    c = 0;
                }
            } else {
                if (c == ',' || c == ';') {
                    values.put(key.toString().toUpperCase(), value.toString());
                    key  .setLength(0);
                    value.setLength(0);
                    sb    = key;
                    space = -1;
                    continue;
                } else if (c == '\\') {
                    isEscape = true;
                    continue;
                } else if (c == '=' && sb == key) {
                    sb    = value;
                    space = -1;
                    continue;
                } else if (c == ' ' || c == 0x0D) {
                    space++;
                    continue;
                } else if (c == '"') {
                    isQuote = true;
                    c = 0;
                }
            }

            if (space > 0) {
                do {
                    sb.append(' ');
                } while (--space > 0);
            }
            if (c > 0) {
                sb.append(c);
            }
        }

        // Ǹ
        if (key.length() > 0 || value.length() > 0) {
            values.put(key.toString().toUpperCase(), value.toString());
        }
    }

    /**
     * бͤޤ
     *
     * @param  key 
     *
     * @return б
     */
    public String get(String key) {
        return (String) values.get(key.toUpperCase());
    }

    /**
     * ̾ΡCNˤ֤ޤ
     *
     * @return ̾Ρ̵ <code>null</code>
     */
    public String getCommonName() {
        return get("CN");
    }

    /**
     * Ի̾Lˤ֤ޤ
     *
     * @return Ի̵̾ <code>null</code>
     */
    public String getLocalityName() {
        return get("L");
    }

    /**
     * ̾ΡSTˤ֤ޤ
     *
     * @return ̾Ρ̵ <code>null</code>
     */
    public String getStateOrProvinceName() {
        return get("ST");
    }

    /**
     * ȿ̾ΡOˤ֤ޤ
     *
     * @return ȿ̾Ρ̵ <code>null</code>
     */
    public String getOrganizationName() {
        return get("O");
    }

    /**
     * ȿñ̾ΡOUˤ֤ޤ
     *
     * @return ȿñ̾Ρ̵ <code>null</code>
     */
    public String getOrganizationalUnitName() {
        return get("OU");
    }

    /**
     * ̾Cˤ֤ޤ
     *
     * @return ̵̾ <code>null</code>
     */
    public String getCountryName() {
        return get("C");
    }

    /**
     * ȥ꡼ȥɥ쥹STREETˤ֤ޤ
     *
     * @return ȥ꡼ȥɥ쥹̵ <code>null</code>
     */
    public String getStreetAddress() {
        return get("STREET");
    }

    /**
     * ɥᥤ̾ΡDCˤ֤ޤ
     *
     * @return ɥᥤ̾Ρ̵ <code>null</code>
     */
    public String getDomainComponent() {
        return get("DC");
    }

    /**
     * 桼 IDUIDˤ֤ޤ
     *
     * @return 桼 ID̵ <code>null</code>
     */
    public String getUserID() {
        return get("UID");
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('[');

        if (values.size() > 0) {
            Iterator iterator = values.keySet().iterator();
            String key;
            for (;;) {
                key = (String) iterator.next();

                //### BUGS פɬפ
                sb.append(key);
                sb.append('=');
                sb.append(values.get(key));

                if (iterator.hasNext()) {
                    sb.append(", ");
                } else {
                    break;
                }
            }
        }

        sb.append(']');
        return sb.toString();
    }
}
