/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.java2.bridge;

import net.hizlab.kagetaka.addin.java2.NETBWrapper;
import net.hizlab.kagetaka.net.HttpURLConnectionWrapper12;
import net.hizlab.kagetaka.net.HttpURLConnectionWrapper14;
import net.hizlab.kagetaka.net.URLConnectionWrapper12;
import net.hizlab.kagetaka.net.URLConnectionWrapper14;
import net.hizlab.kagetaka.util.Environment;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

/**
 * ֥饦ΤߤǻѤ Java2  NET εǽ¹Ԥ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class NETBCaller extends NETBWrapper {
    /**
     * 󥹥󥹤ޤ
     */
    public NETBCaller() {
    }

    /**
     * {@link URLConnection}{@link HttpURLConnection} Υåѡ饹֤ޤ
     *
     * @param  url        URL
     * @param  connection ͥ
     * @param  is         ϥȥ꡼ࡣ
     *                    <code>connection</code> 
     *                    <code>null</code>
     *
     * @return åѡ饹
     *
     * @see    URLConnection
     * @see    HttpURLConnection
     */
    public URLConnection getURLConnectionWrapper(URL url,
                                                 URLConnection connection,
                                                 InputStream is) {
        // JDK 1.4 later
        if (Environment.javaVersion >= 104) {
            if (connection instanceof HttpURLConnection) {
                return new HttpURLConnectionWrapper14(url, (HttpURLConnection) connection, is);
            }
            return new URLConnectionWrapper14(url, connection, is);
        }

        // JDK 1.2 later
        if (connection instanceof HttpURLConnection) {
            return new HttpURLConnectionWrapper12(url, (HttpURLConnection) connection, is);
        }
        return new URLConnectionWrapper12(url, connection, is);
    }
}
