/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.java2.bridge;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.addin.java2.DnDListener;
import net.hizlab.kagetaka.addin.java2.DnDWrapper;

import java.awt.Component;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * ɥåɥɥåפºݤ˼¹Ԥ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class DnDCaller extends DnDWrapper {
    private static final int ACTION = DnDConstants.ACTION_COPY_OR_MOVE | DnDConstants.ACTION_LINK;

    /**
     * 󥹥󥹤ޤ
     */
    public DnDCaller() {
    }

    /**
     * ɥåɥɥåפ򥵥ݡȤ褦ˡݡͥȤ
     * ꥹʤϿޤ
     *
     * @param  c             ݡͥ
     * @param  l             ꥹ
     * @param  acceptClasses դ륯饹ͥ̽
     */
    public void addDnDListener(Component c, DnDListener l,
                               Class[] acceptClasses) {
        new DropTarget(c, ACTION, new DropListener(l, acceptClasses), true);
    }

//### DropListener
    /** ɥåץåȥꥹ */
    private final class DropListener implements DropTargetListener {
        private DnDListener listener;
        private Class[]     acceptClasses;

        /** 󥹥󥹤 */
        private DropListener(DnDListener l, Class[] acceptClasses) {
            this.listener      = l;
            this.acceptClasses = acceptClasses;
        }

        /** ɥåä */
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!listener.isActive()) {
                dtde.rejectDrag();
            }
        }

        /** ɥåư */
        public void dragOver(DropTargetDragEvent dtde) {
            if (!listener.isActive()) {
                dtde.rejectDrag();
            }
        }

        /** ɥå̤ѹ줿 */
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        /** ɥåФƹԤä */
        public void dragExit(DropTargetEvent dte) {
        }

        /** ɥåפ줿 */
        public void drop(DropTargetDropEvent dtde) {
            if (!listener.isActive()) {
                dtde.rejectDrop();
                return;
            }

            dtde.acceptDrop(DnDConstants.ACTION_COPY);

            // ꥹʡΤ륪֥Ȥʪ
            List objects = new ArrayList();

            try {
                Transferable t           = dtde.getTransferable();
                DataFlavor[] dataFlavors = t.getTransferDataFlavors();
                Object       o;

                ACCEPT:
                for (int i = 0; i < acceptClasses.length; i++) {
                    for (int j = 0; j < dataFlavors.length; j++) {
                        try {
                            o = t.getTransferData(dataFlavors[j]);
                        } catch (UnsupportedFlavorException e) {
Debug.out.println("### WARNING ### : DnDCaller.drop : " + e);
                            continue;
                        } catch (IOException e) {
Debug.out.println("### WARNING ### : DnDCaller.drop : " + e);
                            continue;
                        }

                        if (o instanceof List) {
                            // ꥹȤξ
                            for (Iterator iterator = ((List) o).iterator(); iterator.hasNext();) {
                                o = iterator.next();
                                if (o.getClass().equals(acceptClasses[i])) {
                                    objects.add(o);
                                }
                            }
                            // ĤǤ¸ߤƤ齪λ
                            if (objects.size() > 0) {
                                break ACCEPT;
                            }
                        } else if (o.getClass().equals(acceptClasses[i])) {
                            // ꥹȰʳξǼդ륿פʤ顢ǽλ
                            objects.add(o);
                            break ACCEPT;
                        }
                    }
                }
            } finally {
                dtde.dropComplete(true);
            }

            // ꥹʡ
            listener.drop(objects.toArray());
        }
    }
}
