/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.theme;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.viewer.option.OptionListener;
import net.hizlab.kagetaka.viewer.option.ViewerController;
import net.hizlab.kagetaka.viewer.option.ViewerOption;
import net.hizlab.kagetaka.viewer.option.InvalidValueException;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ơޤ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class ThemeManager {
    private static final String RESOURCE  = "net.hizlab.kagetaka.viewer.theme.Resources";
    private static final String BASE_PATH = "net/hizlab/kagetaka/viewer/theme/themes/";
    private static final String EXTENSION = ".kth";

    private ViewerOption option;

    private Vector themes    = new Vector();
    private Theme  theme;
    private Vector listeners = new Vector();

    /**
     * ơޥޥ͡ޤ
     *
     * @param  option ץ
     */
    public ThemeManager(ViewerOption option) {
        this.option = option;
        refresh();

        initTheme(option.getPropertyString(ViewerOption.KEY_THEME_KEY));

        // ꥹʤϿ
        option.addListener(
            new OptionListener() {
                /** ͤѹȤ */
                public void propertyChange(ViewerOption option, String key, Object oldValue, Object newValue)
                        throws InvalidValueException {
                }

                /** ͤѹꡢѹꤵ줿 */
                public void propertiesChanged(ViewerOption option, ViewerController c, Enumeration list) {
                    String key;
                    while (list.hasMoreElements()) {
                        key = (String) list.nextElement();

                        // ơޤѹ
                        if (key.compareTo(ViewerOption.KEY_THEME_KEY) == 0) {
                            String themeKey = option.getPropertyString(ViewerOption.KEY_THEME_KEY);
                            if (themeKey.compareTo(theme.getKey()) == 0) {
                                return;
                            }

                            initTheme(themeKey);
                            if (listeners.size() > 0) {
                                for (int i = 0; i < listeners.size(); i++) {
                                    ((ThemeListener) listeners.elementAt(i)).themeChanged(theme);
                                }
                            }
                            return;
                        }
                    }
                }
            }
        );
    }

    /** ơޤ */
    private void initTheme(String key) {
        Theme theme = getTheme(key);
        if (theme == null) {
            theme = (Theme) themes.elementAt(0);
        }

        try {
            theme.load();
        } catch (InvalidThemeException e) {
Debug.out.println(e);
        }

        this.theme = theme;
    }

    /**
     * ơ޾ɹޤ
     */
    public synchronized void refresh() {
        themes.removeAllElements();

        // ǥեȥơ
        String list = Resource.getMessage(RESOURCE, "themes.list", null);
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            try {
                themes.addElement(new Theme(BASE_PATH + st.nextToken(), Theme.LOAD_RESOURCE));
            } catch (InvalidThemeException e) {
Debug.out.println(e);
            }
        }

        // 桼ƥơ
        File[] lists = {option.getPropertyFile(ViewerOption.KEY_THEME_USER_PATH  ),
                        option.getPropertyFile(ViewerOption.KEY_THEME_SYSTEM_PATH)};
        for (int i = 0; i < lists.length; i++) {
            if (lists[i] == null) {
                continue;
            }

            if (!lists[i].exists() || !lists[i].isDirectory() || !lists[i].canRead()) {
                continue;
            }

            String[] files = lists[i].list();
            if (files == null) {
                continue;
            }

            for (int j = 0; j < files.length; j++) {
                File file = new File(lists[i], files[j]);
                if (/*---*/!files[j].toLowerCase().endsWith(EXTENSION)
                        && !file.isDirectory()) {
                    continue;
                }

                try {
                    themes.addElement(new Theme(file, (j == 0 ? Theme.LOAD_USER : Theme.LOAD_SYSTEM)));
                } catch (InvalidThemeException e) {
Debug.out.println(e);
                }
            }
        }
    }

    /**
     * 桼򤷤Ƥơޤ֤ޤ
     *
     * @return ơ
     */
    public synchronized Theme getTheme() {
        return theme;
    }

    /**
     * ơޤ֤ޤ
     *
     * @param  key ơޤ̤륭
     *
     * @return ơ
     */
    public synchronized Theme getTheme(String key) {
        Theme theme;

        for (int i = 0; i < themes.size(); i++) {
            theme = (Theme) themes.elementAt(i);
            if (theme.getKey().compareTo(key) == 0) {
                return theme;
            }
        }

        return null;
    }

    /**
     * ǧƤ뤹٤ƤΥơޤ֤ޤ
     *
     * @return ٤ƤΥơ
     */
    public synchronized Theme[] getThemes() {
        Theme[] ts = new Theme[themes.size()];
        themes.copyInto(ts);

        return ts;
    }

    /**
     * ơޥꥹʤϿޤ
     *
     * @param  l Ͽꥹ
     */
    public void addListener(ThemeListener l) {
        listeners.addElement(l);
    }

    /**
     * ơޥꥹʤޤ
     *
     * @param  l ꥹ
     */
    public void removeListener(ThemeListener l) {
        listeners.removeElement(l);
    }
}
