/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.addin.java2.AWTWrapper;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.io.PathAbsoluter;
import net.hizlab.kagetaka.protocol.Protocol;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.util.CharList;
import net.hizlab.kagetaka.util.Environment;
import net.hizlab.kagetaka.util.PathFinder;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.SSLManager;
import net.hizlab.kagetaka.viewer.ViewerConsole;
import net.hizlab.kagetaka.viewer.ViewerToolbar;
import net.hizlab.kagetaka.viewer.bookmark.BookmarkManager;
import net.hizlab.kagetaka.viewer.cookie.CookieManager;
import net.hizlab.kagetaka.viewer.history.HistoryManager;
import net.hizlab.kagetaka.viewer.theme.ThemeManager;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ֥饦ѤΥץǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.15 $
 */
public class ViewerOption extends Option implements PathAbsoluter {
    /** ٤¹ */
    static {
        Protocol.initialize();
        HttpURLConnection.setFollowRedirects(false);
    }

    /** <code>boolean  </code>        */ public static final int TYPE_BOOLEAN   =  1;
    /** <code>int      </code>        */ public static final int TYPE_INT       =  2;
    /** <code>double   </code>        */ public static final int TYPE_DOUBLE    =  3;
    /** {@link String}                */ public static final int TYPE_STRING    =  4;
    /** {@link String}<code>[]</code> */ public static final int TYPE_STRINGS   =  5;
    /** {@link Dimension}             */ public static final int TYPE_DIMENSION =  6;
    /** {@link Font}                  */ public static final int TYPE_FONT      =  7;
    /** {@link Point}                 */ public static final int TYPE_POINT     =  8;
    /** {@link File}                  */ public static final int TYPE_FILE      =  9;
    /** {@link CharList}              */ public static final int TYPE_CHARLIST  = 10;

    private static final Integer OBJECT_BOOLEAN   = new Integer(TYPE_BOOLEAN  );
    private static final Integer OBJECT_INT       = new Integer(TYPE_INT      );
    private static final Integer OBJECT_DOUBLE    = new Integer(TYPE_DOUBLE   );
    private static final Integer OBJECT_STRING    = new Integer(TYPE_STRING   );
    private static final Integer OBJECT_STRINGS   = new Integer(TYPE_STRINGS  );
    private static final Integer OBJECT_DIMENSION = new Integer(TYPE_DIMENSION);
    private static final Integer OBJECT_FONT      = new Integer(TYPE_FONT     );
    private static final Integer OBJECT_POINT     = new Integer(TYPE_POINT    );
    private static final Integer OBJECT_FILE      = new Integer(TYPE_FILE     );
    private static final Integer OBJECT_CHARLIST  = new Integer(TYPE_CHARLIST );

    private static final int PROXY_HTTP  = 0;
    private static final int PROXY_HTTPS = 1;
    private static final int PROXY_FTP   = 2;

    // ƥѥ
    private static String kagetakaHome;
    private static String defaultSystemOptionPath;
    private static String defaultUserOptionPath;
    static {
        String sep = File.separator;
        String s;

        // kagetakaHome
        if ((s = System.getProperty("kagetaka.home")) == null) {
            if ((s = System.getProperty("user.dir")) != null) {
                s += sep + "..";
            } else {
                s = "..";
            }
        }
        kagetakaHome = s;

        // defaultSystemOptionPath
        if ((s = System.getProperty("kagetaka.config")) == null) {
            s = kagetakaHome + sep + "etc" + sep + "options";
        }
        defaultSystemOptionPath = s;

        // defaultUserOptionPath
        s = System.getProperty("user.home", ".") + sep + ".kagetaka";
        defaultUserOptionPath   = s + sep + "options";
//Debug.out.println("["+kagetakaHome+"]");
//Debug.out.println("["+defaultSystemOptionPath+"]");
//Debug.out.println("["+defaultUserOptionPath+"]");
    }

    /** @serial ץѥƥ */
    Hashtable        properties   = new Hashtable();
    /** @serial ꥹ */
    Hashtable        defaultKey   = new Hashtable();
    /** @serial ꥹ */
    Vector           defaultList  = new Vector   ();
    /** @serial ͤΥ */
    Hashtable        defaultTypes = new Hashtable();
    /** @serial ǥե */
    Hashtable        defaultProperties;   // ǥե͡ʥǥե + ƥ
    /** @serial ƥץѥƥ */
    ExProperties     systemProperties;    // ƥץѥƥե
    /** @serial 桼ץѥƥ */
    ExProperties     userProperties;      // 桼ץѥƥե
    /** @serial ꥹ */
    Vector           listeners    = new Vector();

    /** @serial 桼ۡǥ쥯ȥ */
    private String userHome;

    // եѥ
    private static final String DEFAULT_CACHE_PATH             = "cache";
    private static final String DEFAULT_HISTORY_PATH           = "history.dat";
    private static final String DEFAULT_BOOKMARKS_PATH         = "bookmarks.html";
    private static final String DEFAULT_COOKIE_PATH            = "cookies.txt";
    private static final String DEFAULT_THEME_USER_PATH        = "themes";
    private static final String DEFAULT_THEME_SYSTEM_PATH      = "themes";
    private static final String DEFAULT_KEYSTORE_USER_PATH     = "keystore.jks";
    private static final String DEFAULT_KEYSTORE_SYSTEM_PATH   = "keystore.jks";
    private static final String DEFAULT_TRUSTSTORE_USER_PATH   = "truststore.jks";
    private static final String DEFAULT_TRUSTSTORE_SYSTEM_PATH = "truststore.jks";
    private static final File   DEFAULT_EDITOR_PATH            = PathFinder.find("notepad.exe");
    private static final String DEFAULT_IE_PATH                = "\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\"";
    private static final String DEFAULT_MOZILLA_PATH           = "/usr/bin/mozilla";

    // ɸ४ץ
    public  static final String KEY_PARSER_INPUT                = "parser.input";
    public  static final String KEY_PARSER_FILTERS              = "parser.filters";
    public  static final String KEY_FONT_STYLE                  = "font.style";
    public  static final String KEY_FONT_STYLE_SERIF            = "font.style.serif";
    public  static final String KEY_FONT_STYLE_SANS_SERIF       = "font.style.sans-serif";
    public  static final String KEY_FONT_STYLE_CURSIVE          = "font.style.cursive";
    public  static final String KEY_FONT_STYLE_FANTASY          = "font.style.fantasy";
    public  static final String KEY_FONT_STYLE_MONOSPACE        = "font.style.monospace";
    public  static final String KEY_FONT_OPTION_SCALE           = "font.option.scale";
    public  static final String KEY_FONT_OPTION_ANTIALIASING    = "font.option.antialiasing";
    public  static final String KEY_CHARS_SPIN_RIGHT            = "chars.spin.right";
    public  static final String KEY_CHARS_SPIN_LTRB             = "chars.spin.ltrb";
    public  static final String KEY_CHARS_KINSOKU_HEAD          = "chars.kinsoku.head";
    public  static final String KEY_CHARS_KINSOKU_TAIL          = "chars.kinsoku.tail";
    public  static final String KEY_STYLE_DECORATION_SWAP       = "style.decoration.swap";
    public  static final String KEY_LOAD_IMAGE                  = "load.image";
    public  static final String KEY_SPIN_IMAGE                  = "spin.image";
    public  static final String KEY_SPIN_IMAGE_PRE              = "spin.image.";
    public  static final String KEY_SPIN_IMAGE_EXT_ASPECTRATIO  = ".aspectratio";
    public  static final String KEY_SPIN_IMAGE_EXT_MINWIDTH     = ".minwidth";
    /**  */
    private void initializeBasic() {
        Option option = new Option();
        initPropertyString  (KEY_PARSER_INPUT            , option.getInputStreamParser());
        initPropertyStrings (KEY_PARSER_FILTERS          , option.getFilterParsers    ());
        initPropertyString  (KEY_FONT_STYLE              , option.getFontStyle        ());
        initPropertyFont    (KEY_FONT_STYLE_SERIF        , option.getFontSerif        ());
        initPropertyFont    (KEY_FONT_STYLE_SANS_SERIF   , option.getFontSansSerif    ());
        initPropertyFont    (KEY_FONT_STYLE_CURSIVE      , option.getFontCursive      ());
        initPropertyFont    (KEY_FONT_STYLE_FANTASY      , option.getFontFantasy      ());
        initPropertyFont    (KEY_FONT_STYLE_MONOSPACE    , option.getFontMonospace    ());
        initPropertyDouble  (KEY_FONT_OPTION_SCALE       , option.getFontScale        ());
        initPropertyBoolean (KEY_FONT_OPTION_ANTIALIASING, option.getAntiAliasing     ());
        initPropertyCharList(KEY_CHARS_SPIN_RIGHT        , option.getCharsSpinRight   ());
        initPropertyCharList(KEY_CHARS_SPIN_LTRB         , option.getCharsSpinLtrb    ());
        initPropertyCharList(KEY_CHARS_KINSOKU_HEAD      , option.getCharsKinsokuHead ());
        initPropertyCharList(KEY_CHARS_KINSOKU_TAIL      , option.getCharsKinsokuTail ());
        initPropertyBoolean (KEY_STYLE_DECORATION_SWAP   , option.getSwapDecoration   ());
        initPropertyBoolean (KEY_LOAD_IMAGE              , option.getLoadImage        ());
        initPropertyBoolean (KEY_SPIN_IMAGE              , true                         );

        for (Enumeration e = spinImageTable.keys(); e.hasMoreElements();) {
            String type = (String) e.nextElement();
            super.setSpinImage(type, true);
            initPropertyBoolean(KEY_SPIN_IMAGE_PRE + type                                 , true                           );
            initPropertyDouble (KEY_SPIN_IMAGE_PRE + type + KEY_SPIN_IMAGE_EXT_ASPECTRATIO, option.getSpinAspectRatio(type));
            initPropertyInteger(KEY_SPIN_IMAGE_PRE + type + KEY_SPIN_IMAGE_EXT_MINWIDTH   , option.getSpinMinWidth   (type));
        }
    }

    // ֥饦ץ
    public  static final String KEY_URL_HOME              = "url.home";
    public  static final String KEY_LOG_LEVEL             = "log.level";
    public  static final String KEY_SYSTEM_REPORT_SEND    = "system.report.send";
    public  static final String KEY_LISTENER_MIN          = "system.listener.min";
    public  static final String KEY_LISTENER_MAX          = "system.listener.max";
    public  static final String KEY_WINDOW_POSITION       = "window.position";
    public  static final String KEY_WINDOW_SIZE           = "window.size";
    public  static final String KEY_WINDOW_MAXIMIZED      = "window.maximized";
    public  static final String KEY_WINDOW_OWD_USE        = "window.openwebdialog.use";
    public  static final String KEY_SCREEN_RESOLUTION     = "screen.resolution";
    public  static final String KEY_SCREEN_DYNAMIC_LAYOUT = "screen.dynamic.layout";
    public  static final String KEY_HTTP_STRICT           = "http.strict";
    public  static final String KEY_HTTP_REFERER          = "http.referer";
    public  static final String KEY_HTTP_USERAGENT        = "http.useragent";
    public  static final String KEY_HTTP_ACCEPT           = "http.accept";
    public  static final String KEY_HTTP_ACCEPTCHARSET    = "http.acceptcharset";
    public  static final String KEY_HTTP_ACCEPTENCODING   = "http.acceptencoding";
    public  static final String KEY_HTTP_ACCEPTLANGUAGE   = "http.acceptlanguage";
    public  static final String KEY_SHOW_SCROLLBAR        = "show.scrollbar";
    public  static final String KEY_SHOW_NAVIBAR          = "show.navibar";
    public  static final String KEY_SHOW_NAVIBAR_BUTTONS  = "show.navibar.buttons";
    public  static final String KEY_SHOW_SEARCHBAR        = "show.searchbar";
    public  static final String KEY_SHOW_LINKBAR          = "show.linkbar";
    public  static final String KEY_SHOW_LINKBAR_BUTTONS  = "show.linkbar.buttons";
    public  static final String KEY_SHOW_STATUSBAR        = "show.statusbar";
    public  static final String KEY_MOUSE_WHEEL           = "mouse.wheel";
    public  static final String KEY_MOUSE_WHEEL_SWAP      = "mouse.wheel.swap";
    public  static final String KEY_TOOLTIP_CONTROL_USE   = "tooltip.control.use";
    public  static final String KEY_TOOLTIP_CONTROL_DELAY = "tooltip.control.delay";
    public  static final String KEY_TOOLTIP_CONTROL_TERM  = "tooltip.control.term";
    public  static final String KEY_TOOLTIP_BROWSER_USE   = "tooltip.browser.use";
    public  static final String KEY_TOOLTIP_BROWSER_DELAY = "tooltip.browser.delay";
    public  static final String KEY_TOOLTIP_BROWSER_TERM  = "tooltip.browser.term";
    public  static final String KEY_CACHE_STORE           = "cache.store";
    public  static final String KEY_CACHE_STORE_PATH      = "cache.store.path";
    public  static final String KEY_CACHE_STORE_TOTAL     = "cache.store.total";
    public  static final String KEY_CACHE_STORE_MAXSIZE   = "cache.store.maxsize";
    public  static final String KEY_CACHE_VALID_TIMES     = "cache.valid.times";
    public  static final String KEY_TOOLS_SV_PATH         = "tools.sourceviewer.path";
    public  static final String KEY_TOOLS_SV_OPTION       = "tools.sourceviewer.option";
    public  static final String KEY_PROXY                 = "proxy.";
    public  static final String KEY_PROXY_USE             = "proxy.use";
    public  static final String KEY_PROXY_HTTP_HOST       = "proxy.http.host";
    public  static final String KEY_PROXY_HTTP_PORT       = "proxy.http.port";
    public  static final String KEY_PROXY_HTTPS_HOST      = "proxy.https.host";
    public  static final String KEY_PROXY_HTTPS_PORT      = "proxy.https.port";
    public  static final String KEY_PROXY_FTP_HOST        = "proxy.ftp.host";
    public  static final String KEY_PROXY_FTP_PORT        = "proxy.ftp.port";
    public  static final String KEY_PROXY_SOCKS_HOST      = "proxy.socks.host";
    public  static final String KEY_PROXY_SOCKS_PORT      = "proxy.socks.port";
    public  static final String KEY_PROXY_DIRECT          = "proxy.direct";
    public  static final String KEY_DEBUG_CRASH_URL       = "debug.crash.url";
    /**  */
    private void initializeBrowser() {
        initPropertyString   (KEY_URL_HOME             , Resource.getMessage("kagetaka.homepage", null)              );
        initPropertyInteger  (KEY_LOG_LEVEL            , Reporter.ERROR                                              );
        initPropertyBoolean  (KEY_SYSTEM_REPORT_SEND   , true                                                        );
        initPropertyInteger  (KEY_LISTENER_MIN         , 26201                                                       );
        initPropertyInteger  (KEY_LISTENER_MAX         , 26500                                                       );
        initPropertyPoint    (KEY_WINDOW_POSITION      , null                                                        );
        initPropertyDimension(KEY_WINDOW_SIZE          , new Dimension(640, 480)                                     );
        initPropertyInteger  (KEY_WINDOW_MAXIMIZED     , AWTWrapper.MAXIMIZED_NONE                                   );
        initPropertyBoolean  (KEY_WINDOW_OWD_USE       , false                                                       );
        initPropertyInteger  (KEY_SCREEN_RESOLUTION    , Environment.screenResolution                                );
        initPropertyBoolean  (KEY_SCREEN_DYNAMIC_LAYOUT, false                                                       );
        initPropertyBoolean  (KEY_HTTP_STRICT          , false                                                       );
        initPropertyInteger  (KEY_HTTP_REFERER         , HawkViewer.REFERER_SAMEHOST                                 );
        initPropertyString   (KEY_HTTP_USERAGENT       , Resource.getMessage("kagetaka.useragent", null)             );
        initPropertyString   (KEY_HTTP_ACCEPT          , "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2"      );
        initPropertyString   (KEY_HTTP_ACCEPTCHARSET   , "Shift_JIS,utf-8;q=0.7,*;q=0.7"                             );
        initPropertyString   (KEY_HTTP_ACCEPTENCODING  , "identity"                                                  );
        initPropertyString   (KEY_HTTP_ACCEPTLANGUAGE  , "ja,en;q=0.5"                                               );
        initPropertyString   (KEY_SHOW_SCROLLBAR       , HawkViewer.SCROLLBAR_YES                                    );
        initPropertyBoolean  (KEY_SHOW_NAVIBAR         , true                                                        );
        initPropertyStrings  (KEY_SHOW_NAVIBAR_BUTTONS , new String[]{ViewerToolbar.BACK                            ,
                                                                      ViewerToolbar.FORWARD                         ,
                                                                      ViewerToolbar.RELOAD                          ,
                                                                      ViewerToolbar.STOP                            ,
                                                                      ViewerToolbar.ADDRESS                         ,
                                                                      ViewerToolbar.GO                              });
        initPropertyBoolean  (KEY_SHOW_SEARCHBAR       , true                                                        );
        initPropertyBoolean  (KEY_SHOW_LINKBAR         , true                                                        );
        initPropertyStrings  (KEY_SHOW_LINKBAR_BUTTONS , new String[]{ViewerToolbar.HOME                            ,
                                                                      ViewerToolbar.BOOKMARK                        ,
                                                                      ViewerToolbar.PTF                             });
        initPropertyBoolean  (KEY_SHOW_STATUSBAR       , true                                                        );
        initPropertyBoolean  (KEY_MOUSE_WHEEL          , true                                                        );
        initPropertyBoolean  (KEY_MOUSE_WHEEL_SWAP     , true                                                        );
        initPropertyBoolean  (KEY_TOOLTIP_CONTROL_USE  , (Environment.javaVersion >= 104)                            );
        initPropertyInteger  (KEY_TOOLTIP_CONTROL_DELAY, 700                                                         );
        initPropertyInteger  (KEY_TOOLTIP_CONTROL_TERM , 5000                                                        );
        initPropertyBoolean  (KEY_TOOLTIP_BROWSER_USE  , true                                                        );
        initPropertyInteger  (KEY_TOOLTIP_BROWSER_DELAY, 700                                                         );
        initPropertyInteger  (KEY_TOOLTIP_BROWSER_TERM , 5000                                                        );
        initPropertyBoolean  (KEY_CACHE_STORE          , true                                                        );
        initPropertyFile     (KEY_CACHE_STORE_PATH     , new File(userHome, DEFAULT_CACHE_PATH)                      );
        initPropertyInteger  (KEY_CACHE_STORE_TOTAL    , 50                                                          );
        initPropertyInteger  (KEY_CACHE_STORE_MAXSIZE  , 2                                                           );
        initPropertyInteger  (KEY_CACHE_VALID_TIMES    , 1                                                           );
        initPropertyFile     (KEY_TOOLS_SV_PATH        , DEFAULT_EDITOR_PATH                                         );
        initPropertyString   (KEY_TOOLS_SV_OPTION      , "\"%s\""                                                    );
        initPropertyBoolean  (KEY_PROXY_USE            , false                                                       );
        initPropertyString   (KEY_PROXY_HTTP_HOST      , System.getProperty("http.proxyHost"                        ));
        initPropertyInteger  (KEY_PROXY_HTTP_PORT      , Integer.parseInt(System.getProperty("http.proxyPort" , "0")));
        initPropertyString   (KEY_PROXY_HTTPS_HOST     , System.getProperty("https.proxyHost"                       ));
        initPropertyInteger  (KEY_PROXY_HTTPS_PORT     , Integer.parseInt(System.getProperty("https.proxyPort", "0")));
        initPropertyString   (KEY_PROXY_FTP_HOST       , System.getProperty("ftp.proxyHost"                         ));
        initPropertyInteger  (KEY_PROXY_FTP_PORT       , Integer.parseInt(System.getProperty("ftp.proxyPort"  , "0")));
        initPropertyString   (KEY_PROXY_SOCKS_HOST     , System.getProperty("socksProxyHost"                        ));
        initPropertyInteger  (KEY_PROXY_SOCKS_PORT     , Integer.parseInt(System.getProperty("socksProxyPort" , "0")));
        initPropertyString   (KEY_PROXY_DIRECT         , System.getProperty("http.nonProxyHosts"                    ));
        initPropertyString   (KEY_DEBUG_CRASH_URL      , null                                                        );

        loadProxy(this);
    }

    // ץꥱ
    public  static final String   KEY_APP        = "app.";
    public  static final String   KEY_APP_LIST   = "app.list";
    public  static final String[] KEY_APP_NAME   = {"app.", ".name"  };
    public  static final String[] KEY_APP_PATH   = {"app.", ".path"  };
    public  static final String[] KEY_APP_OPTION = {"app.", ".option"};
    public  static final String[] KEY_APP_ONLINE = {"app.", ".online"};
    /**  */
    private void initializeApp() {
        initPropertyStrings(KEY_APP_LIST, null);

        // ץꥱ
        if (containsPropertyKey(KEY_APP_LIST)) {
            String[] list = getPropertyStrings(KEY_APP_LIST);
            if (list != null) {
                for (int i = 0; i < list.length; i++) {
                    String id = list[i];
                    initPropertyString (KEY_APP_NAME  [0] + id + KEY_APP_NAME  [1], null);
                    initPropertyFile   (KEY_APP_PATH  [0] + id + KEY_APP_PATH  [1], null);
                    initPropertyString (KEY_APP_OPTION[0] + id + KEY_APP_OPTION[1], null);
                    initPropertyBoolean(KEY_APP_ONLINE[0] + id + KEY_APP_ONLINE[1], null);
                }
            } else {
                if (Environment.isWindows) {
                    properties.put(KEY_APP_LIST, "ie"     );
                    initPropertyString (KEY_APP_NAME  [0] + "ie"      + KEY_APP_NAME  [1], "Internet Explorer"           );
                    initPropertyFile   (KEY_APP_PATH  [0] + "ie"      + KEY_APP_PATH  [1], new File(DEFAULT_IE_PATH     ));
                    initPropertyString (KEY_APP_OPTION[0] + "ie"      + KEY_APP_OPTION[1], ""                            );
                    initPropertyBoolean(KEY_APP_ONLINE[0] + "ie"      + KEY_APP_ONLINE[1], true                          );
                } else {
                    properties.put(KEY_APP_LIST, "mozilla");
                    initPropertyString (KEY_APP_NAME  [0] + "mozilla" + KEY_APP_NAME  [1], "Mozilla"                     );
                    initPropertyFile   (KEY_APP_PATH  [0] + "mozilla" + KEY_APP_PATH  [1], new File(DEFAULT_MOZILLA_PATH));
                    initPropertyString (KEY_APP_OPTION[0] + "mozilla" + KEY_APP_OPTION[1], ""                            );
                    initPropertyBoolean(KEY_APP_ONLINE[0] + "mozilla" + KEY_APP_ONLINE[1], true                          );
                }
            }
        }

        loadApplications(this);
    }

    // SSL
    public  static final String KEY_SSL_KEYSTORE_USER_PATH     = "ssl.keystore.user.path";
    public  static final String KEY_SSL_KEYSTORE_SYSTEM_PATH   = "ssl.keystore.system.path";
    public  static final String KEY_SSL_TRUSTSTORE_USER_PATH   = "ssl.truststore.user.path";
    public  static final String KEY_SSL_TRUSTSTORE_SYSTEM_PATH = "ssl.truststore.system.path";
    /**  */
    private void initializeSSL() {
        initPropertyFile(KEY_SSL_KEYSTORE_USER_PATH    , new File(userHome    , DEFAULT_KEYSTORE_USER_PATH    ));
        initPropertyFile(KEY_SSL_KEYSTORE_SYSTEM_PATH  , new File(kagetakaHome, DEFAULT_KEYSTORE_SYSTEM_PATH  ));
        initPropertyFile(KEY_SSL_TRUSTSTORE_USER_PATH  , new File(userHome    , DEFAULT_TRUSTSTORE_USER_PATH  ));
        initPropertyFile(KEY_SSL_TRUSTSTORE_SYSTEM_PATH, new File(kagetakaHome, DEFAULT_TRUSTSTORE_SYSTEM_PATH));
    }

    // 
    public  static final String KEY_HISTORY_PATH            = "history.path";
    public  static final String KEY_HISTORY_SAVE_NUM        = "history.save.num";
    public  static final String KEY_HISTORY_WINDOW_POSITION = "history.window.position";
    public  static final String KEY_HISTORY_WINDOW_SIZE     = "history.window.size";
    /**  */
    private void initializeHistory() {
        initPropertyFile     (KEY_HISTORY_PATH           , new File(userHome, DEFAULT_HISTORY_PATH));
        initPropertyInteger  (KEY_HISTORY_SAVE_NUM       , 500                                     );
        initPropertyPoint    (KEY_HISTORY_WINDOW_POSITION, null                                    );
        initPropertyDimension(KEY_HISTORY_WINDOW_SIZE    , new Dimension(360, 300)                 );
    }

    // ֥åޡ
    public  static final String KEY_BOOKMARKS_PATH            = "bookmarks.path";
    public  static final String KEY_BOOKMARKS_WINDOW_POSITION = "bookmarks.window.position";
    public  static final String KEY_BOOKMARKS_WINDOW_SIZE     = "bookmarks.window.size";
    /**  */
    private void initializeBookmarks() {
        initPropertyFile     (KEY_BOOKMARKS_PATH           , new File(userHome, DEFAULT_BOOKMARKS_PATH));
        initPropertyPoint    (KEY_BOOKMARKS_WINDOW_POSITION, null                                      );
        initPropertyDimension(KEY_BOOKMARKS_WINDOW_SIZE    , new Dimension(380, 250)                   );
    }

    // å
    public  static final String KEY_COOKIE_PATH            = "cookie.path";
    public  static final String KEY_COOKIE_SAVE            = "cookie.save";
    public  static final String KEY_COOKIE_ACCEPT_STRICT   = "cookie.accept.strict";
    public  static final String KEY_COOKIE_ACCEPT_SESSION  = "cookie.accept.session";
    public  static final String KEY_COOKIE_ACCEPT_STRAGE   = "cookie.accept.strage";
    public  static final String KEY_COOKIE_WINDOW_POSITION = "cookie.window.position";
    public  static final String KEY_COOKIE_WINDOW_SIZE     = "cookie.window.size";
    /**  */
    private void initializeCookie() {
        initPropertyFile     (KEY_COOKIE_PATH           , new File(userHome, DEFAULT_COOKIE_PATH));
        initPropertyBoolean  (KEY_COOKIE_SAVE           , true                                   );
        initPropertyBoolean  (KEY_COOKIE_ACCEPT_STRICT  , false                                  );
        initPropertyString   (KEY_COOKIE_ACCEPT_SESSION , CookieManager.YES                      );
        initPropertyString   (KEY_COOKIE_ACCEPT_STRAGE  , CookieManager.YES                      );
        initPropertyPoint    (KEY_COOKIE_WINDOW_POSITION, null                                   );
        initPropertyDimension(KEY_COOKIE_WINDOW_SIZE    , new Dimension(360, 300)                );
    }

    // 
    public  static final String KEY_DOWNLOAD_WINDOW_POSITION = "download.window.position";
    public  static final String KEY_DOWNLOAD_WINDOW_CLOSE    = "download.window.close";
    public  static final String KEY_DOWNLOAD_SAVE_PATH       = "download.save.path";
    /**  */
    private void initializeDownload() {
        initPropertyPoint  (KEY_DOWNLOAD_WINDOW_POSITION, null);
        initPropertyBoolean(KEY_DOWNLOAD_WINDOW_CLOSE   , true);
        initPropertyFile   (KEY_DOWNLOAD_SAVE_PATH      , null);
    }

    // ơ
    public  static final String KEY_THEME_USER_PATH   = "theme.user.path";
    public  static final String KEY_THEME_SYSTEM_PATH = "theme.system.path";
    public  static final String KEY_THEME_KEY         = "theme.key";
    /**  */
    private void initializeTheme() {
        initPropertyFile  (KEY_THEME_USER_PATH  , new File(userHome    , DEFAULT_THEME_USER_PATH  ));
        initPropertyFile  (KEY_THEME_SYSTEM_PATH, new File(kagetakaHome, DEFAULT_THEME_SYSTEM_PATH));
        initPropertyString(KEY_THEME_KEY        , "system"                                         );
    }

    // ޥ͡
    /** @serial SSL ޥ͡ */
    private SSLManager      sslManager;
    /** @serial ޥ͡ */
    private HistoryManager  historyManager;
    /** @serial ֥åޡޥ͡ */
    private BookmarkManager bookmarkManager;
    /** @serial åޥ͡ */
    private CookieManager   cookieManager;
    /** @serial ơޥޥ͡ */
    private ThemeManager    themeManager;
    /** @serial 륳󥽡 */
    private ViewerConsole   viewerConsole;
    /** @serial ġå */
    private ToolTip         toolTip;

    // ¾
    /** @serial ץ */
    private Proxy[]       proxies;
    /** @serial ץ쥯ȥΡ */
    private Node[]        proxyDirectNodes;
    /** @serial Socks  */
    private boolean       proxyUseSocks;
    /** @serial ץꥱ */
    private Application[] applications;

    /**
     * ǥեȤΥץɤ߹ߤޤ
     */
    public ViewerOption() {
        this(defaultSystemOptionPath, defaultUserOptionPath);
    }

    /**
     * ǥեȤΥץɤ߹ߤޤ
     *
     * @param  system ƥΤΥץǥ쥯ȥ
     * @param  user   桼ѤΥץǥ쥯ȥ
     */
    public ViewerOption(String system, String user) {
        this((system != null ? new File(system) : null),
             (user   != null ? new File(user  ) : null));
    }

    /**
     * ǥեȤΥץɤ߹ߤޤ
     *
     * @param  system ƥΤΥץǥ쥯ȥ
     * @param  user   桼ѤΥץǥ쥯ȥ
     */
    public ViewerOption(File system, File user) {
        defaultProperties = new Hashtable();

        try {
            if (system != null) {
                systemProperties = new ExProperties(system);
            }
        } catch (FileNotFoundException e) {
        } catch (IOException e) {
            //### ERROR
e.printStackTrace(Debug.out);
        }

        try {
            userProperties = new ExProperties(systemProperties, user, true);
        } catch (FileNotFoundException e) {
        } catch (IOException e) {
            //### ERROR
e.printStackTrace(Debug.out);
        }

        userHome = (user != null ? user : new File(".")).getParent();

        addListener(new DefaultOptionListener());

        // 
        initializeBasic    ();
        initializeBrowser  ();
        initializeApp      ();
        initializeSSL      ();
        initializeHistory  ();
        initializeBookmarks();
        initializeCookie   ();
        initializeDownload ();
        initializeTheme    ();

        // ޥ͡
        sslManager      = SSLManager.createInstance(this);
        historyManager  = new HistoryManager (this);
        bookmarkManager = new BookmarkManager(this);
        cookieManager   = new CookieManager  (this);
        themeManager    = new ThemeManager   (this);
        viewerConsole   = new ViewerConsole  (this);

        // ¾
        if (Environment.javaVersion >= 104) {
            AWTWrapper awtWrapper = AWTWrapper.getInstance();
            if (awtWrapper != null) {
                awtWrapper.setDynamicLayout(Toolkit.getDefaultToolkit(),
                                            getPropertyBoolean(KEY_SCREEN_DYNAMIC_LAYOUT).booleanValue());
            }
        }
        if (getPropertyBoolean(KEY_TOOLTIP_CONTROL_USE).booleanValue()) {
            toolTip = new ToolTip(getPropertyInteger(KEY_TOOLTIP_CONTROL_DELAY).intValue(),
                                  getPropertyInteger(KEY_TOOLTIP_CONTROL_TERM ).intValue());
        }

        //### TODO ƥ󥷥ɤ߹

        if (listeners.size() > 0) {
            ViewerController controller = new ViewerController();
            for (int i = 0; i < listeners.size(); i++) {
                ((OptionListener) listeners.elementAt(i)).propertiesChanged(this, controller, properties.keys());
            }
        }
    }

    /**
     * 桼ѤΥץѥƥե˸ߤ񤭽Фޤ
     */
    public synchronized void save() {
        // ¸ץѥƥʥǥեͤƱ¸ʤ
        Object key, def, value;
        for (Enumeration e = properties.keys(); e.hasMoreElements();) {
            key   = e.nextElement();
            value = properties.get(key);
            def   = defaultProperties.get(key);

//Debug.out.println(key+","+value+","+def);
            if (def == null || !def.equals(value) || userProperties.containsKey(key)) {
                userProperties.put(key, value);
            } else {
                userProperties.remove(key);
            }
        }

        try {
            userProperties.save(defaultList);
        } catch (IOException e) {
            //### ERROR
e.printStackTrace(Debug.out);
        }

        historyManager .save();
        bookmarkManager.save();
        cookieManager  .save();
    }

    /** ץꥱɤޤ */
    private void loadApplications(ViewerOption option) {
        Vector   v    = new Vector();
        String[] list = option.getPropertyStrings(KEY_APP_LIST);
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                String id   = list[i];
                String name = option.getPropertyString(KEY_APP_NAME[0] + id + KEY_APP_NAME[1]);
                File   path = option.getPropertyFile  (KEY_APP_PATH[0] + id + KEY_APP_PATH[1]);
                if (/*---*/name == null || name.length() == 0
                        || path == null || path.length() == 0) {
                    continue;
                }

                v.addElement(new Application(id, name, path,
                                             option.getPropertyString (KEY_APP_OPTION[0] + id + KEY_APP_OPTION[1]),
                                             option.getPropertyBoolean(KEY_APP_ONLINE[0] + id + KEY_APP_ONLINE[1], false)));
            }
        }

        applications = new Application[v.size()];
        v.copyInto(applications);
    }

    /** ץɤޤ */
    private void loadProxy(ViewerOption option) {
        Boolean b = option.getPropertyBoolean(KEY_PROXY_USE);
        if (b != null && b.booleanValue()) {
            proxies = new Proxy[]{new Proxy(option.getPropertyString (KEY_PROXY_HTTP_HOST    ),
                                            option.getPropertyInteger(KEY_PROXY_HTTP_PORT , 0)),
                                  new Proxy(option.getPropertyString (KEY_PROXY_HTTPS_HOST   ),
                                            option.getPropertyInteger(KEY_PROXY_HTTPS_PORT, 0)),
                                  new Proxy(option.getPropertyString (KEY_PROXY_FTP_HOST     ),
                                            option.getPropertyInteger(KEY_PROXY_FTP_PORT  , 0))};

            String direct = option.getPropertyString(KEY_PROXY_DIRECT);
            if (direct != null) {
                StringTokenizer st = new StringTokenizer(direct, " ,|");
                Vector          v  = new Vector();
                while (st.hasMoreTokens()) {
                    v.addElement(new Node(st.nextToken().toLowerCase()));
                }

                proxyDirectNodes = new Node[v.size()];
                v.copyInto(proxyDirectNodes);
            }

            String socks = option.getPropertyString(KEY_PROXY_SOCKS_HOST);
            if (proxyUseSocks = (socks != null && socks.length() > 0)) {
                putSystemProperty("socksProxyHost", socks);
                putSystemProperty("socksProxyPort", option.getPropertyInteger(KEY_PROXY_SOCKS_PORT));
            } else {
                putSystemProperty("socksProxyHost", (String ) null);
                putSystemProperty("socksProxyPort", (Integer) null);
            }
        } else {
            proxies          = null;
            proxyDirectNodes = null;
            proxyUseSocks    = false;
            putSystemProperty("socksProxyHost", (String ) null);
            putSystemProperty("socksProxyPort", (Integer) null);
        }
    }

    /**
     * 桼Υۡǥ쥯ȥ֤ޤ
     *
     * @return 桼Υۡǥ쥯ȥ
     */
    public String getUserHome() {
        return userHome;
    }

    /**
     * Υۡǥ쥯ȥ֤ޤ
     *
     * @return Υۡǥ쥯ȥ
     */
    public String getKagetakaHome() {
        return kagetakaHome;
    }

    /**
     * ꤵ줿ǥ쥯ȥ꤬¸ߤ뤫Ĵ١
     * ¸ߤʤϺޤ
     *
     * @param  path ǥ쥯ȥΥѥ
     *
     * @return ǥ쥯ȥ꤬¸ߤ뤤ϺǤ
     *         <code>true</code>Ǥʤä <code>false</code>
     */
    public static boolean ensureDirectory(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            directory.mkdirs();
            if (!directory.exists()) {
                return false;
            }
        }
        return true;
    }

    /** ƥץѥƥ */
    private void putSystemProperty(String key, Integer value) {
        putSystemProperty(key, (value != null ? value.toString() : null));
    }

    /** ƥץѥƥ */
    private void putSystemProperty(String key, String value) {
        if (value != null) {
            System.getProperties().put(key, value);
        } else {
            System.getProperties().remove(key);
        }
    }

    /**
     * ץꥹʤϿޤ
     *
     * @param  l Ͽꥹ
     */
    public void addListener(OptionListener l) {
        listeners.addElement(l);
    }

    /**
     * ץꥹʤޤ
     *
     * @param  l ꥹ
     */
    public void removeListener(OptionListener l) {
        listeners.removeElement(l);
    }

    /**
     * ץѥƥѹ뤿Υåޤ
     *
     * @return å
     */
    public Setter getSetter() {
        return new Setter(this);
    }

//### init
    /**
     * ץѥƥιܤ <code>boolean</code> ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyBoolean(String key, boolean value) {
        setDefault(key, new Boolean(value), TYPE_BOOLEAN);
    }

    /**
     * ץѥƥιܤ <code>int</code> ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyInteger(String key, int value) {
        setDefault(key, new Integer(value), TYPE_INT);
    }

    /**
     * ץѥƥιܤ <code>double</code> ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyDouble(String key, double value) {
        setDefault(key, new Double(value), TYPE_DOUBLE);
    }

    /**
     * ץѥƥιܤ {@link Boolean} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyBoolean(String key, Boolean value) {
        setDefault(key, value, TYPE_BOOLEAN);
    }

    /**
     * ץѥƥιܤ {@link Integer} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyInteger(String key, Integer value) {
        setDefault(key, value, TYPE_INT);
    }

    /**
     * ץѥƥιܤ {@link Double} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyDouble(String key, Double value) {
        setDefault(key, value, TYPE_DOUBLE);
    }

    /**
     * ץѥƥιܤ {@link String} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyString(String key, String value) {
        setDefault(key, value, TYPE_STRING);
    }

    /**
     * ץѥƥιܤ {@link String} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  values 
     */
    public void initPropertyStrings(String key, String[] values) {
        setDefault(key, values, TYPE_STRINGS);
    }

    /**
     * ץѥƥιܤ {@link Dimension} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyDimension(String key, Dimension value) {
        setDefault(key, value, TYPE_DIMENSION);
    }

    /**
     * ץѥƥιܤ {@link Font} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyFont(String key, Font value) {
        setDefault(key, value, TYPE_FONT);
    }

    /**
     * ץѥƥιܤ {@link Point} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyPoint(String key, Point value) {
        setDefault(key, value, TYPE_POINT);
    }

    /**
     * ץѥƥιܤ {@link File} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyFile(String key, File value) {
        setDefault(key, value, TYPE_FILE);
    }

    /**
     * ץѥƥιܤ {@link CharList} ǽޤ
     * ѤץѥƥϡɬΥ᥽åɤƤӽФ
     * ɬפޤ
     *
     * @param  key   
     * @param  value 
     */
    public void initPropertyCharList(String key, CharList value) {
        setDefault(key, value, TYPE_CHARLIST);
    }

    /** ͤꤹ */
    private synchronized void setDefault(String key, Object defValue, int type) {
        Object o = null;

        // ꥹȤ򹹿
        synchronized (defaultKey) {
            if (defaultKey.containsKey(key)) {
                return;
            }

            defaultKey .put(key, key);
            defaultList.addElement(key);
        }

        switch (type) {
        case TYPE_BOOLEAN  : defaultTypes.put(key, OBJECT_BOOLEAN  ); break;
        case TYPE_INT      : defaultTypes.put(key, OBJECT_INT      ); break;
        case TYPE_DOUBLE   : defaultTypes.put(key, OBJECT_DOUBLE   ); break;
        case TYPE_STRING   : defaultTypes.put(key, OBJECT_STRING   ); break;
        case TYPE_STRINGS  : defaultTypes.put(key, OBJECT_STRINGS  ); break;
        case TYPE_DIMENSION: defaultTypes.put(key, OBJECT_DIMENSION); break;
        case TYPE_FONT     : defaultTypes.put(key, OBJECT_FONT     ); break;
        case TYPE_POINT    : defaultTypes.put(key, OBJECT_POINT    ); break;
        case TYPE_FILE     : defaultTypes.put(key, OBJECT_FILE     ); break;
        case TYPE_CHARLIST : defaultTypes.put(key, OBJECT_CHARLIST ); break;
        default: // AVOID
        }

        // ƥץѥƥե뤫ǥեͤѹ
        if (systemProperties != null && systemProperties.containsKey(key)) {
            switch (type) {
            case TYPE_BOOLEAN  : o = systemProperties.getPropertyBoolean  (key); break;
            case TYPE_INT      : o = systemProperties.getPropertyInteger  (key); break;
            case TYPE_DOUBLE   : o = systemProperties.getPropertyDouble   (key); break;
            case TYPE_STRING   : o = systemProperties.getPropertyString   (key); break;
            case TYPE_STRINGS  : o = systemProperties.getPropertyStrings  (key); break;
            case TYPE_DIMENSION: o = systemProperties.getPropertyDimension(key); break;
            case TYPE_FONT     : o = systemProperties.getPropertyFont     (key); break;
            case TYPE_POINT    : o = systemProperties.getPropertyPoint    (key); break;
            case TYPE_FILE     : o = systemProperties.getPropertyFile     (key); break;
            case TYPE_CHARLIST : o = systemProperties.getPropertyCharList (key); break;
            default: // AVOID
            }
            if (o != null) {
                defValue = o;
            }
        }
        if (defValue != null) {
            defaultProperties.put(key, defValue);
        }

        // 桼ץѥƥե뤫ͤѹ
        if (userProperties != null && userProperties.containsKey(key)) {
            switch (type) {
            case TYPE_BOOLEAN  : o = userProperties.getPropertyBoolean  (key); break;
            case TYPE_INT      : o = userProperties.getPropertyInteger  (key); break;
            case TYPE_DOUBLE   : o = userProperties.getPropertyDouble   (key); break;
            case TYPE_STRING   : o = userProperties.getPropertyString   (key); break;
            case TYPE_STRINGS  : o = userProperties.getPropertyStrings  (key); break;
            case TYPE_DIMENSION: o = userProperties.getPropertyDimension(key); break;
            case TYPE_FONT     : o = userProperties.getPropertyFont     (key); break;
            case TYPE_POINT    : o = userProperties.getPropertyPoint    (key); break;
            case TYPE_FILE     : o = userProperties.getPropertyFile     (key); break;
            case TYPE_CHARLIST : o = userProperties.getPropertyCharList (key); break;
            default: // AVOID
            }
            if (o != null) {
                defValue = o;
            }
        }

        if (defValue != null) {
            properties.put(key, defValue);
        }
    }

//### get
    /**
     * ꤵ줿ĥץѥƥ{@link Boolean} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Boolean getPropertyBoolean(String key) {
        return (Boolean) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Boolean} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public boolean getPropertyBoolean(String key, boolean defval) {
        Boolean value = (Boolean) properties.get(key);
        return (value != null ? value.booleanValue() : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Integer} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Integer getPropertyInteger(String key) {
        return (Integer) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Integer} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public int getPropertyInteger(String key, int defval) {
        Integer value = (Integer) properties.get(key);
        return (value != null ? value.intValue() : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Double} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Double getPropertyDouble(String key) {
        return (Double) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Double} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public double getPropertyDouble(String key, double defval) {
        Double value = (Double) properties.get(key);
        return (value != null ? value.doubleValue() : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public String getPropertyString(String key) {
        return (String) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public String getPropertyString(String key, String defval) {
        String value = (String) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public String[] getPropertyStrings(String key) {
        return (String[]) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public String[] getPropertyStrings(String key, String[] defval) {
        String[] value = (String[]) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Dimension} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Dimension getPropertyDimension(String key) {
        return (Dimension) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Dimension} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public Dimension getPropertyDimension(String key, Dimension defval) {
        Dimension value = (Dimension) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Font} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Font getPropertyFont(String key) {
        return (Font) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Font} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public Font getPropertyFont(String key, Font defval) {
        Font value = (Font) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Point} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Point getPropertyPoint(String key) {
        return (Point) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Point} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public Point getPropertyPoint(String key, Point defval) {
        Point value = (Point) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link File} ֤ޤ
     * <p>
     * ХѥꤵƤǡץѥƥե뤫ɤǤϡ
     * ΥץѥƥեΥѥХѥ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public File getPropertyFile(String key) {
        return (File) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link File} ֤ޤ
     * <p>
     * ХѥꤵƤǡץѥƥե뤫ɤǤϡ
     * ΥץѥƥեΥѥХѥ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public File getPropertyFile(String key, File defval) {
        File value = (File) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link CharList} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public CharList getPropertyCharList(String key) {
        return (CharList) properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link CharList} ֤ޤ
     *
     * @param  key ץѥƥ
     * @param  defval ǥե
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    public CharList getPropertyCharList(String key, CharList defval) {
        CharList value = (CharList) properties.get(key);
        return (value != null ? value : defval);
    }

    /**
     * ꤵ줿ĥץѥƥ򤽤Τޤ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤϥǥե
     */
    Object getPropertyObject(String key) {
        return properties.get(key);
    }

    /**
     * ꤵ줿ĥץѥƥ¸ߤ뤫ɤ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ¸ߤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean containsPropertyKey(String key) {
        return properties.containsKey(key);
    }

    /**
     * ץѥƥΥפ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥΥ
     */
    public int getPropertyType(String key) {
        Integer i = (Integer) defaultTypes.get(key);
        if (i == null) {
            return -1;
        }

        return i.intValue();
    }

//### ɸ
    /** {@inheritDoc} */
    public String getInputStreamParser() {
        return getPropertyString(KEY_PARSER_INPUT);
    }

    /** {@inheritDoc} */
    public void setInputStreamParser(String value) {
        properties.put(KEY_PARSER_INPUT, value);
    }

    /** {@inheritDoc} */
    public String[] getFilterParsers() {
        return getPropertyStrings(KEY_PARSER_FILTERS);
    }

    /** {@inheritDoc} */
    public void setFilterParsers(String[] value) {
        properties.put(KEY_PARSER_FILTERS, value);
    }

    /** {@inheritDoc} */
    public String getFontStyle() {
        return getPropertyString(KEY_FONT_STYLE);
    }

    /** {@inheritDoc} */
    public void setFontStyle(String value) {
        properties.put(KEY_FONT_STYLE, value);
    }

    /** {@inheritDoc} */
    public Font getFontSerif() {
        return getPropertyFont(KEY_FONT_STYLE_SERIF);
    }

    /** {@inheritDoc} */
    public void setFontSerif(Font value) {
        properties.put(KEY_FONT_STYLE_SERIF, value);
    }

    /** {@inheritDoc} */
    public Font getFontSansSerif() {
        return getPropertyFont(KEY_FONT_STYLE_SANS_SERIF);
    }

    /** {@inheritDoc} */
    public void setFontSansSerif(Font value) {
        properties.put(KEY_FONT_STYLE_SANS_SERIF, value);
    }

    /** {@inheritDoc} */
    public Font getFontCursive() {
        return getPropertyFont(KEY_FONT_STYLE_CURSIVE);
    }

    /** {@inheritDoc} */
    public void setFontCursive(Font value) {
        properties.put(KEY_FONT_STYLE_CURSIVE, value);
    }

    /** {@inheritDoc} */
    public Font getFontFantasy() {
        return getPropertyFont(KEY_FONT_STYLE_FANTASY);
    }

    /** {@inheritDoc} */
    public void setFontFantasy(Font value) {
        properties.put(KEY_FONT_STYLE_FANTASY, value);
    }

    /** {@inheritDoc} */
    public Font getFontMonospace() {
        return getPropertyFont(KEY_FONT_STYLE_MONOSPACE);
    }

    /** {@inheritDoc} */
    public void setFontMonospace(Font value) {
        properties.put(KEY_FONT_STYLE_MONOSPACE, value);
    }

    /** {@inheritDoc} */
    public double getFontScale() {
        return getPropertyDouble(KEY_FONT_OPTION_SCALE, 0);
    }

    /** {@inheritDoc} */
    public void setFontScale(double value) {
        properties.put(KEY_FONT_OPTION_SCALE, new Double(value));
    }

    /** {@inheritDoc} */
    public boolean getAntiAliasing() {
        return getPropertyBoolean(KEY_FONT_OPTION_ANTIALIASING, false);
    }

    /** {@inheritDoc} */
    public void setAntiAliasing(boolean value) {
        properties.put(KEY_FONT_OPTION_ANTIALIASING, new Boolean(value));
    }

    /** {@inheritDoc} */
    public CharList getCharsSpinRight() {
        return getPropertyCharList(KEY_CHARS_SPIN_RIGHT);
    }

    /** {@inheritDoc} */
    public void setCharsSpinRight(CharList value) {
        properties.put(KEY_CHARS_SPIN_RIGHT, value);
    }

    /** {@inheritDoc} */
    public CharList getCharsSpinLtrb() {
        return getPropertyCharList(KEY_CHARS_SPIN_LTRB);
    }

    /** {@inheritDoc} */
    public void setCharsSpinLtrb(CharList value) {
        properties.put(KEY_CHARS_SPIN_LTRB, value);
    }

    /** {@inheritDoc} */
    public CharList getCharsKinsokuHead() {
        return getPropertyCharList(KEY_CHARS_KINSOKU_HEAD);
    }

    /** {@inheritDoc} */
    public void setCharsKinsokuHead(CharList value) {
        properties.put(KEY_CHARS_KINSOKU_HEAD, value);
    }

    /** {@inheritDoc} */
    public CharList getCharsKinsokuTail() {
        return getPropertyCharList(KEY_CHARS_KINSOKU_TAIL);
    }

    /** {@inheritDoc} */
    public void setCharsKinsokuTail(CharList value) {
        properties.put(KEY_CHARS_KINSOKU_TAIL, value);
    }

    /** {@inheritDoc} */
    public boolean getSwapDecoration() {
        return getPropertyBoolean(KEY_STYLE_DECORATION_SWAP, false);
    }

    /** {@inheritDoc} */
    public void setSwapDecoration(boolean value) {
        properties.put(KEY_STYLE_DECORATION_SWAP, new Boolean(value));
    }

    /** {@inheritDoc} */
    public boolean getLoadImage() {
        return getPropertyBoolean(KEY_LOAD_IMAGE, true);
    }

    /** {@inheritDoc} */
    public void setLoadImage(boolean value) {
        properties.put(KEY_LOAD_IMAGE, new Boolean(value));
    }

    /** {@inheritDoc} */
    public boolean getSpinImage() {
        return getPropertyBoolean(KEY_SPIN_IMAGE, true);
    }

    /** {@inheritDoc} */
    public void setSpinImage(boolean value) {
        properties.put(KEY_SPIN_IMAGE, new Boolean(value));
    }

    /** {@inheritDoc} */
    public boolean getSpinImage(String type) {
        if (!spinImageTable.containsKey(type)) {
            type = "*";
        }
        return getPropertyBoolean(KEY_SPIN_IMAGE_PRE + type, true);
    }

    /** {@inheritDoc} */
    public void setSpinImage(String type, boolean value) {
        properties.put(KEY_SPIN_IMAGE_PRE + type, new Boolean(value));
    }

    /** {@inheritDoc} */
    public double getSpinAspectRatio(String type) {
        if (!spinImageTable.containsKey(type)) {
            type = "*";
        }
        return getPropertyDouble(KEY_SPIN_IMAGE_PRE + type + KEY_SPIN_IMAGE_EXT_ASPECTRATIO, 0);
    }

    /** {@inheritDoc} */
    public void setSpinAspectRatio(String type, double value) {
        properties.put(KEY_SPIN_IMAGE_PRE + type + KEY_SPIN_IMAGE_EXT_ASPECTRATIO, new Double (value));
    }

    /** {@inheritDoc} */
    public int getSpinMinWidth(String type) {
        if (!spinImageTable.containsKey(type)) {
            type = "*";
        }
        return getPropertyInteger(KEY_SPIN_IMAGE_PRE + type + KEY_SPIN_IMAGE_EXT_MINWIDTH, 0);
    }

    /** {@inheritDoc} */
    public void setSpinMinWidth(String type, int value) {
        properties.put(KEY_SPIN_IMAGE_PRE + type + KEY_SPIN_IMAGE_EXT_MINWIDTH, new Integer(value));
    }

//### ޥ͡
    /**
     * SSL ޥ֤͡ޤ
     *
     * @return SSL ޥ͡
     */
    public SSLManager getSSLManager() {
        return sslManager;
    }

    /**
     * ޥ֤͡ޤ
     *
     * @return ޥ͡
     */
    public HistoryManager getHistoryManager() {
        return historyManager;
    }

    /**
     * ֥åޡޥ֤͡ޤ
     *
     * @return ֥åޡޥ͡
     */
    public BookmarkManager getBookmarkManager() {
        return bookmarkManager;
    }

    /**
     * åޥ֤͡ޤ
     *
     * @return åޥ͡
     */
    public CookieManager getCookieManager() {
        return cookieManager;
    }

    /**
     * ơޥޥ֤͡ޤ
     *
     * @return ơޥޥ͡
     */
    public ThemeManager getThemeManager() {
        return themeManager;
    }

    /**
     * 륳󥽡Υ󥹥󥹤֤ޤ
     *
     * @return 륳󥽡
     */
    public ViewerConsole getViewerConsole() {
        return viewerConsole;
    }

    /**
     * ġåפΥ󥹥󥹤֤ޤ
     *
     * @return ġå
     */
    public ToolTip getToolTip() {
        return toolTip;
    }

//### ¾
    /**
     * ꤵ줿 URL ؤ³ɬפʡץ URL ֤ޤ
     *
     * @param  url ³ URL
     *
     * @return ץ URL
     *         ץѤʤ <code>null</code>
     */
    public URL getProxyURL(URL url) {
        if (proxyUseSocks) {
            return null;
        }

        Proxy[] proxies = this.proxies;
        if (proxies == null) {
            return null;
        }

        Node[] nodes = this.proxyDirectNodes;
        if (nodes != null) {
            String host = url.getHost().toLowerCase();
            for (int i = 0; i < nodes.length; i++) {
                if (nodes[i].isMatch(host)) {
                    return null;
                }
            }
        }

        String protocol = url.getProtocol().toLowerCase();
        if (protocol.compareTo("http" ) == 0) {
            return proxies[PROXY_HTTP ].url;
        }
        if (protocol.compareTo("https") == 0) {
            return proxies[PROXY_HTTPS].url;
        }
        if (protocol.compareTo("ftp"  ) == 0) {
            return proxies[PROXY_FTP  ].url;
        }

        return null;
    }

    /**
     * žβװ֤ޤ
     *
     * @return װ
     */
    public Enumeration getSpinImageKeys() {
        return spinImageTable.keys();
    }

    /**
     * ץꥱ֤ޤ
     *
     * @return ץꥱ
     */
    public Application[] getApplications() {
        return applications;
    }

    /**
     * ץޥ͡ɽޤ
     *
     * @param  owner ʡ
     */
    public void showManager(Frame owner) {
        OptionDialog.show(owner, this);
    }

//### File Ѵ
    /**
     * եѥХѥѴޤ
     * Хѥδ֤ϡ桼ץѥƥեΤǥ쥯ȥˤʤޤ
     *
     * @param  path եѥ
     *
     * @return Υץѥƥɤ߹ǥ쥯ȥ겼ξХѥ
     *         ʳξ <code>path</code> 
     */
    public File convertCanonicalToRelative(File path) {
        return userProperties.convertCanonicalToRelative(path);
    }

    /**
     * ХѥХѥѴޤ
     * Хѥδ֤ϡ桼ץѥƥեΤǥ쥯ȥˤʤޤ
     *
     * @param  path եѥ
     *
     * @return ХѥξХѥˡ
     *         ʳξ <code>path</code> 
     */
    public File convertRelativeToCanonical(File path) {
        return userProperties.convertRelativeToCanonical(path);
    }

//### DefaultOptionListener
    /** ǥեȥץꥹ */
    private final class DefaultOptionListener implements OptionListener {
        /** 󥹥󥹤 */
        private DefaultOptionListener() {
        }

        /** {@inheritDoc} */
        public void propertyChange(ViewerOption option, String key, Object oldValue, Object newValue)
                throws InvalidValueException {
        }

        /** {@inheritDoc} */
        public void propertiesChanged(ViewerOption option, ViewerController c, Enumeration list) {
            boolean loadApplications = false;
            boolean loadProxy        = false;
            String key;
            while (list.hasMoreElements()) {
                key = (String) list.nextElement();

                // ץꥱ
                if (!loadApplications && key.startsWith(KEY_APP)) {
                    loadApplications(option);
                    loadApplications = true;
                    continue;
                }

                // ץ
                if (!loadProxy && key.startsWith(KEY_PROXY)) {
                    loadProxy(option);
                    loadProxy = true;
                    continue;
                }
            }
        }
    }

//### Proxy
    /** ץ */
    private static final class Proxy {
        private URL url;

        /** 󥹥󥹤 */
        private Proxy(String host, int port) {
            if (host != null && host.length() > 0) {
                try {
                    this.url = new URL("http", host, port, "");
                } catch (MalformedURLException e) {
                    // ̵뤹
                }
            }
        }
    }

//### Node
    /** ̵Ρ */
    private static final class Node {
        private static final int EXACT  = 0;
        private static final int SUFFIX = 1;
        private static final int PREFIX = 2;
        private int    mode;
        private String regexp;

        /** 󥹥󥹤 */
        private Node(String name) {
            int length = name.length();
            if (name.charAt(0) == '*') {
                mode   = SUFFIX;
                regexp = name.substring(1, length);
            } else if (name.charAt(length - 1) == '*') {
                mode   = PREFIX;
                regexp = name.substring(0, length - 1);
            } else {
                mode   = EXACT;
                regexp = name;
            }
        }

        /** ޥå뤫 */
        private boolean isMatch(String host) {
            switch (mode) {
            case EXACT : return (host.compareTo(regexp) == 0);
            case SUFFIX: return host.endsWith  (regexp);
            case PREFIX: return host.startsWith(regexp);
            default: // AVOID
            }
            return false;
        }
    }

//### Applicaiton
    /**
     * ץꥱɽ饹Ǥ
     */
    public static final class Application {
        private String  id;
        private String  name;
        private File    path;
        private String  option;
        private boolean online;


        /**
         * ץꥱޤ
         *
         * @param  id ID
         * @param  name ̾
         * @param  path ѥ
         * @param  option ץ
         * @param  online 饤󥢥ץꥱξ <code>true</code>
         *                ʳξ <code>false</code>
         */
        public Application(String id, String name, File path, String option, boolean online) {
            this.id     = id;
            this.name   = name;
            this.path   = path;
            this.option = option;
            this.online = online;
        }

        /**
         * ץꥱ ID ֤ޤ
         *
         * @return ץꥱ ID
         */
        public String getId() {
            return id;
        }

        /**
         * ץꥱ֤̾ޤ
         *
         * @return ץꥱ̾
         */
        public String getName() {
            return name;
        }

        /**
         * ץꥱѥ֤ޤ
         *
         * @return ץꥱѥ
         */
        public File getPath() {
            return path;
        }

        /**
         * ץ֤ޤ
         *
         * @return ץ
         */
        public String getOption() {
            return option;
        }

        /**
         * ץϤѥʤɤץ֤ޤ
         *
         * @param  arg 
         *
         * @return ѥʤɤץ
         */
        public String getOption(String arg) {
            if (option == null || option.length() == 0) {
                return arg;
            }

            int p = option.indexOf("%s");
            if (p == -1) {
                return option;
            }

            return option.substring(0, p) + arg + option.substring(p + 2);
        }

        /**
         * 饤󥢥ץꥱ󤫤ɤ֤ޤ
         *
         * @return 饤󥢥ץꥱξ <code>true</code>
         *         ʳξ <code>false</code>
         */
        public boolean getOnline() {
            return online;
        }

        /**
         * ꤷ URL 򥢥ץꥱǳޤ
         *
         * @param  url    URL
         * @param  local URL бե
         * @param  exec  ¹Ԥ륳ޥɥ饤Ǽޤ
         *               Ǽɬפʤ <code>null</code>
         *
         * @return ¹Ԥ줿ץ
         *
         * @throws IOException ¹Ի˥顼ȯ
         */
        public Process exec(URL url, String local, StringBuffer exec)
                throws IOException {
            if (!online && local == null) {
                throw new IOException("Not exist cache file.");
            }

            String option  = getOption((online ? url.toString() : local));
            String command = path.getPath() + " " + option;

            if (exec != null) {
                exec.append(command);
            }

            return Runtime.getRuntime().exec(command);
        }
    }
}
