/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * ץѥƥͤꤹ뤿Υ饹Ǥ
 * <code>putProperty</code> ᥽åɤꤷ塢
 * {@link #commit()} ᥽åɤƤӽФȤˤꡢ
 * ºݤ˥ץѥƥꤵޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Setter {
    private ViewerOption     option;
    private Hashtable        oldProperties;
    private Hashtable        newProperties    = new Hashtable();
    private Hashtable        removeProperties;
    private Hashtable        defaultKey;
    private Vector           defaultList;
    private Hashtable        defaultProperties;
    private ExProperties     userProperties;
    private OptionListener[] listeners;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  option ץ
     */
    Setter(ViewerOption option) {
        this.option            = option;
        this.oldProperties     = option.properties;
        this.defaultKey        = option.defaultKey;
        this.defaultList       = option.defaultList;
        this.defaultProperties = option.defaultProperties;
        this.userProperties    = option.userProperties;
        this.listeners         = null;
        synchronized (option.listeners) {
            if (option.listeners.size() > 0) {
                listeners = new OptionListener[option.listeners.size()];
                option.listeners.copyInto(listeners);
            }
        }
    }

    /**
     * ꤵ줿ץѥƥŬѤޤ
     */
    public synchronized void commit() {
        synchronized (oldProperties) {
            Object key;
            for (Enumeration e = newProperties.keys(); e.hasMoreElements();) {
                key = e.nextElement();
                oldProperties.put(key, newProperties.get(key));
            }
        }

        if (listeners != null) {
            ViewerController controller = new ViewerController();
            for (int i = 0; i < listeners.length; i++) {
                listeners[i].propertiesChanged(option, controller, newProperties.keys());
            }
        }
    }

    /**
     * ꤵ줿ץѥƥ򥭥󥻥뤷ޤ
     */
    public synchronized void rollback() {
        newProperties.clear();
        if (removeProperties != null) {
            removeProperties.clear();
        }
    }

//### put
    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link Boolean} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Boolean putPropertyBoolean(String key, boolean value)
            throws InvalidValueException {
        return (Boolean) putProperty(key, new Boolean(value), true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link Integer} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Integer putPropertyInteger(String key, int value)
            throws InvalidValueException {
        return (Integer) putProperty(key, new Integer(value), true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link Double} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Double putPropertyDouble(String key, double value)
            throws InvalidValueException {
        return (Double) putProperty(key, new Double(value), true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Boolean putPropertyBoolean(String key, Boolean value)
            throws InvalidValueException {
        return (Boolean) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Integer putPropertyInteger(String key, Integer value)
            throws InvalidValueException {
        return (Integer) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Double putPropertyDouble(String key, Double value)
            throws InvalidValueException {
        return (Double) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public String putPropertyString(String key, String value)
            throws InvalidValueException {
        return (String) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public String[] putPropertyStrings(String key, String[] value)
            throws InvalidValueException {
        return (String[]) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Dimension putPropertyDimension(String key, Dimension value)
            throws InvalidValueException {
        return (Dimension) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Font putPropertyFont(String key, Font value)
            throws InvalidValueException {
        return (Font) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public Point putPropertyPoint(String key, Point value)
            throws InvalidValueException {
        return (Point) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * <p>
     * ץѥƥե뤫ɤƤơꤵ줿ե뤬
     * ץѥƥեʲΰ֤֤Ƥϡ
     * Хѥꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public File putPropertyFile(String key, File value)
            throws InvalidValueException {
        if (userProperties != null && value != null) {
            value = userProperties.convertRelativeToCanonical(value);
        }
        return (File) putProperty(key, value, true);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     *
     * @throws InvalidValueException
     *         ꤵ줿̵ͤ硣
     *         㳰ȯϡΥåꤵ줿
     *         ߥåΤ٤Ƥ꤬ưŪ˥󥻥뤵ޤ
     */
    public CharList putPropertyCharList(String key, CharList value)
            throws InvalidValueException {
        return (CharList) putProperty(key, value, true);
    }

//### remove
    /**
     * ꤵ줿бץѥƥͤᤷޤ
     *
     * @param  key   ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object removeProperty(String key) {
        try {
            return putProperty(key, defaultProperties.get(key), false);
        } catch (InvalidValueException e) {
            return null;                          // ȯʤ
        }
    }

//### private
    /** ץѥƥ */
    private synchronized Object putProperty(String key, Object newValue, boolean event)
            throws InvalidValueException {
        Object oldValue = null;

        // Ǹꤵ줿ץѥƥͤ
        if (removeProperties == null || !removeProperties.containsKey(key)) {
            oldValue = newProperties.get(key);
            if (oldValue == null) {
                oldValue = oldProperties.get(key);
            }
        }

        // ѹ٥Ȥȯ
        if (event && listeners != null) {
            try {
                for (int i = 0; i < listeners.length; i++) {
                    listeners[i].propertyChange(option, key, oldValue, newValue);
                }
            } catch (InvalidValueException e) {
                //### ERROR åɽ
Debug.out.println(e);
                if (!e.hasNewValue()) {
                    rollback();
                    throw e;
                }
                newValue = e.getNewValue();
            }
        }

        // ͤꤹ
        if (newValue != null) {
            newProperties.put(key, newValue);
            if (removeProperties != null) {
                removeProperties.remove(key);
            }

            // ꥹȤɲ
            synchronized (defaultKey) {
                if (!defaultKey.containsKey(key)) {
                    defaultKey .put(key, key);
                    defaultList.addElement(key);
                }
            }
        } else {
            newProperties.remove(key);
            if (removeProperties == null) {
                removeProperties = new Hashtable();
            }
            removeProperties.put(key, key);
        }

        return oldValue;
    }
}
