/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.addin.java2.AWTWrapper;
import net.hizlab.kagetaka.awt.BorderContainer;
import net.hizlab.kagetaka.awt.BrowseButton;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.awt.event.KeyFilter;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ץڡɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class OptionPage implements TreeItem {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.option.Resources";
    private static final int    MARGIN   = 3;

    private static FocusListener textSelector = new FocusListener() {
        /** ܡɥե */
        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof TextComponent) {
                ((TextComponent) c).selectAll();
            }
        }

        /** ܡɥե򼺤ä */
        public void focusLost(FocusEvent e) {
        }
    };

    private final ViewerOption viewerOption;
    private final String       resourcePath;
    private final Setter       setter;

    private ToolTip toolTip;

    final String   optionPath;
    final String   optionTitle;
    final String[] optionPaths;

    Vector child = new Vector();

    private Vector        items = new Vector();
    private MainPanel     panel;
    private GridBagLayout gbl;
    private int           maxY;

    /**
     * ץڡޤ
     *
     * @param  option ץ
     * @param  path ꥽ѥ
     * @param  setter å
     */
    OptionPage(ViewerOption option, String path, Setter setter) {
        this.viewerOption = option;
        this.resourcePath = path;
        this.setter       = setter;
        if ((optionPath   = getResource("kagetaka.option.path" )) == null) {
            throw new IllegalArgumentException("kagetaka.option.path not found" );
        }
        if ((optionTitle  = getResource("kagetaka.option.title")) == null) {
            throw new IllegalArgumentException("kagetaka.option.title not found");
        }
        toolTip = option.getToolTip();

        StringTokenizer st;

        st = new StringTokenizer(optionPath, "/");
        Vector v = new Vector();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        optionPaths = new String[v.size()];
        v.copyInto(optionPaths);

        String itemList = getResource("kagetaka.option.items");
        if (itemList != null) {
            Item item;
            st = new StringTokenizer(itemList, ",");
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                try {
                    item = new Item(key);
                    items.addElement(item);
                    if (item.layoutY > maxY) {
                        maxY = item.layoutY;
                    }
                } catch (Exception e) {
                    //### ERROR
Debug.out.println(key + ":" + e);
e.printStackTrace(Debug.out);
                } catch (ClassFormatError e) {
                    //### ERROR
Debug.out.println(key + ":" + e);
e.printStackTrace(Debug.out);
                }
            }
        }

        panel = new MainPanel(gbl = new GridBagLayout());
    }

    /** {@inheritDoc} */
    public Image getTreeIcon(boolean opened) {
        return null;
    }

    /** {@inheritDoc} */
    public String getTreeLabel() {
        return optionTitle;
    }

    /** {@inheritDoc} */
    public Vector getTreeItems() {
        return child;
    }

    /**
     * ƥʤ˥ݡͥȤ֤ޤ
     *
     * @param  container ƥ
     */
    void attachContainer(Container container) {
        for (int i = 0; i < items.size(); i++) {
            ((Item) items.elementAt(i)).attach(panel, gbl);
        }

        // ͤˤ뤿Υߡݡͥ
        LayoutUtils.addGridBag(panel, new Panel(), gbl, 0, maxY + 1, 1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.WEST, new Insets(0, 0, 0, 0));
        container.add(panel, optionPath);
    }

    /**
     * ¸ǡᤷޤ
     */
    void reload() {
        for (int i = 0; i < items.size(); i++) {
            ((Item) items.elementAt(i)).reload();
        }
    }

    /**
     * ͤᤷޤ
     */
    void reset() {
        for (int i = 0; i < items.size(); i++) {
            ((Item) items.elementAt(i)).reset();
        }
    }

    /**
     * ꥽ޤ
     */
    void dispose() {
        for (int i = 0; i < items.size(); i++) {
            ((Item) items.elementAt(i)).dispose();
        }
    }

    /** ڡ꥽ͤ */
    private String getResource(String key) {
        String s = Resource.getMessage(resourcePath, key, null, null);
        if (s == null) {
            return null;
        }

        return getResourceString(s.trim());
    }

    /** ڡ꥽ʸ */
    private String getResourceString(String key) {
        if (key.length() > 0 && key.charAt(0) == '@') {
            return getMessage(key.substring(1));
        }

        return key;
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        return Resource.getMessage(RESOURCE, key, null);
    }

//### MainPanel
    /** ᥤѥͥ */
    private final class MainPanel extends Panel {
        /** 󥹥󥹤 */
        private MainPanel(LayoutManager layout) {
            super(layout);
        }

        /**  */
        public void paint(Graphics g) {
            Dimension size = getSize();
            g.setColor(getBackground());
            g.fillRect(0, 0, size.width, size.height);

            paintComponents(g);
        }
    }

//### Item
    /** ƥ */
    private final class Item {
        private final String    key;
        private final String    type;
        private final String    title;
        private final String    tips;
        private final String    option;
        private final int       width;
        private final int       layoutX;
        private final int       layoutY;
        private final int       layoutWidth;
        private final int       layoutHeight;
        private final double    layoutWeightX;
        private final double    layoutWeightY;
        private final Component component;
        private final int       optionType;
        private final Object    optionDefault;
        private KeyFilter       filter;
        private OptionComponent optionComponent;

        /** 󥹥󥹤 */
        private Item(String key)
                throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassFormatError {
            this.key = key;

            StringTokenizer st;

            type   = getResource(key + ".type"  ).toLowerCase();
            title  = getResource(key + ".title" );
            tips   = getResource(key + ".tips"  );
            option = getResource(key + ".option");

            String layout = getResource(key + ".layout");
            st = new StringTokenizer(layout, ",");
            layoutX       = (st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0);
            layoutY       = (st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0);
            layoutWidth   = (st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0);
            layoutHeight  = (st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0);
            layoutWeightX = (st.hasMoreTokens() ? Double.valueOf(st.nextToken().trim()).doubleValue() : 1.0);
            layoutWeightY = (st.hasMoreTokens() ? Double.valueOf(st.nextToken().trim()).doubleValue() : 0.0);

            String widthString = getResource(key + ".width");
            width = (widthString != null ? Integer.parseInt(widthString.trim()) : 0);

            // ץξ
            if (option != null) {
                optionType    = viewerOption.getPropertyType  (option);
                optionDefault = viewerOption.getPropertyObject(option);
                if (optionType == -1) {
                    throw new IllegalArgumentException("invalid option name " + option);
                }
            } else {
                optionType    = -1;
                optionDefault = null;
            }

            // ٥
            if (type.compareTo("label") == 0) {
                component = new Label(title);
                return;
            }

            // åܥå
            if (type.compareTo("check") == 0) {
                Checkbox c = new Checkbox(title, viewerOption.getPropertyBoolean(option, false));
                c.addItemListener(new ComponentListener(viewerOption, setter, option, optionType));
                component = c;
                return;
            }

            // ƥȥܥå
            if (type.compareTo("text") == 0) {
                String s = "";
                switch (optionType) {
                case ViewerOption.TYPE_INT    :
                    s      = String.valueOf(viewerOption.getPropertyInteger(option, 0));
                    filter = new KeyFilter(KeyFilter.INT);
                    break;
                case ViewerOption.TYPE_DOUBLE :
                    s = String.valueOf(viewerOption.getPropertyDouble (option, 0));
                    filter = new KeyFilter(KeyFilter.DOUBLE);
                    break;
                case ViewerOption.TYPE_STRING :
                    s = viewerOption.getPropertyString(option);
                    break;
                case ViewerOption.TYPE_STRINGS:
                {
                    String[] list = viewerOption.getPropertyStrings(option);
                    if (list != null && list.length > 0) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(list[0]);
                        for (int i = 1; i < list.length; i++) {
                            sb.append(", ");
                            sb.append(list[i]);
                        }
                        s = sb.toString();
                    }

                    break;
                }
                case ViewerOption.TYPE_CHARLIST:
                {
                    CharList cl = viewerOption.getPropertyCharList(option);
                    if (cl != null) {
                        s = cl.toString();
                    }

                    break;
                }
                default:
                    throw new IllegalArgumentException("invalid type " + type);
                }
                if (s == null) {
                    s = "";
                }
                TextField c = new TextField(s, width);
                if (filter != null) {
                    filter.attach(c);
                }
                c.addTextListener (new ComponentListener(viewerOption, setter, option, optionType));
                c.addFocusListener(textSelector);
                component = new AlignPanel(new Label(title), 0, c, (width > 0 ? 0.5 : 1));
                return;
            }

            // ܥܥå
            if (type.compareTo("combo") == 0) {
                Vector values   = new Vector();
                Choice choice   = new Choice();
                String itemList = getResource(key + ".items");
                if (itemList != null) {
                    st = new StringTokenizer(itemList, ",");
                    String value;
                    while (st.hasMoreTokens()) {
                        value = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            values.addElement(getResourceString(value));
                            choice.add(getResourceString(st.nextToken().trim()));
                        }
                    }
                }
                String s = null;
                switch (optionType) {
                case ViewerOption.TYPE_INT   : s = String.valueOf(viewerOption.getPropertyInteger(option, 0)); break;
                case ViewerOption.TYPE_DOUBLE: s = String.valueOf(viewerOption.getPropertyDouble (option, 0)); break;
                case ViewerOption.TYPE_STRING: s = viewerOption.getPropertyString(option); break;
                default: // AVOID
                }
                if (s != null) {
                    int i = values.indexOf(s);
                    if (i != -1) {
                        choice.select(i);
                    }
                }
                choice.addItemListener(new ComponentListener(viewerOption, setter, option, optionType, values));
                AlignPanel c = new AlignPanel(new Label(title), 0, choice, 0.5);
                component = c;
                return;
            }

            // ե
            if (type.compareTo("font") == 0) {
                Font f = viewerOption.getPropertyFont(option);
                Choice    choice = new Choice();
                TextField text   = new TextField((f != null ? String.valueOf(f.getSize()) : ""), width);
                AWTWrapper awtw = AWTWrapper.getInstance();
                if (awtw != null) {
                    String[] list = awtw.getAvailableFontFamilyNames(Locale.JAPANESE);
                    for (int i = 0; i < list.length; i++) {
                        choice.add(list[i]);
                    }
                } else {
                    choice.add("SansSerif" );
                    choice.add("Serif"     );
                    choice.add("Monospaced");
                }
                if (f != null) {
                    choice.select(f.getName());
                }
                filter = new KeyFilter(KeyFilter.INT);
                filter.attach(text);

                choice.addItemListener (new ComponentListener(viewerOption, setter, option, optionType, text  ));
                text  .addTextListener (new ComponentListener(viewerOption, setter, option, optionType, choice));
                text  .addFocusListener(textSelector);
                AlignPanel c = new AlignPanel(new Label(title), 0, choice, 0, text, 0.5);
                component = c;
                return;
            }

            // ե롢ǥ쥯ȥ
            if (type.compareTo("file") == 0 || type.compareTo("directory") == 0) {
                File         f  = viewerOption.getPropertyFile(option);
                TextField    c1 = new TextField(((f != null)
                                                 ? viewerOption.convertCanonicalToRelative(f).getPath()
                                                 : ""), width);
                BrowseButton c2 = new BrowseButton(((type.compareTo("file") == 0)
                                                    ? BrowseButton.FILE
                                                    : BrowseButton.DIRECTORY), c1);
                c1.addTextListener (new ComponentListener(viewerOption, setter, option, optionType));
                c1.addFocusListener(textSelector);
                c2.setPathAbsoluter(viewerOption);
                component = new AlignPanel(new Label(title), 0, c1, (width > 0 ? 0.5 : 1), c2, 0);
                return;
            }

            // ܡѥͥ
            if (type.compareTo("panel") == 0) {
                String subtype = getResource(key + ".subtype").toLowerCase();
                BorderContainer c = null;

                // ѥͥΥ٥
                if (subtype.compareTo("label") == 0) {
                    c = new BorderContainer(title);
                } else
                if (subtype.compareTo("check") == 0) {
                    Checkbox check = new Checkbox(title, viewerOption.getPropertyBoolean(option, false));
                    check.addItemListener(new ComponentListener(viewerOption, setter, option, optionType));
                    c = new BorderContainer(check);
                } else {
                    throw new IllegalArgumentException("invalid subtype " + subtype);
                }

                // ѥͥΥ쥤ȥޥ͡
                GridBagLayout gbl = new GridBagLayout();
                c.setLayout(gbl);

                // ѥͥ˥ƥɲ
                String itemList = getResource(key + ".items");
                if (itemList != null) {
                    st = new StringTokenizer(itemList, ",");
                    while (st.hasMoreTokens()) {
                        String subKey = st.nextToken().trim();
                        try {
                            (new Item(subKey)).attach(c, gbl);
                        } catch (Exception e) {
                            //### ERROR
Debug.out.println(subKey + ":" + e);
e.printStackTrace(Debug.out);
                        }
                    }
                }

                component = c;
                return;
            }

            // 饹
            if (type.compareTo("class") == 0) {
                String subtype = getResource(key + ".subtype");
                optionComponent = (OptionComponent) Class.forName(subtype).newInstance();
                optionComponent.initialize(viewerOption, setter, option);
                component = optionComponent.getComponent();
                return;
            }

            throw new IllegalArgumentException("invalid type " + type);
        }

        /** å */
        private void attach(Container container, GridBagLayout gbl) {
            Insets insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
            int w = GridBagConstraints.NONE;
            if (layoutWeightX > 0 && layoutWeightY > 0) {
                w = GridBagConstraints.BOTH;
            } else if (layoutWeightX > 0) {
                w = GridBagConstraints.HORIZONTAL;
            } else if (layoutWeightY > 0) {
                w = GridBagConstraints.VERTICAL;
            }

            LayoutUtils.addGridBag(container, component, gbl, layoutX, layoutY, layoutWidth, layoutHeight, layoutWeightX, layoutWeightY, w, GridBagConstraints.WEST, insets);
            if (tips != null && toolTip != null) {
                toolTip.attachComponent(component, tips);
            }
        }

        /**  */
        private void reload() {
            //### TODO
        }

        /** ꥻå */
        private void reset() {
            //### TODO
        }

        /** ꥽ */
        private void dispose() {
            if (tips != null && toolTip != null) {
                toolTip.detachComponent(component);
            }

            if (optionComponent != null) {
                optionComponent.dispose();
            }
        }
    }
}
