/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;

import java.awt.Button;
import java.awt.Font;
import java.awt.Frame;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ץꤹ뤿ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class OptionDialog extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.option.Resources";
    private static final int    MARGIN   = 3;

    /**  ܥ */
    public static final int RESULT_OPEN = RESULT_OK;

    /** @serial ӥ塼ץ */
    private ViewerOption option;
    /** @serial å */
    private Setter       setter;

    /** @serial ƥ */
    private Tree       tree;
    /** @serial ȥ */
    private FancyLabel title;
    /** @serial ᥤѥͥ */
    private Panel      main;
    /** @serial ᥤѥͥ쥤ȥޥ͡ */
    private CardLayout mainLayout;
    /** @serial ɥܥ */
    private Button     reload;
    /** @serial ꥻåȥܥ */
    private Button     reset;
    /** @serial ѥͥѥ */
    private Vector     rootPages = new Vector();
    /** @serial ڡ */
    private Vector     pages = new Vector();

    /**
     * ץܥåɽη̤֤ޤ
     *
     * @param  owner ʡ
     * @param  option ץ
     *
     * @return OK 򲡤줿 <code>true</code>
     *         ʳξ <code>false</code>
     */
    public static boolean show(Frame owner, ViewerOption option) {
        OptionDialog dialog = new OptionDialog(owner, option);

        dialog.show();

        return (dialog.getResult() == RESULT_OK);
    }

    /**
     *  Web ڡ򳫤ܥåޤ
     *
     * @param  owner ʡ
     * @param  option ץ
     */
    public OptionDialog(final Frame owner, ViewerOption option) {
        super(owner, BUTTON_OKCANCEL | ALIGN_RIGHT);
        setTitle    (getMessage("title"));
        setResizable(true);
        setModal    (true);

        this.option = option;
        this.setter = option.getSetter();

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, 0, MARGIN, MARGIN);
        mainPanel.setLayout(gbl);

        tree = new Tree(10, 20) {
            /** Ǿͤ侩ͤˤ */
            public Dimension getMinimumSize() {
                return getPreferredSize();
            }
        };

        Panel buttons = new Panel(new FlowLayout(FlowLayout.LEFT, MARGIN, 0));
        addToPanel(tree                                                  , gbl, 0, 0, 1, 3, 0, 1, GridBagConstraints.VERTICAL  , GridBagConstraints.WEST     , insets);
        insets.right = 0;
        addToPanel(title  = new FancyLabel(""                           ), gbl, 1, 0, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, insets);
        addToPanel(main   = new Panel     (mainLayout = new CardLayout()), gbl, 1, 1, 1, 1, 1, 1, GridBagConstraints.BOTH      , GridBagConstraints.NORTHWEST, insets);
//        addToPanel(buttons                                               , gbl, 1, 2, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST     , insets);
        buttons.add(reload = new Button(getMessage("label.reload")));
        buttons.add(reset  = new Button(getMessage("label.reset" )));

        Font font = getFont();
        title.setFont(new Font(font.getName(),
                               Font.BOLD,
                               Integer.parseInt(getMessage("title.fontsize"))));

        // ץڡ
        String pageList = getMessage("pages");
        StringTokenizer st = new StringTokenizer(pageList, ",");
        OptionPage page, op;
        Vector     v;
        while (st.hasMoreTokens()) {
            page = new OptionPage(option, "net.hizlab.kagetaka.viewer.option.pages." + st.nextToken().trim(), setter);
            pages.addElement(page);
            page.attachContainer(main);

            v = rootPages;
            // 
            CHECK:
            for (int i = 0; i < page.optionPaths.length - 1; i++) {
                for (int j = 0; j < v.size(); j++) {
                    op = (OptionPage) v.elementAt(j);
                    if (op.optionPaths[i].compareTo(page.optionPaths[i]) == 0) {
                        v = op.child;
                        continue CHECK;
                    }
                }
                break;
            }
            int last = page.optionPaths.length - 1;
            REGIST:
            {
                for (int j = 0; j < v.size(); j++) {
                    if (((OptionPage) v.elementAt(j)).optionPaths[last].compareTo(page.optionPaths[last]) == 0) {
                        break REGIST;
                    }
                }
                v.addElement(page);
            }
        }

        // ꥹʤϿ
        tree.addItemListener(
            new ItemListener() {
                /** 򤵤줿 */
                public void itemStateChanged(ItemEvent e) {
                    OptionPage page = (OptionPage) tree.getSelectedTreeItem();
                    if (page == null) {
                        return;
                    }

                    title.setText(page.optionTitle);
                    mainLayout.show(main, page.optionPath);
                }
            }
        );
        reload.addActionListener(
            new ActionListener() {
                /** ȯ */
                public void actionPerformed(ActionEvent e) {
                    for (int i = pages.size() - 1; i >= 0; i--) {
                        ((OptionPage) pages.elementAt(i)).reload();
                    }
                }
            }
        );
        reset.addActionListener(
            new ActionListener() {
                /** ȯ */
                public void actionPerformed(ActionEvent e) {
                    for (int i = pages.size() - 1; i >= 0; i--) {
                        ((OptionPage) pages.elementAt(i)).reset();
                    }
                }
            }
        );

        tree.setRootTreeItem(new Item());
        tree.setBackground(SystemColor.window);
        tree.selecteIndex(0);

        // ܥ̾ѹ
        setButtonLabel(0, getMessage("label.ok"    ));
        setButtonLabel(1, getMessage("label.cancel"));

        // 礭
        pack(600, 0);
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "optiondialog." + key, null);
    }

    /** {@inheritDoc} */
    protected boolean dialogClosing(int result) {
        if (result == RESULT_OK) {
            setter.commit();
            option.save  ();
        } else {
            setter.rollback();
        }

        return true;
    }

    /**
     * ꥽ޤ
     */
    public void dispose() {
        for (int i = pages.size() - 1; i >= 0; i--) {
            ((OptionPage) pages.elementAt(i)).dispose();
        }

        super.dispose();
    }

//### Item
    /** ֥åޡƥ */
    private final class Item implements TreeItem {
        /** 󥹥󥹤 */
        private Item() {
        }

        /** ĥ꡼ɽ륢֤ */
        public Image getTreeIcon(boolean opened) {
            return null;
        }

        /** ĥ꡼ɽ٥֤ */
        public String getTreeLabel() {
            return "root";
        }

        /** ҤΥƥ֤ */
        public Vector getTreeItems() {
            return rootPages;
        }
    }
}
