/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageLabel;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.SizedLabel;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.viewer.theme.Theme;
import net.hizlab.kagetaka.viewer.theme.ThemeManager;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 * ץڡɲäơޤΥݡͥȤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class OptionComponentTheme extends Container implements OptionComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.option.Resources";
    private static final int    MARGIN   = 3;
    private static final int    MINIMUM  = 130;

    private Theme[]    themes;
    private String     tips;
    private String     authorHeader;

    private Label      label;
    private List       list;
    private ImageLabel view;
    private Label      name;
    private Label      version;
    private Label      date;
    private Label      author;
    private SizedLabel memo;

    private ViewerOption option;
    private Setter       setter;
    private String       key;
    private ToolTip      toolTip;

    private Theme        selectedTheme;

    /**
     * 󥹥󥹤ޤ
     */
    OptionComponentTheme() {
        GridBagLayout gbl = new GridBagLayout();
        setLayout(gbl);

        Insets insets = new Insets(0, 0, MARGIN, 0);
        LayoutUtils.addGridBag(this, label   = new Label( ), gbl, 0, 0, 3, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, list    = new List (5), gbl, 0, 1, 3, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, view    = new View ( ), gbl, 0, 2, 3, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, name    = new Label( ), gbl, 0, 3, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, version = new Label( ), gbl, 1, 3, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, date    = new Label( ), gbl, 2, 3, 1, 1, 1, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, author  = new Label( ), gbl, 0, 4, 3, 1, 1, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        insets.bottom = 0;
        LayoutUtils.addGridBag(this, memo    = new SizedLabel( ), gbl, 0, 5, 3, 1, 1, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);

        // ꥹʤϿ
        list.addItemListener(
            new ItemListener() {
                /** ȯ */
                public void itemStateChanged(ItemEvent e) {
                    int index = list.getSelectedIndex();
                    if (index == -1 || index >= themes.length) {
                        return;
                    }

                    select(themes[index]);

                    try {
                        setter.putPropertyString(key, themes[index].getKey());
                    } catch (InvalidValueException ex) {
                        //### ERROR
Debug.out.println(e);
                    }
                }
            }
        );

        label.setText(getMessage("key"));
        tips         = getMessage("key.tips");
        authorHeader = getMessage("key.author");
    }

    /** {@inheritDoc} */
    public void initialize(ViewerOption option, Setter setter, String key) {
        this.option  = option;
        this.setter  = setter;
        this.key     = key;
        this.toolTip = option.getToolTip();

        ThemeManager tm = option.getThemeManager();
        themes = tm.getThemes();
        Theme nowTheme = tm.getTheme();
        for (int i = 0; i < themes.length; i++) {
            Theme theme = themes[i];
            list.add(theme.getString(Theme.THEME_NAME) + "   ("
                   + theme.getString(Theme.THEME_VERSION) + ")");
            if (theme == nowTheme) {
                list.select(i);
                select(theme);
            }
        }

        if (tips != null && toolTip != null) {
            toolTip.attachComponent(label, tips);
            toolTip.attachComponent(list , tips);
        }
    }

    /** {@inheritDoc} */
    public Component getComponent() {
        return this;
    }

    /** {@inheritDoc} */
    public void reload() {
        //### TODO
    }

    /** {@inheritDoc} */
    public void reset() {
        //### TODO
    }

    /** {@inheritDoc} */
    public void dispose() {
        if (tips != null && toolTip != null) {
            toolTip.detachComponent(label);
            toolTip.detachComponent(list );
        }
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        return Resource.getMessage(RESOURCE, "page.view.theme." + key, null);
    }

    /** ꤷǥå */
    private synchronized void select(Theme theme) {
        if (theme == selectedTheme) {
            return;
        }

        name   .setText (theme.getString(Theme.THEME_NAME   ));
        version.setText (theme.getString(Theme.THEME_VERSION));
        date   .setText (theme.getString(Theme.THEME_DATE   ));
        author .setText (theme.getString(Theme.THEME_AUTHOR ));
        memo   .setText (theme.getString(Theme.THEME_MEMO   ));
        view   .setImage(theme.getImage (Theme.THEME_SAMPLE, getToolkit()));

        selectedTheme = theme;
    }

    /**
     * ݡͥȤƥʤɲä줿ȤΤޤ
     */
    public void addNotify() {
        synchronized (getTreeLock()) {
            super.addNotify();

            Font font = getParent().getFont();
            name.setFont(new Font(font.getName(), Font.BOLD, font.getSize()));
        }
    }

//### View
    /** ӥ塼 */
    private final class View extends ImageLabel {
        /** 󥹥󥹤 */
        private View() {
        }

        /** Ŭʥ֤ */
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (size.height < MINIMUM) {
                size.height = MINIMUM;
            }

            return size;
        }
    }
}
