/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.BrowseButton;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.awt.ToolTip;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

/**
 * ץڡɲä륢ץꥱΥݡͥȤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class OptionComponentApplication extends Container implements OptionComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.option.Resources";
    private static final int    MARGIN   = 3;

    private static final String COMMAND_UP     = "up";
    private static final String COMMAND_DOWN   = "down";
    private static final String COMMAND_ADD    = "add";
    private static final String COMMAND_EDIT   = "edit";
    private static final String COMMAND_DELETE = "delete";

    private ViewerOption.Application[] apps;

    private List       list;
    private Button     up;
    private Button     down;
    private Button     add;
    private Button     edit;
    private Button     delete;
    private Label      name;
    private Label      path;

    private ViewerOption option;
    private Setter       setter;
    private String       key;
    private ToolTip      toolTip;

    private ViewerOption.Application selectedApp;

    /**
     * 󥹥󥹤ޤ
     */
    OptionComponentApplication() {
        GridBagLayout gbl = new GridBagLayout();
        setLayout(gbl);

        Insets insets = new Insets(0, 0, MARGIN, MARGIN);
        LayoutUtils.addGridBag(this, list    = new List  (5                                           ), gbl, 0, 1, 4, 3, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.right = 0;
        LayoutUtils.addGridBag(this, up      = new Button(getMessage("button.up"    )), gbl, 4, 1, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, down    = new Button(getMessage("button.down"  )), gbl, 4, 2, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        insets.right = MARGIN;
        LayoutUtils.addGridBag(this, add     = new Button(getMessage("button.add"   )), gbl, 0, 4, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, edit    = new Button(getMessage("button.edit"  )), gbl, 1, 4, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        LayoutUtils.addGridBag(this, delete  = new Button(getMessage("button.delete")), gbl, 2, 4, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        insets.right = 0;
        LayoutUtils.addGridBag(this, name    = new Label (                                            ), gbl, 0, 5, 5, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.bottom = 0;
        LayoutUtils.addGridBag(this, path    = new Label (                                            ), gbl, 0, 6, 5, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);

        up    .setActionCommand(COMMAND_UP    );
        down  .setActionCommand(COMMAND_DOWN  );
        add   .setActionCommand(COMMAND_ADD   );
        edit  .setActionCommand(COMMAND_EDIT  );
        delete.setActionCommand(COMMAND_DELETE);

        // ꥹʤϿ
        list.addItemListener(
            new ItemListener() {
                /** ȯ */
                public void itemStateChanged(ItemEvent e) {
                    int index = list.getSelectedIndex();
                    if (index == -1 || index >= apps.length) {
                        up  .setEnabled(false);
                        down.setEnabled(false);
                        return;
                    }

                    select(index, false, false);
                }
            }
        );
        ActionListener al = new ActionListener() {
            /** ȯ */
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();

                // ɲ
                if (command.compareTo(COMMAND_ADD) == 0) {
                    showDetail(-1);
                    return;
                }

                int index = list.getSelectedIndex();
                if (index == -1 || index >= apps.length) {
                    return;
                }

                // 
                if (command.compareTo(COMMAND_UP) == 0) {
                    if (index < 1) {
                        return;
                    }
                    ViewerOption.Application app = apps[index];
                    apps[index] = apps[index - 1];
                    apps[index - 1] = app;
                    list.replaceItem(apps[index].getName(), index    );
                    list.replaceItem(app        .getName(), index - 1);
                    select(index - 1, true, true);

                    // ¸
                    try {
                        putAppsList();
                    } catch (InvalidValueException ex) {
                        //### ERROR
Debug.out.println(ex);
                    }
                } else

                // 
                if (command.compareTo(COMMAND_DOWN) == 0) {
                    if (index >= list.getItemCount() - 1) {
                        return;
                    }
                    ViewerOption.Application app = apps[index];
                    apps[index] = apps[index + 1];
                    apps[index + 1] = app;
                    list.replaceItem(apps[index].getName(), index    );
                    list.replaceItem(app        .getName(), index + 1);
                    select(index + 1, true, true);

                    // ¸
                    try {
                        putAppsList();
                    } catch (InvalidValueException ex) {
                        //### ERROR
Debug.out.println(ex);
                    }
                } else

                // Խ
                if (command.compareTo(COMMAND_EDIT) == 0) {
                    showDetail(index);
                } else

                // 
                if (command.compareTo(COMMAND_DELETE) == 0) {
                    ViewerOption.Application app = apps[index];
                    String id = app.getId();

                    ViewerOption.Application[] newApps = new ViewerOption.Application[apps.length - 1];
                    if (index > 0) {
                        System.arraycopy(apps, 0, newApps, 0, index);
                    }
                    if (index < list.getItemCount() - 1) {
                        System.arraycopy(apps, index + 1, newApps, index, apps.length - index - 1);
                    }
                    apps = newApps;

                    list.delItem(index);

                    try {
                        putAppsList();
                        setter.putPropertyString (ViewerOption.KEY_APP_NAME  [0] + id + ViewerOption.KEY_APP_NAME  [1], null);
                        setter.putPropertyFile   (ViewerOption.KEY_APP_PATH  [0] + id + ViewerOption.KEY_APP_PATH  [1], null);
                        setter.putPropertyString (ViewerOption.KEY_APP_OPTION[0] + id + ViewerOption.KEY_APP_OPTION[1], null);
                        setter.putPropertyBoolean(ViewerOption.KEY_APP_ONLINE[0] + id + ViewerOption.KEY_APP_ONLINE[1], null);
                    } catch (InvalidValueException ex) {
                        //### ERROR
Debug.out.println(ex);
                    }

                    if (apps.length > 0) {
                        if (--index < 0) {
                            index = 0;
                        }
                        select(index, true, true);
                    } else {
                        up    .setEnabled(false);
                        down  .setEnabled(false);
                        edit  .setEnabled(false);
                        delete.setEnabled(false);
                        name.setText("");
                        path.setText("");
                    }
                }
            }
        };
        up    .addActionListener(al);
        down  .addActionListener(al);
        add   .addActionListener(al);
        edit  .addActionListener(al);
        delete.addActionListener(al);

        up    .setEnabled(false);
        down  .setEnabled(false);
        edit  .setEnabled(false);
        delete.setEnabled(false);
    }

    /** {@inheritDoc} */
    public void initialize(ViewerOption option, Setter setter, String key) {
        this.option  = option;
        this.setter  = setter;
        this.key     = key;
        this.toolTip = option.getToolTip();

        apps = option.getApplications();
        for (int i = 0; i < apps.length; i++) {
            list.addItem(apps[i].getName());
        }
    }

    /** {@inheritDoc} */
    public Component getComponent() {
        return this;
    }

    /** {@inheritDoc} */
    public void reload() {
        //### TODO
    }

    /** {@inheritDoc} */
    public void reset() {
        //### TODO
    }

    /** {@inheritDoc} */
    public void dispose() {
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        return Resource.getMessage(RESOURCE, "page.application." + key, null);
    }

    /** ꤷǥå */
    private synchronized void select(int index, boolean force, boolean move) {
        if (move) {
            list.select(index);
        }

        ViewerOption.Application app = apps[index];
        if (!force && app == selectedApp) {
            return;
        }

        name.setText(app.getName());
        path.setText(app.getPath().getPath());

        up    .setEnabled((index > 0));
        down  .setEnabled((index < list.getItemCount() - 1));
        edit  .setEnabled(true);
        delete.setEnabled(true);

        selectedApp = app;
    }

    /** ܺ٤ɽ */
    private void showDetail(int index) {
        ViewerOption.Application app = (index >= 0 ? app = apps[index] : null);

        // Frame 򸡽
        Frame owner = LayoutUtils.getFrame(this);
        if (owner == null) {
            return;
        }

        Detail dialog = new Detail(owner, app);
        dialog.show();

        if (dialog.getResult() != DialogBox.RESULT_OK) {
            return;
        }

        try {
            String  id     = dialog.id;
            String  name   = dialog.name  .getText ();
            File    path   = option.convertRelativeToCanonical(new File(dialog.path.getText()));
            String  option = dialog.option.getText ();
            boolean online = dialog.online.getState();
            app = new ViewerOption.Application(id, name, path, option, online);

            if (index >= 0) {
                list.replaceItem(app.getName(), index);
            } else {
                if ((index = list.getSelectedIndex() + 1) == 0) {
                    index = list.getItemCount();
                }

                ViewerOption.Application[] newApps = new ViewerOption.Application[apps.length + 1];
                if (index > 0) {
                    System.arraycopy(apps, 0, newApps, 0, index);
                }
                if (index < list.getItemCount()) {
                    System.arraycopy(apps, index, newApps, index + 1, apps.length - index);
                }
                apps = newApps;

                list.addItem(app.getName(), index);
            }
            apps[index] = app;


            putAppsList();
            setter.putPropertyString (ViewerOption.KEY_APP_NAME  [0] + id + ViewerOption.KEY_APP_NAME  [1], name  );
            setter.putPropertyFile   (ViewerOption.KEY_APP_PATH  [0] + id + ViewerOption.KEY_APP_PATH  [1], path  );
            setter.putPropertyString (ViewerOption.KEY_APP_OPTION[0] + id + ViewerOption.KEY_APP_OPTION[1], option);
            setter.putPropertyBoolean(ViewerOption.KEY_APP_ONLINE[0] + id + ViewerOption.KEY_APP_ONLINE[1], online);

            select(index, true, true);
        } catch (InvalidValueException e) {
            //### ERROR
Debug.out.println(e);
        }
    }

    /** ץꥱꥹȤ */
    private void putAppsList()
            throws InvalidValueException {
        String[] lists = new String[apps.length];
        for (int i = 0; i < lists.length; i++) {
            lists[i] = apps[i].getId();
        }
        setter.putPropertyStrings(ViewerOption.KEY_APP_LIST, lists);
    }

//### Detail
    /** ܺٲ */
    private final class Detail extends DialogBox {
        /** @serial ʡ */
        private Frame        owner;
        /** @serial ID */
        private String       id;
        /** @serial ̾٥ */
        private Label        namel;
        /** @serial ̾ */
        private TextField    name;
        /** @serial ѥ٥ */
        private Label        pathl;
        /** @serial ѥ */
        private TextField    path;
        /** @serial ѥȥܥ */
        private BrowseButton pathb;
        /** @serial ץ٥ */
        private Label        optionl;
        /** @serial ץ */
        private TextField    option;
        /** @serial 饤 */
        private Checkbox     online;

        /**
         * ֥åޡξܺ٥ܥåޤ
         *
         * @param  owner ʡ
         * @param  app   ץꥱ
         */
        private Detail(Frame owner, ViewerOption.Application app) {
            super(owner, BUTTON_OKCANCEL);
            setResizable(false);
            setModal    (true );
            this.owner = owner;
            setTitle(getMessage((app != null ? "detail.edit" : "detail.new")));

            if (app != null) {
                this.id = app.getId();
            }

            // ᥤѥͥ
            GridBagLayout gbl    = new GridBagLayout();
            Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
            mainPanel.setLayout(gbl);

            if (app != null) {
                id = app.getId();
            }

            addToPanel(namel   = new Label       (getMessage("name"                            )), gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
            addToPanel(name    = new TextField   ((app != null ? app.getName          () : ""  )), gbl, 1, 0, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
            addToPanel(pathl   = new Label       (getMessage("path"                            )), gbl, 0, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
            addToPanel(path    = new TextField   ((app != null ? app.getPath().getPath() : ""  ),
                                                  30                                            ), gbl, 1, 1, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
            addToPanel(pathb   = new BrowseButton(BrowseButton.FILE, path                       ), gbl, 2, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
            addToPanel(optionl = new Label       (getMessage("option"                          )), gbl, 0, 2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
            addToPanel(option  = new TextField   ((app != null ? app.getOption        () : ""  )), gbl, 1, 2, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
            addToPanel(online  = new Checkbox    (getMessage("online"                          ),
                                                  (app != null ? app.getOnline        () : true)), gbl, 0, 3, 3, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);

            pathb.setPathAbsoluter(OptionComponentApplication.this.option);

            // 礭
            pack();
        }

        /** ɽ */
        public void show() {
            if (toolTip != null) {
                toolTip.attachComponent(namel  , getMessage("name.tips"  ));
                toolTip.attachComponent(name   , getMessage("name.tips"  ));
                toolTip.attachComponent(pathl  , getMessage("path.tips"  ));
                toolTip.attachComponent(path   , getMessage("path.tips"  ));
                toolTip.attachComponent(pathb  , getMessage("path.tips"  ));
                toolTip.attachComponent(optionl, getMessage("option.tips"));
                toolTip.attachComponent(option , getMessage("option.tips"));
                toolTip.attachComponent(online , getMessage("online.tips"));
            }

            super.show();
        }

        /** Ĥ */
        protected boolean dialogClosing(int result) {
            if (result == RESULT_CANCEL) {
                return true;
            }

            if (/*---*/name.getText().length() == 0
                    || path.getText().length() == 0) {
                MessageBox.show(owner,
                                getMessage("novalue.text" ),
                                getMessage("novalue.title"),
                                MessageBox.BUTTON_OK | MessageBox.ICON_EXCLAMATION);
                return false;
            }

            if (id == null) {
                int hash = name.hashCode();

                ID:
                for (int fix = 0; ; fix++) {
                    id = Integer.toHexString(hash + fix);

                    for (int i = 0; i < apps.length; i++) {
                        if (apps[i].getId().compareTo(id) == 0) {
                            continue ID;
                        }
                    }

                    break;
                }
            }

            if (toolTip != null) {
                toolTip.detachComponent(namel  );
                toolTip.detachComponent(name   );
                toolTip.detachComponent(pathl  );
                toolTip.detachComponent(path   );
                toolTip.detachComponent(pathb  );
                toolTip.detachComponent(optionl);
                toolTip.detachComponent(option );
                toolTip.detachComponent(online );
            }

            return true;
        }
    }
}
