/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;

/**
 * ɼʥ٥Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class FancyLabel extends Component {
    private static final int BORDER = 4;

    /** @serial 侩 */
    private Dimension preferredSize;

    /** @serial ʸ */
    private String    label;

    /**
     * ٥ޤ
     *
     * @param  label ٥
     */
    FancyLabel(String label) {
        setText(label);
        setForeground(SystemColor.controlLtHighlight);
        setBackground(SystemColor.controlShadow     );
    }

    /**
     * ٥κԤޤ
     *
     * @param  g Graphics ɥ
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ٥Ԥޤ
     *
     * @param  g Graphics ɥ
     */
    public void paint(Graphics g) {
        Dimension size = getSize();

        // طʿ
        g.setColor(getBackground());
        g.fillRect(0, 0, size.width, size.height);

        // Ȥ
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(1, 1, 1, size.height - 2);
        g.drawLine(1, 1, size.width  - 2, 1);
        g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
        g.drawLine(size.width  - 2, 2, size.width - 2, size.height - 2);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        g.drawLine(size.width  - 1, 1, size.width - 1, size.height - 1);

        // ٥
        FontMetrics fm = getFontMetrics(getFont());
        int height = fm.getHeight();
        String label = this.label;

        g.setFont (getFont      ());
        g.setColor(getForeground());
        g.drawString(label, BORDER + 2, (size.height - height) / 2 + height - fm.getDescent());
    }

    /**
     * ٥ɽʸꤷޤ
     *
     * @param  label ٥
     */
    void setText(String label) {
        this.label = label;
        invalidate();

        if (isShowing()) {
            repaint();
        }
    }

    /**
     * ٥ɽʸ֤ޤ
     *
     * @return ٥
     */
    String getText() {
        return label;
    }

    /**
     * Ǿ֤ޤ
     *
     * @return Ǿ
     */
    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    /**
     * 侩֤ޤ
     *
     * @return 侩
     */
    public Dimension getPreferredSize() {
        Dimension preferredSize = this.preferredSize;
        if (preferredSize != null && isValid()) {
            return preferredSize;
        }

        synchronized (getTreeLock()) {
            FontMetrics fm = getFontMetrics(getFont());
            this.preferredSize = new Dimension(fm.stringWidth(label) + BORDER,
                                               fm.getHeight() + BORDER);
            return this.preferredSize;
        }
    }

    /**
     * եȤꤷޤ
     *
     * @param  font ե
     */
    public void setFont(Font font) {
        Font oldFont = getFont();
        if (oldFont != font) {
            super.setFont(font);

            invalidate();
            repaint();
        }
    }
}
