/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.io.EolInputStream;
import net.hizlab.kagetaka.io.PathAbsoluter;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ĥץѥƥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class ExProperties extends Properties implements PathAbsoluter {
    private static final char[] HEX_DIGIT = {
        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
    };

    /** @serial ץѥƥե */
    private File   propertiesFile;
    /** @serial ץѥƥοƥǥ쥯ȥ */
    private String propertiesParent;

    /**
     * Υץѥƥޤ
     */
    public ExProperties() {
    }

    /**
     * ե뤫ɤ߹ߡͤȤץѥƥޤ
     *
     * @param  file ɤ߹ե
     *
     * @throws IOException I/O顼ȯ
     */
    public ExProperties(File file)
            throws IOException {
        this(null, file);
    }

    /**
     * ꤵ줿ǥեͤե뤫ɤ߹ͤݻ
     * ץѥƥޤ
     *
     * @param  parent ǥե
     * @param  file   ɤ߹ե
     *
     * @throws IOException I/O顼ȯ
     */
    public ExProperties(ExProperties parent, File file)
            throws IOException {
        this(parent, file, false);
    }

    /**
     * ꤵ줿ǥեͤե뤫ɤ߹ͤݻ
     * ץѥƥޤ
     *
     * @param  parent ǥե
     * @param  file   ɤ߹ե
     * @param  force  ɤ߹ե뤬̵Ƥ⥨顼Ȥʤ <code>true</code>
     *                ʳξ <code>false</code>
     *
     * @throws IOException I/O顼ȯ
     */
    public ExProperties(ExProperties parent, File file, boolean force)
            throws IOException {
        super(parent);

        propertiesFile = file;
        if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
            try {
                propertiesParent = (new File(propertiesFile.getCanonicalPath())).getParent();
            } catch (IOException e) { }

            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(propertiesFile));
                load(is);
            } catch (FileNotFoundException e) {
                if (!force) {
                    throw e;
                }
            } finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    /**
     * ɤ߹ե˥ץѥƥ񤭽Фޤ
     *
     * @param  keylist ץѥƥΥꥹ
     *
     * @throws IOException I/O顼ȯ
     */
    public synchronized void save(Vector keylist)
            throws IOException {
        if (propertiesFile == null) {
            throw new IOException("file is null");
        }

        if (!ViewerOption.ensureDirectory(propertiesFile.getParent())) {
            throw new IOException("Can not create parent dir for " + propertiesFile);
        }

        Writer w   = null;
        String eol = null;
        String key, value;
        boolean needEol = false;

        try { // w 򥯥뤿Υȥå
            if (propertiesFile.exists()) {
                if (!propertiesFile.canWrite()) {
                    return;
                }

                // ߤե͡
                File backup = new File(propertiesFile.getCanonicalPath() + ".bak");
                backup.delete();
                propertiesFile.renameTo(backup);

                EolInputStream eis = new EolInputStream(new FileInputStream(backup));
                InputStream    is  = new BufferedInputStream(eis);
                w = new OutputStreamWriter(
                      new BufferedOutputStream(
                        new FileOutputStream(propertiesFile)));

                keylist = (Vector) keylist.clone();
                int    index;
                StringBuffer sb = new StringBuffer();

                int c = is.read();

                try { // is 򥯥뤿Υȥå
                    READ:
                    while (c >= 0) {
                        // ȹԡӹƬζɤФ
                        switch (c) {
                        case '#':
                        case '!':
                            do {
                                w.write(c);
                                if ((c = is.read()) == -1) {
                                    needEol = true;
                                    break READ;
                                }
                            } while (c != '\n' && c != '\r');
                            continue;
                        case '\r':
                        case '\n':
                            w.write(c);
                            c = is.read();
                            continue;
                        case '\t':
                        case ' ' :
                            w.write(c);
                            if ((c = is.read()) == -1) {
                                needEol = true;
                                break READ;
                            }
                            continue;
                        default: // AVOID
                        }

                        // ɤ߹
                        sb.setLength(0);
                        while (/**/c >= 0 && c != '=' && c != ':'
                                && c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                            sb.append((char) c);
                            w.write(c);
                            c = is.read();
                        }

                        // = ΥڡɤФ
                        while (c == ' ' || c == '\t') {
                            w.write(c);
                            c = is.read();
                        }

                        if (c == '=' || c == ':' || c == -1) {
                            if (c == -1) {
                                w.write('=');
                            } else {
                                w.write(c);
                                c = is.read();

                                // = ΥڡɤФ
                                while (c == ' ' || c == '\t') {
                                    w.write(c);
                                    c = is.read();
                                }
                            }

                            // ͤɤ߹
                            key   = sb.toString();
                            value = (String) get(key);

                            // ͤꤵƤ
                            if (value != null) {
                                if ((index = keylist.indexOf(key)) != -1) {
                                    keylist.setElementAt(null, index);
                                }
                                encode(w, value);

                                // ޤɤФ
                                while (c != '\n' && c != '\r') {
                                    if (c == -1) {
                                        needEol = true;
                                        break READ;
                                    }
                                    c = is.read();
                                }
                                continue;
                            }
                        }

                        // ʹԤ䡢ͤꤵƤʤ
                        while (c != '\n' && c != '\r') {
                            if (c == -1) {
                                needEol = true;
                                break READ;
                            }
                            w.write(c);
                            c = is.read();
                        }
                    }
                } finally {
                    is.close();
                    eol = eis.getEol();
                }
            } else {
                w = new OutputStreamWriter(
                      new BufferedOutputStream(
                        new FileOutputStream(propertiesFile)));
            }

            // ԥɤ
            if (eol == null) {
                eol = "\n";
            }
            if (needEol) {
                w.write(eol);
            }

            // ĤΥץѥƥ񤭽Ф
            int size = keylist.size();
            for (int i = 0; i < size; i++) {
                if (/*---*/(key   = (String) keylist.elementAt(i)) != null
                        && (value = (String) get(key))             != null) {
                    w.write(key);
                    w.write('=');
                    encode(w, value);
                    w.write(eol);
                }
            }
        } finally {
            if (w != null) {
                w.flush();
                w.close();
            }
        }
    }

    /** ץѥƥ󥳡ǥ󥰤Ԥ */
    private String encode(Writer w, String value)
            throws IOException {
        int c, length = value.length();
        boolean empty = false;

        for (int i = 0; i < length; i++) {
            c = value.charAt(i);

            switch (c) {
            case '\\': w.write('\\'); w.write('\\'); break;
            case '\t': w.write('\\'); w.write('t' ); break;
            case '\n': w.write('\\'); w.write('n' ); break;
            case '\r': w.write('\\'); w.write('r' ); break;
            default:
                if (c < 0x20 || 0x7f < c || (empty && (c == ' '))) {
                    w.write('\\');
                    w.write('u');
                    w.write(HEX_DIGIT[((c >> 12) & 0xF)]);
                    w.write(HEX_DIGIT[((c >>  8) & 0xF)]);
                    w.write(HEX_DIGIT[((c >>  4) & 0xF)]);
                    w.write(HEX_DIGIT[((c >>  0) & 0xF)]);
                } else {
                    w.write(c);
                }
            }

            empty = false;
        }

        return value;
    }

//### Converter ʸ => 饹
    /**
     * ꤵ줿ĥץѥƥ{@link Boolean} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Boolean getPropertyBoolean(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        return Boolean.valueOf(value);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Integer} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Integer getPropertyInteger(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        return Integer.valueOf(value);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Double} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Double getPropertyDouble(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        return Double.valueOf(value);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public String getPropertyString(String key) {
        return getProperty(key);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public String[] getPropertyStrings(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        StringTokenizer st = new StringTokenizer(value, ",");
        String[] values = new String[st.countTokens()];
        int      index  = 0;
        while (st.hasMoreTokens()) {
            values[index++] = st.nextToken().trim();
        }

        return values;
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Dimension} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Dimension getPropertyDimension(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        int p = value.indexOf(',');
        if (p == -1) {
            return null;
        }

        try {
            return new Dimension(
                Integer.parseInt(value.substring(0, p )),
                Integer.parseInt(value.substring(p + 1))
            );
        } catch (NumberFormatException e) { }
        return null;
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Font} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Font getPropertyFont(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        String token1 = null;
        String token2 = null;
        int p;
        if ((p = value.lastIndexOf('-')) != -1) {
            token1 = value.substring(p + 1).toLowerCase();
            value  = value.substring(0, p);
            if ((p = value.lastIndexOf('-')) != -1) {
                token2 = token1;
                token1 = value.substring(p + 1).toLowerCase();
                value  = value.substring(0, p);
            }
        }
        int style = Font.PLAIN;
        int size  = 12;
        if (token1 != null) {
            if (token1.indexOf("bolditalic") != -1) {
                style = Font.BOLD | Font.ITALIC;
            } else if (token1.indexOf("bold") != -1) {
                style = Font.BOLD;
            } else if (token1.indexOf("italic") != -1) {
                style = Font.ITALIC;
            }
        }
        if (token2 != null) {
            try {
                size = Integer.valueOf(token2).intValue();
            } catch (NumberFormatException e) { }
        }

        return new Font(value, style, size);
    }

    /**
     * ꤵ줿ĥץѥƥ{@link Point} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public Point getPropertyPoint(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        int p = value.indexOf(',');
        if (p == -1) {
            return null;
        }

        try {
            return new Point(
                Integer.parseInt(value.substring(0, p )),
                Integer.parseInt(value.substring(p + 1))
            );
        } catch (NumberFormatException e) { }
        return null;
    }

    /**
     * ꤵ줿ĥץѥƥ{@link File} ֤ޤ
     * <p>
     * ХѥꤵƤǡץѥƥե뤫ɤǤϡ
     * ΥץѥƥեΥѥХѥ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public File getPropertyFile(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        if (value == null || value.length() == 0) {
            return null;
        }

        return convertRelativeToCanonical(new File(value));
    }

    /**
     * ꤵ줿ĥץѥƥ{@link CharList} ֤ޤ
     *
     * @param  key ץѥƥ
     *
     * @return ץѥƥ͡
     *         Ĥʤ <code>null</code>
     */
    public CharList getPropertyCharList(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        }

        return new CharList(value, false);
    }

//### Converter 饹 => ʸ
    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Boolean value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value.toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Integer value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value.toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Double value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value.toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, String value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, String[] value) {
        if (value == null) {
            return remove(key);
        }

        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length; i++) {
            sb.append(value[i]);
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }

        return super.put(key, sb.toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Dimension value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value.width + "," + value.height);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Font value) {
        if (value == null) {
            return remove(key);
        }

        String style = "plain";
        int    code  = value.getStyle();

        if ((code & Font.BOLD) != 0 && (code & Font.ITALIC) != 0) {
            style = "bolditalic";
        } else if ((code & Font.BOLD) != 0) {
            style = "bold";
        } else if ((code & Font.ITALIC) != 0) {
            style = "italic";
        }

        return super.put(key, value.getName() + "-" + style + "-" + value.getSize());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Point value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value.x + "," + value.y);
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     * <p>
     * ץѥƥե뤫ɤƤơꤵ줿ե뤬
     * ץѥƥեʲΰ֤֤Ƥϡ
     * Хѥꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, File value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, convertCanonicalToRelative(value).toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, CharList value) {
        if (value == null) {
            return remove(key);
        }

        return super.put(key, value.toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(String key, Object value) {
        if (value == null) {
            return remove(key);
        }

        if (value instanceof Boolean  ) { return put(key, (Boolean  ) value); }
        if (value instanceof Integer  ) { return put(key, (Integer  ) value); }
        if (value instanceof Double   ) { return put(key, (Double   ) value); }
        if (value instanceof String   ) { return put(key, (String   ) value); }
        if (value instanceof String[] ) { return put(key, (String[] ) value); }
        if (value instanceof Dimension) { return put(key, (Dimension) value); }
        if (value instanceof Font     ) { return put(key, (Font     ) value); }
        if (value instanceof Point    ) { return put(key, (Point    ) value); }
        if (value instanceof File     ) { return put(key, (File     ) value); }
        if (value instanceof CharList ) { return put(key, (CharList ) value); }

        return super.put(key, value.toString());
    }

    /**
     * ꤵ줿бץѥƥꤷޤ
     * ץѥƥͤ {@link String} Ѵꤵޤ
     *
     * @param  key   ץѥƥ
     * @param  value ץѥƥ
     *
     * @return ꤵƤץѥƥ͡
     *         ̵ <code>null</code>
     */
    public Object put(Object key, Object value) {
        return (key instanceof String
                ? put((String) key, value)
                : put(key.toString(), value));
    }

//### File Ѵ
    /**
     * եѥХѥѴޤ
     * Хѥδ֤ϡΥץѥƥɤ߹ǥ쥯ȥˤʤޤ
     *
     * @param  path եѥ
     *
     * @return Υץѥƥɤ߹ǥ쥯ȥ겼ξХѥ
     *         ʳξ <code>path</code> 
     */
    public File convertCanonicalToRelative(File path) {
        if (propertiesParent != null && path.isAbsolute()) {
            try {
                String target = path.getCanonicalPath();
                if (target.startsWith(propertiesParent)) {
                    return new File(target.substring(propertiesParent.length() + 1));
                }
            } catch (IOException e) { }
        }

        return path;
    }

    /**
     * ХѥХѥѴޤ
     * Хѥδ֤ϡΥץѥƥɤ߹ǥ쥯ȥˤʤޤ
     *
     * @param  path եѥ
     *
     * @return ХѥξХѥˡ
     *         ʳξ <code>path</code> 
     */
    public File convertRelativeToCanonical(File path) {
        if (propertiesParent != null && !path.isAbsolute()) {
            return new File(propertiesParent, path.toString());
        }

        return path;
    }
}
