/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ץ̤γƥݡͥȤΥꥹʤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class ComponentListener implements ItemListener, TextListener {
    private ViewerOption option;
    private Setter       setter;
    private String       key;
    private int          type;
    private Component    other;
    private Vector       values;

    /**
     * ꥹʤޤ
     *
     * @param  option ץ
     * @param  setter å
     * @param  key    
     * @param  type   ץη
     */
    ComponentListener(ViewerOption option, Setter setter, String key, int type) {
        this.option = option;
        this.setter = setter;
        this.key    = key;
        this.type   = type;
    }

    /**
     * եѤΥꥹʤޤ
     *
     * @param  option ץ
     * @param  setter å
     * @param  key    
     * @param  type   ץη
     * @param  other  ¾Υݡͥ
     */
    ComponentListener(ViewerOption option, Setter setter, String key, int type, Component other) {
        this(option, setter, key, type);
        this.other  = other;
    }

    /**
     * ܥܥåѤΥꥹʤޤ
     *
     * @param  option ץ
     * @param  setter å
     * @param  key    
     * @param  type   ץη
     * @param  values ͥꥹ
     */
    ComponentListener(ViewerOption option, Setter setter, String key, int type, Vector values) {
        this(option, setter, key, type);
        this.values = values;
    }

    /**
     * ֤ѹޤ
     *
     * @param  e ٥
     */
    public void itemStateChanged(ItemEvent e) {
        Component c = (Component) e.getSource();

        try {
            // ܥܥå
            if (values != null) {
                int    index = ((Choice) c).getSelectedIndex();
                String value = (String) values.elementAt(index);
                switch (type) {
                case ViewerOption.TYPE_INT:
                    setter.putPropertyInteger(key, Integer.parseInt(value));
                    return;
                case ViewerOption.TYPE_DOUBLE:
                    setter.putPropertyDouble (key, Double.valueOf(value).doubleValue());
                    return;
                case ViewerOption.TYPE_STRING:
                    setter.putPropertyString (key, value);
                    return;
                default: // AVOID
                }
            }

            // åܥå - checkboxܡѥͥ - panel
            if (c instanceof Checkbox) {
                if (type == ViewerOption.TYPE_BOOLEAN) {
                    setter.putPropertyBoolean(key, new Boolean(e.getStateChange() == ItemEvent.SELECTED));
                    return;
                }
            }

            // ե - font
            if (type == ViewerOption.TYPE_FONT) {
                setter.putPropertyFont(key, new Font(((Choice) c).getSelectedItem(),
                                                     Font.PLAIN,
                                                     getFontSize(((TextField) other).getText())));
                return;
            }
        } catch (InvalidValueException ex) {
            Debug.out.println(e);
        }

        //### ERROR
    }

    /**
     * ƥȤѹޤ
     *
     * @param  e ٥
     */
    public void textValueChanged(TextEvent e) {
        String value = ((TextComponent) e.getSource()).getText();

        try {
            // ƥ - text
            if (type == ViewerOption.TYPE_INT) {
                if (value.length() == 0) {
                    setter.putPropertyInteger(key, null);
                } else {
                    setter.putPropertyInteger(key, Integer.valueOf(value));
                }
                return;
            }
            if (type == ViewerOption.TYPE_DOUBLE) {
                if (value.length() == 0) {
                    setter.putPropertyDouble(key, null);
                } else {
                    setter.putPropertyDouble(key, Double.valueOf(value));
                }
                return;
            }
            if (type == ViewerOption.TYPE_STRING) {
                setter.putPropertyString(key, value);
                return;
            }
            if (type == ViewerOption.TYPE_STRINGS) {
                Vector v = new Vector();
                for (StringTokenizer st = new StringTokenizer(value, ","); st.hasMoreTokens();) {
                    v.addElement(st.nextToken().trim());
                }
                String[] values = new String[v.size()];
                v.copyInto(values);
                setter.putPropertyStrings(key, values);
                return;
            }
            if (type == ViewerOption.TYPE_FILE) {
                setter.putPropertyFile(key, option.convertRelativeToCanonical(new File(value)));
                return;
            }
            if (type == ViewerOption.TYPE_CHARLIST) {
                setter.putPropertyCharList(key, new CharList(value, false));
                return;
            }

            // ե - font
            if (type == ViewerOption.TYPE_FONT) {
                setter.putPropertyFont(key, new Font(((Choice) other).getSelectedItem(), Font.PLAIN, getFontSize(value)));
                return;
            }
        } catch (InvalidValueException ex) {
            Debug.out.println(e);
        }

        //### ERROR
    }

    /** եȥ */
    private int getFontSize(String value) {
        if (value.length() > 0) {
            try {
                return Integer.parseInt(value);
            } catch (NumberFormatException e) { }
        }

        Object o = option.defaultProperties.get(key);
        if (o != null && o instanceof Font) {
            Font font = (Font) o;
            if (font != null) {
                return font.getSize();
            }
        }

        return 14;                              // ǥեȥ
    }
}
