/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.option;

import net.hizlab.kagetaka.awt.LayoutUtils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;

/**
 * İʾΥݡͥȤ¤٤ѥͥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class AlignPanel extends Panel {
    private static final int SPACE = 3;

    private GridBagLayout gbl;
    private Insets        insets;
    private int           count;

    /**
     * ѥͥޤ
     *
     * @param  c ݡͥ
     * @param  weightx ݡͥȤ {@link GridBagConstraints#weightx}
     */
    AlignPanel(Component c, double weightx) {
        setLayout(gbl = new GridBagLayout());
        insets = new Insets(0, 0, 0, 0);

        add(c, weightx);
        insets.left = SPACE;
    }

    /**
     * ѥͥޤ
     *
     * @param  c1 ܤΥݡͥ
     * @param  weightx1 ܤΥݡͥȤ {@link GridBagConstraints#weightx}
     * @param  c2 ܤΥݡͥ
     * @param  weightx2 ܤΥݡͥȤ {@link GridBagConstraints#weightx}
     */
    AlignPanel(Component c1, double weightx1,
               Component c2, double weightx2) {
        this(c1, weightx1);
        add (c2, weightx2);
    }

    /**
     * ѥͥޤ
     *
     * @param  c1 ܤΥݡͥ
     * @param  weightx1 ܤΥݡͥȤ {@link GridBagConstraints#weightx}
     * @param  c2 ܤΥݡͥ
     * @param  weightx2 ܤΥݡͥȤ {@link GridBagConstraints#weightx}
     * @param  c3 ܤΥݡͥ
     * @param  weightx3 ܤΥݡͥȤ {@link GridBagConstraints#weightx}
     */
    AlignPanel(Component c1, double weightx1,
               Component c2, double weightx2,
               Component c3, double weightx3) {
        this(c1, weightx1);
        add (c2, weightx2);
        add (c3, weightx3);
    }

    /**
     * ݡͥȤɲäޤ
     * <code>weightx</code>  <code>1.0</code> ξϡ
     * {@link GridBagConstraints#HORIZONTAL} ꤵޤ
     *
     * @param  c ݡͥ
     * @param  weightx {@link GridBagConstraints#weightx}
     */
    public void add(Component c, double weightx) {
        if (weightx == 1) {
            LayoutUtils.addGridBag(this, c, gbl, count++, 0, 1, 1, weightx, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        } else {
            LayoutUtils.addGridBag(this, c, gbl, count++, 0, 1, 1, weightx, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST, insets);
        }
    }

    /**
     * ̵ͭڤؤޤ
     *
     * @param  b ͭˤ <code>true</code>
     *           ̵ˤ <code>false</code>
     */
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        Component[] cs = getComponents();
        for (int i = 0; i < cs.length; i++) {
            cs[i].setEnabled(b);
        }
    }
}
