/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.history;

import net.hizlab.kagetaka.util.StringUtils;

import java.io.Writer;
import java.io.InvalidObjectException;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Date;

/**
 * ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class History {
    private String  title;
    private String  url;
    private long    firstVisit;
    private long    lastVisit;
    private int     visitCount;
    private boolean visible;

    History next;
    History prev;

    /**
     * ޤ
     *
     * @param  url   URL
     */
    public History(String url) {
        this.title      = "";
        this.url        = url;
        this.firstVisit = System.currentTimeMillis();
        this.lastVisit  = firstVisit;
        this.visitCount = 1;
    }

    /**
     * ֶڤʸ󤫤顢ޤ
     *
     * @param  line ֶڤʸ
     * @param  load ߡ
     *
     * @throws InvalidObjectException ʸξ
     */
    History(String line, boolean load)
            throws InvalidObjectException {
        int p1 = 0, p2, length = line.length();
        String[] s = new String[5];
        for (int i = 0; i < 5; i++) {
            if ((p2 = line.indexOf('\t', p1)) == -1) {
                p2 = length;
            }

            s[i] = line.substring(p1, p2);
            if ((p1 = p2 + 1) >= length) {
                break;
            }
        }
        try {
            this.title      = s[0];
            this.url        = s[1];
            this.firstVisit = Long   .parseLong(s[2]);
            this.lastVisit  = Long   .parseLong(s[3]);
            this.visitCount = Integer.parseInt (s[4]);
        } catch (NumberFormatException e) {
            throw new InvalidObjectException("invalid format");
        }
        if (this.title == null || this.url == null) {
            throw new InvalidObjectException("invalid format");
        }
    }

    /**
     * ȥޤ
     *
     * @return ȥ
     */
    public String getTitle() {
        return title;
    }

    /**
     * ȥꤷޤ
     *
     * @param  title ȥ
     */
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }

        this.title = title;
    }

    /**
     * URL ޤ
     *
     * @return URL
     */
    public URL getURL() {
        URL url = null;

        try {
            url = StringUtils.toURL(this.url);
        } catch (MalformedURLException e) {
            return null;
        }

        return url;
    }

    /**
     * URL ʸɽޤ
     *
     * @return URL
     */
    public String getURLText() {
        return url;
    }

    /**
     * ˬߥä֤ޤ
     *
     * @return ߥ
     */
    public long getFirstVisit() {
        return firstVisit;
    }

    /**
     * ǽˬߥä֤ޤ
     *
     * @return ߥ
     */
    public long getLastVisit() {
        return lastVisit;
    }

    /**
     * ˬ֤ޤ
     *
     * @return 
     */
    public int getVisitCount() {
        return visitCount;
    }

    /**
     * ˬѤߤޡޤ
     */
    void visited() {
        this.lastVisit = System.currentTimeMillis();
        this.visitCount++;
    }

    /**
     * ɽ뤫ɤ֤ޤ
     *
     * @return ɽ <code>true</code>
     *         ɽʤ <code>false</code>
     */
    public boolean isVisible() {
        return visible;
    }

    /**
     * ɽ뤫ɤꤷޤ
     *
     * @param  visible ɽ <code>true</code>
     *                 ɽʤ <code>false</code>
     */
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    /**
     * ֶڤʸȤƽϤޤ
     *
     * @param  w 饤
     *
     * @throws IOException I/O 顼ȯ
     */
    void write(Writer w)
            throws IOException {
        w.write(title);
        w.write("\t");
        w.write(url);
        w.write("\t");
        w.write(String.valueOf(firstVisit));
        w.write("\t");
        w.write(String.valueOf(lastVisit));
        w.write("\t");
        w.write(String.valueOf(visitCount));
    }

    /**
     * ʸѴޤ
     *
     * @return ʸ
     */
    public String toString() {
        return title + ", (" + url + "), " + new Date(lastVisit) + ", " + visitCount;
    }
}
