/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.download;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.AWTEventMulticaster;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.ProgressBar;
import net.hizlab.kagetaka.awt.SizedButton;
import net.hizlab.kagetaka.awt.event.StateEvent;
import net.hizlab.kagetaka.awt.event.StateListener;
import net.hizlab.kagetaka.io.MeteredInputStream;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.ViewerContent;
import net.hizlab.kagetaka.viewer.WindowManager;
import net.hizlab.kagetaka.viewer.bookmark.Bookmark;
import net.hizlab.kagetaka.viewer.option.Setter;
import net.hizlab.kagetaka.viewer.option.ViewerOption;
import net.hizlab.kagetaka.viewer.option.InvalidValueException;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.OutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.text.MessageFormat;

/**
 * ɤԤΥɥǤ
 *
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.6 $
 */
public class Download extends Frame implements HawkWindow {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.download.Resources";
    private static final int    MARGIN   = 10;
    private static final int    BUTTON_LENGTH = 90;

    /** ɤϤ줿 */
    public static final int START    = 1;
    /** ɤߤ줿 */
    public static final int STOP     = 2;
    /** ɤ˽λ */
    public static final int COMPLETE = 3;
    /** ˥顼ȯߤ */
    public static final int ERRORED  = 4;
    /** ɤǤ줿 */
    public static final int SUSPEND  = 5;
    /** ɤƳ줿 */
    public static final int RESUME   = 6;

    /** @serial URL */
    private TextField   textUrl;
    /** @serial ѥ */
    private TextField   textPath;
    /** @serial  */
    private Label       labelState;
    /** @serial Ĥ */
    private Label       labelRemain;
    /** @serial в */
    private Label       labelProcess;
    /** @serial Ψ */
    private Label       labelProgress;
    /** @serial С */
    private ProgressBar progressBar;
    /** @serial å */
    private Checkbox    checkKeepOpen;
    /** @serial Ĥ */
    private Button      buttonClose;

    /** @serial ȥեޥå */
    private MessageFormat mfTitle;
    /** @serial եޥå */
    private MessageFormat mfState;
    /** @serial Ĥեޥå */
    private MessageFormat mfRemain;
    /** @serial вեޥå */
    private MessageFormat mfProcess;
    /** @serial Ψեޥå */
    private MessageFormat mfProgress;

    /** @serial ץ */
    private ViewerOption   option;
    /** @serial ͥ */
    private Content        content;
    /** @serial եѥ */
    private File           filePath;

    /** @serial ɥޥ͡ */
    private WindowManager  wm;
    /** @serial ɥå */
    private DownloadThread thread;
    /** @serial ե饰 */
    private boolean        complete;
    /** @serial ɺѤߥ */
    private int            resumeLength;

    private transient StateListener stateListener;

    /**
     * ¸Υܥåɽ¸Ԥޤ
     * ɤ̥åɤǹԤΤǡ
     * ɤ򳫻Ϥȡ᥽åɤλޤ
     *
     * @param  owner   ʡ
     * @param  option  ץ
     * @param  content ƥ
     * @param  l       ѹꥹ
     *
     * @return ¸ѥ
     *         󥻥뤵줿 <code>null</code>
     */
    public static File show(Frame owner, ViewerOption option, Content content, StateListener l) {
        File path = null;

        // եܥ
        String fileName = null;
        if (content instanceof ViewerContent) {
            fileName = ((ViewerContent) content).getFileName();
        }

        //### BUGS ե̾å

        FileDialog fd = new FileDialog(owner,
                                       Resource.getMessage(RESOURCE, "download.savedialog.title", null),
                                       FileDialog.SAVE);
        File dir = option.getPropertyFile(ViewerOption.KEY_DOWNLOAD_SAVE_PATH);
        if (dir != null) {
            fd.setDirectory(dir.toString());
        }

        fd.setFile(fileName);
        fd.show();

        String pathName = fd.getFile();
        if (pathName == null) {
            fd.dispose();
            return null;
        }

        String newDir;
        if ((newDir = fd.getDirectory()) != null) {
            dir = new File(newDir);
            Setter setter = option.getSetter();
            try {
                setter.putPropertyFile(ViewerOption.KEY_DOWNLOAD_SAVE_PATH, dir);
                setter.commit();
            } catch (InvalidValueException e) { }
        }
        path = (dir != null ? new File(dir, pathName) : new File(pathName));
        fd.dispose();

        Download dialog = new Download(option, content, path);

        dialog.addStateListener(l);
        dialog.show();
        dialog.start();

        return path;
    }

    /**
     * ɥɥޤ
     *
     * @param  option  ץ
     * @param  content ƥ
     * @param  path    ¸Υѥ
     */
    public Download(ViewerOption option, Content content, File path) {
        this.option   = option;
        this.content  = content;
        this.filePath = path;
        this.wm       = WindowManager.getInstance();

        mfTitle    = new MessageFormat(getMessage("title.format"      ));
        mfState    = new MessageFormat(getMessage("state.format"      ));
        mfRemain   = new MessageFormat(getMessage("remain.format"     ));
        mfProcess  = new MessageFormat(getMessage("process.format"    ));
        mfProgress = new MessageFormat(getMessage("progressbar.format"));
        thread     = new DownloadThread();

        setForeground(SystemColor.textText);
        setBackground(SystemColor.control );
        setResizable (false               );

        Image image = Resource.getImageResource(RESOURCE, "download.icon", getToolkit());
        if (image != null) {
            setIconImage(image);
        }

        String pathString = path.getAbsolutePath();
        try {
            pathString = path.getCanonicalPath();
        } catch (IOException e) { }

        // ɥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
        setLayout(gbl);

        Panel mainPanel   = new Panel();
        Panel buttonPanel = new Panel();
        LayoutUtils.addGridBag(this, mainPanel  , gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, GridBagConstraints.WEST, insets);
        insets.top = 0;
        LayoutUtils.addGridBag(this, buttonPanel, gbl, 0, 1, 1, 0, 0, 0, GridBagConstraints.NONE, GridBagConstraints.EAST, insets);

        // ᥤѥͥ
        gbl    = new GridBagLayout();
        insets = new Insets(0, 0, 2, 0);
        mainPanel.setLayout(gbl);

        LayoutUtils.addGridBag(mainPanel,                 new Label      (getMessage("from.label"                        )), gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.EAST  , insets);
        LayoutUtils.addGridBag(mainPanel, textUrl       = new TextField  (content.url.toString()                      , 30), gbl, 1, 0, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel,                 new Label      (getMessage("to.label"                          )), gbl, 0, 1, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.EAST  , insets);
        LayoutUtils.addGridBag(mainPanel, textPath      = new TextField  (pathString                                  , 30), gbl, 1, 1, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel,                 new Label      (getMessage("state.label"                       )), gbl, 0, 2, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.EAST  , insets);
        LayoutUtils.addGridBag(mainPanel, labelState    = new Label      (                                                ), gbl, 1, 2, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel,                 new Label      (getMessage("remain.label"                      )), gbl, 0, 3, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.EAST  , insets);
        LayoutUtils.addGridBag(mainPanel, labelRemain   = new Label      (                                                ), gbl, 1, 3, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel,                 new Label      (getMessage("process.label"                     )), gbl, 0, 4, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.EAST  , insets);
        LayoutUtils.addGridBag(mainPanel, labelProcess  = new Label      (                                                ), gbl, 1, 4, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel,                 new Label      (getMessage("progressbar.label"                 )), gbl, 0, 5, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.EAST  , insets);
        LayoutUtils.addGridBag(mainPanel, progressBar   = new ProgressBar(                                                ), gbl, 1, 5, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel, labelProgress = new Label      (mfProgress.format(new Object[]{new Integer(-1)})), gbl, 2, 5, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
        LayoutUtils.addGridBag(mainPanel, checkKeepOpen = new Checkbox   (getMessage("keepopen"                          )), gbl, 0, 6, 3, 1, 1, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);

        // ܥѥͥ
        buttonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 0));
        buttonPanel.add(buttonClose = new SizedButton(getMessage("button.close"), BUTTON_LENGTH));

        // ꥹʤϿ
        addWindowListener(
            new WindowAdapter() {
                /** ɥ줿Ȥ */
                public void windowOpened(WindowEvent e) {
                    wm.addWindow(Download.this);
                }

                /** ɥĤ褦ȤȤ */
                public void windowClosing(WindowEvent e) {
                    dispose();
                }

                /** ɥĤ줿Ȥ */
                public void windowClosed(WindowEvent e) {
                    wm.removeWindow(Download.this);

                    thread.interrupt();

                    // ץ¸
                    Point position = getLocation();
                    if (position.x >= 0 || position.y >= 0) {
                        Setter setter = Download.this.option.getSetter();
                        try {
                            setter.putPropertyPoint(ViewerOption.KEY_DOWNLOAD_WINDOW_POSITION, position);
                            setter.commit();
                        } catch (InvalidValueException ex) { }
                    }
                }
            }
        );
        buttonClose.addActionListener(
            new ActionListener() {
                /**  */
                public void actionPerformed(ActionEvent e) {
                    dispose();
                }
            }
        );
        checkKeepOpen.addItemListener(
            new ItemListener() {
                /** ֤ѹ줿 */
                public void itemStateChanged(ItemEvent e) {
                    Setter setter = Download.this.option.getSetter();
                    try {
                        setter.putPropertyBoolean(ViewerOption.KEY_DOWNLOAD_WINDOW_CLOSE, checkKeepOpen.getState());
                        setter.commit();
                    } catch (InvalidValueException ex) { }
                }
            }
        );

        // ֤
        pack();
        Point position = option.getPropertyPoint(ViewerOption.KEY_DOWNLOAD_WINDOW_POSITION);
        if (position != null) {
            setLocation(position);
        } else {
            Dimension size        = getSize();
            Dimension desktopSize = getToolkit().getScreenSize();
            setLocation((desktopSize.width  - size.width ) / 2,
                        (desktopSize.height - size.height) / 2);
        }

        // ƥȥΥǥեȤ
        setTitle(mfTitle.format(new Object[]{new Integer(-1), filePath.getName()}));
        textUrl      .setEditable(false);
        textPath     .setEditable(false);
        textUrl      .setBackground(getBackground());
        textPath     .setBackground(getBackground());
        checkKeepOpen.setState(option.getPropertyBoolean(ViewerOption.KEY_DOWNLOAD_WINDOW_CLOSE, false));
    }

    /**
     * ΥɥΥȥ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  title ΥɥΥȥ
     */
    public synchronized void setTitle(String title) {
        super.setTitle(title);
        wm.changeWindow(this);
    }

    /**
     * ֥ꥹʤϿޤ
     *
     * @param  l Ͽ֥ꥹ
     */
    public synchronized void addStateListener(StateListener l) {
        enableEvents(0);
        stateListener = AWTEventMulticaster.add(stateListener, l);
    }

    /**
     * ֥ꥹʤޤ
     *
     * @param  l ֥ꥹ
     */
    public synchronized void removeStateListener(StateListener l) {
        stateListener = AWTEventMulticaster.remove(stateListener, l);
    }

    /**
     * ΥݡͥȤȯ륳ݡͥȥ٥Ȥޤ
     *
     * @param  e ٥
     */
    protected void processEvent(AWTEvent e) {
        if (e instanceof StateEvent) {
            processStateEvent((StateEvent) e);
            return;
        }
        super.processEvent(e);
    }

    /**
     * ΥݡͥȤȯѹ٥Ȥ
     * ϿƤ뤹٤Ƥ {@link StateListener} 뤳Ȥˤꡢ
     * ѹ٥Ȥޤ
     *
     * @param  e ٥
     */
    protected void processStateEvent(StateEvent e) {
        if (stateListener == null) {
            return;
        }

        switch (e.getID()) {
        case StateEvent.STATE_CHANGED: stateListener.stateChanged(e); break;
        default: // AVOID
        }
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "download." + key, null);
    }

    /**
     * ɤ򳫻Ϥޤ
     */
    public synchronized void start() {
        thread.start();
    }

    /**
     * ɤߤޤ
     */
    public synchronized void stop() {
        thread.interrupt();
    }

    /**
     * ɤǤޤ
     *
     * @kagetaka.todo ǤƤޤ
     */
    public synchronized void suspend() {
        //### TODO
    }

    /**
     * ɤƳޤ
     *
     * @kagetaka.todo ǤƤޤ
     */
    public synchronized void resume() {
        //### TODO
    }

    /**
     * 椫ɤ֤ޤ
     *
     * @return ξ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public synchronized boolean isAlive() {
        return thread.isAlive();
    }

    /**
     * ǤƤ뤫ɤ֤ޤ
     *
     * @return ξ <code>true</code>
     *         ʳξ <code>false</code>
     *
     * @kagetaka.todo ǤƤޤ
     */
    public synchronized boolean isSuspended() {
        //### TODO
        return false;
    }

    /**
     * ɤλɤ֤ޤ
     *
     * @return ɤλ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public synchronized boolean isCompleted() {
        return complete;
    }

//### HawkWindow
    /**
     * ɥĤޤ
     */
    public void closeWindow() {
        dispose();
    }

    /**
     * Υ᥽åɤľܸƤӽФƤϹԤޤ
     * ˡ{@link WindowManager#addWindow(HawkWindow)}
     * ƤӽФɬפޤ
     *
     * {@inheritDoc}
     */
    public void addWindowMenu(HawkWindow window) {
    }

    /**
     * Υ᥽åɤľܸƤӽФƤϹԤޤ
     * ˡ{@link WindowManager#removeWindow(HawkWindow)}
     * ƤӽФɬפޤ
     *
     * {@inheritDoc}
     */
    public void removeWindowMenu(int index) {
    }

    /**
     * Υ᥽åɤľܸƤӽФƤϹԤޤ
     * ˡ{@link WindowManager#changeWindow(HawkWindow)}
     * ƤӽФɬפޤ
     *
     * {@inheritDoc}
     */
    public void changeWindowMenu(int index, HawkWindow window) {
    }

    /**
     * Υ᥽åɤľܸƤӽФƤϹԤޤ
     * ˡ{@link WindowManager#addToBookmark(Bookmark, Bookmark)}
     * ƤӽФɬפޤ
     *
     * {@inheritDoc}
     */
    public void addToBookmark(Bookmark parent, Bookmark bookmark) {
    }

    /**
     * Υ᥽åɤľܸƤӽФƤϹԤޤ
     * ˡ{@link WindowManager#bookmarkChanged()}
     * ƤӽФɬפޤ
     *
     * {@inheritDoc}
     */
    public void bookmarkChanged() {
    }

//### DownloadThread
    /** ɤԤå */
    private final class DownloadThread extends Thread {
        private static final int BUFFER_SIZE = 512;

        /** 󥹥󥹤 */
        private DownloadThread() {
        }

        /** Ԥ */
        public void run() {
            buttonClose.setLabel(getMessage("button.cancel"));
            getToolkit().getSystemEventQueue().postEvent(new StateEvent(Download.this, StateEvent.STATE_CHANGED, START));

            int stopState = download();

            buttonClose.setLabel(getMessage("button.close"));
            getToolkit().getSystemEventQueue().postEvent(new StateEvent(Download.this, StateEvent.STATE_CHANGED, stopState));

            // ѡȤʬʤʤɤ⤢Τǡ100% ˤ
            if (stopState == COMPLETE) {
                progressBar  .setValue(100);
                labelProgress.setText (mfProgress.format(new Object[]{new Integer(100)}));
            }

            if (!checkKeepOpen.getState()) {
                dispose();
            }
        }

        /** Ԥ */
        private int download() {
            int          stopState = STOP;
            InputStream  is = null;
            OutputStream os = null;

            try {
                is = new Chatty              (content.getInputStream(null),
                                              content.contentLength);
                os = new BufferedOutputStream(new FileOutputStream(filePath),
                                              BUFFER_SIZE);
            } catch (IOException e) {
                //### ERROR
                return ERRORED;
            }

            READ:
            try {
                byte[] buffer = new byte[BUFFER_SIZE];
                int    len;

                while ((len = is.read(buffer, 0, BUFFER_SIZE)) != -1) {
                    if (isInterrupted()) {
                        break READ;
                    }
                    os.write(buffer, 0, len);
                }

                complete  = true;
                stopState = COMPLETE;
            } catch (IOException e) {
                //### ERROR
                stopState = ERRORED;
            }

            try {
                is.close();
            } catch (IOException e) { }

            if (os != null) {
                try {
                    os.flush();
                    os.close();
                } catch (IOException e) { }
            }

            return stopState;
        }
    }

//### Chatty
    /** ɤ߹Ψ𤹤ꥹ */
    private final class Chatty extends MeteredInputStream {
        private long start;
        private long fileLength;

        private int  percent = -1;
        private long ltime;
        private long lpersec = -1000;
        private long totalLength;
        private long lenPerSec;
        private Object[] oTitle;
        private Object[] oState;
        private Object[] oRemain;
        private Object[] oProcess;
        private Object[] oProgress;

        private int n, p;

        /** 󥹥󥹤 */
        private Chatty(InputStream in, long length) {
            super(in);
            start      = System.currentTimeMillis();
            fileLength = length;

            if (fileLength >= 0) {
                oTitle    = new Object[]{null, filePath.getName()};
                oState    = new Object[]{null, new Double(fileLength / 1024.0), new Double(0)};
                oRemain   = new Object[3];
                oProgress = new Object[1];
            } else {
                oState    = new Object[]{null, new Integer(-1), new Double(0)};
            }
            oProcess = new Object[3];
        }

        /** ɤ߹ХȿѤä */
        protected void changed(long length) {
            ltime       = System.currentTimeMillis() - start;    // в
            totalLength = length + resumeLength;                 // ɤĹ
            lenPerSec   = length / Math.max(ltime / 1000, 1);    // Х/

            oState[0] = new Double(totalLength / 1024.0);
            if (lpersec + 1000 < ltime) {         // ®٤ 1 ðʾֳ֤򳫤ƹ
                oState[2] = new Double(lenPerSec / 1024.0);
                lpersec = ltime;
            }

            n = (int) (ltime / 1000);
            oProcess[2] = new Integer(n % 60); n /= 60;
            oProcess[1] = new Integer(n % 60);
            oProcess[0] = new Integer(n / 60);

            labelState  .setText(mfState  .format(oState  ));
            labelProcess.setText(mfProcess.format(oProcess));

            if (fileLength >= 0) {
                p = (int) (totalLength * 100 / fileLength);   // ѡ

                if (p != percent) {
                    percent = p;
                    progressBar.setValue(percent);
                    oProgress[0] = oTitle[0] = new Integer(percent);
                    setTitle(mfTitle.format(oTitle));
                    labelProgress.setText(mfProgress.format(oProgress));
                }

                n = (int) ((fileLength - totalLength) / lenPerSec); // Ĥ
                oRemain[2] = new Integer(n % 60); n /= 60;
                oRemain[1] = new Integer(n % 60);
                oRemain[0] = new Integer(n / 60);

                labelRemain.setText(mfRemain.format(oRemain));
            }
        }
    }
}
