/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.cookie;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.addin.cookie.Cookie;
import net.hizlab.kagetaka.viewer.option.ViewerOption;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.FileNotFoundException;
import java.io.InvalidObjectException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

/**
 * å륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class CookieManager extends net.hizlab.kagetaka.addin.cookie.CookieManager {
    private static final String ENCODING = "UTF-8";
    private static final int LF = 0x0A;

    /** Ĥޤ */
    public static final String YES = "yes";
    /** Ĥ뤫ɤ䤤碌ޤ */
    public static final String ASC = "asc";
    /** Ĥޤ */
    public static final String NO  = "no";

    private ViewerOption  option;
    //private HistoryEditor editor;
    private File          cookieFile;

    /**
     * åޥ͡ޤ
     *
     * @param  option ץ
     */
    public CookieManager(ViewerOption option) {
        this.option = option;
        this.strict = option.getPropertyBoolean(ViewerOption.KEY_COOKIE_ACCEPT_STRICT, false);
        load(option.getPropertyFile(ViewerOption.KEY_COOKIE_PATH));
    }

    /**
     * ե뤫ɤޤ
     *
     * @param  file ɤե
     */
    private synchronized void load(File file) {
        try {
            BufferedReader br = new BufferedReader(
                                  new InputStreamReader(
                                    new FileInputStream(file),
                                    ENCODING
                                  )
                                );

            cookieFile = file;

            String line;

            READ:
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (line.length() == 0 || line.startsWith("#")) {
                    continue;
                }

                try {
                    appendCookie(new Cookie(line));
                } catch (InvalidObjectException e) { }
            }

            br.close();
        } catch (FileNotFoundException e) {
            return;
        } catch (IOException e) {
            //### ERROR
Debug.out.println(e);
e.printStackTrace(Debug.out);
        }
    }

    /**
     * ե¸ޤ
     */
    public synchronized void save() {
        if (!option.getPropertyBoolean(ViewerOption.KEY_COOKIE_SAVE, true)) {
            return;
        }

        File file = option.getPropertyFile(ViewerOption.KEY_COOKIE_PATH);

        if (!ViewerOption.ensureDirectory(file.getParent())) {
            //### ERROR
Debug.out.println("Can not create parent dir (" + file + ")");
            return;
        }

        try {
            BufferedWriter bw = new BufferedWriter(
                                  new OutputStreamWriter(
                                    new FileOutputStream(file),
                                    ENCODING
                                  )
                                );

            long now = System.currentTimeMillis();
            Cookie c;

            bw.write("# HTTP Cookie File"                                    ); bw.write(LF);
            bw.write("# http://www.netscape.com/newsref/std/cookie_spec.html"); bw.write(LF);
            bw.write("# This is a generated file!  Do not edit."             ); bw.write(LF);
            bw.write("# To delete cookies, use the Cookie Manager."          ); bw.write(LF);
            bw.write(LF);

            for (Enumeration e = hash.keys(); e.hasMoreElements();) {
                c = (Cookie) hash.get(e.nextElement());
                while (c != null) {
                    if (c.getExpires() != -1 && c.getExpires() > now) {
                        c.write(bw);
                        bw.write(LF);
                    }
                    c = c.getNext();
                }
            }
            bw.flush();
            bw.close();
        } catch (IOException e) {
            //### ERROR
Debug.out.println(e);
e.printStackTrace(Debug.out);
        }
    }

    /** {@inheritDoc} */
    public Cookie createCookie(String data, URL url) {
        return super.createCookie(data, url);
    }

    /**
     * ꤷåꡢ¸ޤ
     *
     * @param  cookie å
     */
    public void setCookie(Cookie cookie) {
        appendCookie(cookie);
    }

    /**
     * å֤ޤ
     *
     * @param  reverse ֤ <code>true</code>
     *                 Ť֤ <code>false</code>
     *
     * @return 
     *
     * @kagetaka.bugs Ƥޤ
     */
    public synchronized Cookie[] getCookies(boolean reverse) {
/*
        Cookie[] cookies = new Cookie[hash.size()];
        int index = 0;

        if (reverse) {
            Cookie c = last;
            while (c != null) {
                cookies[index++] = c;
                c = c.prev;
            }
        } else {
            Cookie c = top;
            while (c != null) {
                cookies[index++] = c;
                c = c.getNext();
            }
        }

        return cookies;
*/
        return null;
    }

    /**
     * åǥɽޤ
     *
     * @kagetaka.bugs Ƥޤ
     */
    public synchronized void showEditor() {
/*
        if (editor == null || !editor.isVisible()) {
            editor = new CookieEditor(option);
        }

        editor.show();
*/
    }
}
