/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer.bookmark;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.InputBox;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.viewer.option.ViewerOption;
import net.hizlab.kagetaka.viewer.theme.Theme;

import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

/**
 * ǧھϤ뤿ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class BookmarkAs extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.bookmark.Resources";
    private static final int    MARGIN   = 3;

    /** @serial ֥åޡޥ͡ */
    private BookmarkManager bm;
    /** @serial ʡ */
    private Frame      owner;
    /** @serial ƥ */
    private TextField  text;
    /** @serial URL */
    private TextField  urlText;
    /** @serial ֥åޡĥ꡼ */
    private Tree       tree;
    /** @serial ƥ֥åޡ */
    private Bookmark   parent;
    /** @serial 롼ȥƥ */
    private Item       root;
    /** @serial Υȥ */
    private Vector     entries;
    /** @serial եγ᡼ */
    private Image      openfolderImage;
    /** @serial եĤ᡼ */
    private Image      closefolderImage;

    /**
     * ֥åޡؤɲäɽη̤֤ޤ
     *
     * @param  owner  ʡ
     * @param  option ץ
     * @param  text   ƥ
     * @param  url    URL
     *
     * @return ɲä̤ɲþ
     *         󥻥뤵줿 <code>null</code>
     */
    public static Entry[] show(Frame owner, ViewerOption option, String text, String url) {
        BookmarkAs dialog = new BookmarkAs(owner, option);

        dialog.setText(text);
        dialog.setURL (url );
        dialog.show();

        if (dialog.getResult() != RESULT_OK) {
            return null;
        }

        return dialog.getAddedEntries();
    }

    /**
     * ֥åޡؤɲäΥܥåޤ
     *
     * @param  owner ʡ
     * @param  option ץ
     */
    public BookmarkAs(Frame owner, ViewerOption option) {
        super(owner, BUTTON_OKCANCEL);
        setTitle    (getMessage("title"));
        setResizable(true );
        setModal    (true );
        this.owner = owner;
        this.bm    = option.getBookmarkManager();

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
        mainPanel.setLayout(gbl);

        Button folder;
        addToPanel(          new Label    (getMessage("label.text"  )), gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST     , insets);
        addToPanel(text    = new TextField(                          ), gbl, 1, 0, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER   , insets);
        addToPanel(          new Label    (getMessage("label.url"   )), gbl, 0, 1, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST     , insets);
        addToPanel(urlText = new TextField(                          ), gbl, 1, 1, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER   , insets);
        addToPanel(          new Label    (getMessage("label.folder")), gbl, 0, 2, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.NORTHWEST, insets);
        addToPanel(tree    = new Tree     (10, 20                    ), gbl, 1, 2, 1, 1, 1, 1, GridBagConstraints.BOTH      , GridBagConstraints.CENTER   , insets);
        addToPanel(folder  = new Button   (getMessage("label.new"   )), gbl, 2, 2, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.NORTHEAST, insets);

        folder.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    createNewFolder();
                }
            }
        );

        Theme theme = option.getThemeManager().getTheme();
        openfolderImage  = theme.getImage(Theme.BOOKMARK_OPENFOLDER , getToolkit());
        closefolderImage = theme.getImage(Theme.BOOKMARK_CLOSEFOLDER, getToolkit());

        // ƥȥΥǥեȤ
        tree.setRootTreeItem((root = new Item(null, bm.getRootBookmark())));
        tree.setBackground(SystemColor.window);

        // 礭
        pack();
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "bookmarkas." + key, null);
    }

    /**
     * ꤵƤɽʸ֤ޤ
     *
     * @return ɽʸ
     */
    public String getText() {
        return text.getText();
    }

    /**
     * ɽʸꤷޤ
     *
     * @param  value ɽʸ
     */
    public void setText(String value) {
        text.setText(value);
    }

    /**
     * ꤵƤ URL ֤ޤ
     *
     * @return URL
     */
    public String getURL() {
        return urlText.getText();
    }

    /**
     * ΰꤷޤ
     *
     * @param  value ΰ
     */
    public void setURL(String value) {
        urlText.setText(value);
    }

    /**
     * 򤵤Ƥƥ֥åޡ֤ޤ
     *
     * @return ƥ֥åޡ
     */
    public Bookmark getParentBookmark() {
        Item item = (Item) tree.getSelectedTreeItem();
        if (item == null) {
            return null;
        }

        return item.bookmark;
    }

    /**
     * ƥ֥åޡꤷޤ
     *
     * @param  value ƥ֥åޡ
     */
    public void setParentBookmark(Bookmark value) {
        this.parent = value;
    }

    /**
     * 桼ɲ֥åޡ֤ޤ
     * ɲǺ֥åޡեȡ
     * ºݤ˺֥åޡޤޤޤ
     *
     * @return ɲä줿֥åޡɲä֤֤
     *         󥻥뤵줿 <code>null</code>
     */
    public synchronized Entry[] getAddedEntries() {
        Entry entry = new Entry(getParentBookmark(), new Bookmark(getText(), getURL()));
        if (entries == null) {
            return new Entry[]{entry};
        }

        entries.addElement(entry);
        Entry[] es = new Entry[entries.size()];
        entries.copyInto(es);

        return es;
    }

    /**
     * 桼ɲ֥åޡ򥯥ꥢޤ
     */
    public synchronized void removeAllAddedEntries() {
        entries = null;
    }

    /** ե */
    private void createNewFolder() {
        String name = InputBox.show(owner,
                                    getMessage("newfolder.message"),
                                    getMessage("newfolder.title"  ),
                                    "", false);
        if (name == null) {
            return;
        }

        synchronized (this) {
            if (entries == null) {
                entries = new Vector();
            }

            Bookmark bookmark = new Bookmark(name);
            entries.addElement(new Entry(getParentBookmark(), bookmark));

            Item item = (Item) tree.getSelectedTreeItem();
            if (item == null) {
                item = root;
            }

            item.addLastChild(new Item(item, bookmark));
        }

        tree.refresh();
    }

    /** ե */
    private Vector createFolder(Item parent, Vector bookmarks) {
        Vector   v = new Vector();
        Bookmark b;
        for (int i = 0; i < bookmarks.size(); i++) {
            b = (Bookmark) bookmarks.elementAt(i);
            if (b.getType() == Bookmark.FOLDER) {
                v.addElement(new Item(parent, b));
            }
        }
        return v;
    }

//### Item
    /** ֥åޡե */
    private final class Item implements TreeItem {
        private Item     parent;
        private Bookmark bookmark;
        private Vector   items;

        /** 󥹥󥹤 */
        private Item(Item parent, Bookmark bookmark) {
            this.parent   = parent;
            this.bookmark = bookmark;
        }

        /** ĥ꡼ɽ륢֤ */
        public Image getTreeIcon(boolean opened) {
            return (opened ? openfolderImage : closefolderImage);
        }

        /** ĥ꡼ɽ٥֤ */
        public String getTreeLabel() {
            return bookmark.getText();
        }

        /** ҤΥƥ֤ */
        public Vector getTreeItems() {
            if (items != null) {
                return items;
            }

            return (items = createFolder(this, bookmark.getBookmarks()));
        }

        /** ʬλäƤҤκǸɲ */
        private void addLastChild(Item item) {
            Vector v = getTreeItems();
            if (v == null) {
                return;
            }

            v.addElement(item);

            item.parent = this;
        }
    }

//### Entry
    /**
      * ֥åޡɲä֥åޡ
      */
    public final class Entry {
        /** ƥե */
        public final Bookmark parent;
        /** ɲä֥åޡ */
        public final Bookmark bookmark;

        /** 󥹥󥹤 */
        private Entry(Bookmark parent, Bookmark bookmark) {
            if (parent == null) {
                parent = bm.getRootBookmark();
            }

            this.parent   = parent;
            this.bookmark = bookmark;
        }
    }
}
