/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.viewer.bookmark.Bookmark;

import java.util.Stack;
import java.util.Vector;

/**
 * ɥޥ͡Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public final class WindowManager {
    private static WindowManager windowManager = new WindowManager();

    private Vector windows     = new Vector();
    private Stack  viewerStack = new Stack();

    /**
     * ɥޥ͡Υ󥹥󥹤ޤ
     *
     * @return ɥޥ͡
     */
    public static WindowManager getInstance() {
        return windowManager;
    }

    /**
     * ɥޥ͡Υ󥹥󥹤ޤ
     */
    private WindowManager() {
    }

    /**
     * ϢΥɥϿޤ
     *
     * @param  window ɥ
     */
    public synchronized void addWindow(HawkWindow window) {
        windows.addElement(window);

        for (int i = 0; i < windows.size(); i++) {
            ((HawkWindow) windows.elementAt(i)).addWindowMenu(window);
        }
    }

    /**
     * ϢΥɥޤ
     *
     * @param  window ɥ
     */
    public synchronized void removeWindow(HawkWindow window) {
        int index = windows.indexOf(window);
        if (index == -1) {
            return;
        }

        windows    .removeElement(window);
        viewerStack.removeElement(window);

        for (int i = 0; i < windows.size(); i++) {
            ((HawkWindow) windows.elementAt(i)).removeWindowMenu(index);
        }
    }

    /**
     * ɥѹ¾αϢΥɥΤޤ
     * ǤϡɥΥȥ뤬ѹ줿˸ƤӽФɬפޤ
     *
     * @param  window ɥ
     */
    public synchronized void changeWindow(HawkWindow window) {
        int index = windows.indexOf(window);

        if (index == -1) {
            return;
        }

        for (int i = 0; i < windows.size(); i++) {
            ((HawkWindow) windows.elementAt(i)).changeWindowMenu(index, window);
        }
    }

    /**
     * ɤΰޤ
     *
     * @return ɥ
     */
    public synchronized HawkWindow[] getWindows() {
        HawkWindow[] wins = new HawkWindow[windows.size()];
        windows.copyInto(wins);

        return wins;
    }

    /**
     * ƥ֤ʥӥ塼ꤷޤ
     *
     * @param  viewer ƥ֤ʥӥ塼
     */
    synchronized void changeActiveViewer(HawkViewer viewer) {
        viewerStack.removeElement(viewer);
        viewerStack.push         (viewer);
    }

    /**
     * ƥ֤ʥӥ塼ޤ
     *
     * @return ƥ֥ӥ塼
     *         ӥ塼Ĥʤ <code>null</code>
     */
    public synchronized HawkViewer getActiveViewer() {
        return (HawkViewer) viewerStack.peek();
    }

    /**
     * ٤ƤΥɥĤơλޤ
     */
    public synchronized void exit() {
        HawkWindow[] windows = getWindows();
        for (int i = 0; i < windows.length; i++) {
            windows[i].closeWindow();
        }
    }

    /**
     * ٤ƤΥɥ˥֥åޡɲä줿ȤΤޤ
     * <p>
     * Υ᥽åɤƤӽФȤˤꡢ٤ƤΥɥ
     * ֥åޡ˥塼ޤ
     *
     * @param  parent   ɲΥ֥åޡե
     * @param  bookmark ɲä֥åޡ
     */
    public synchronized void addToBookmark(Bookmark parent, Bookmark bookmark) {
        for (int i = 0; i < windows.size(); i++) {
            ((HawkWindow) windows.elementAt(i)).addToBookmark(parent, bookmark);
        }
    }

    /**
     * ٤ƤΥɥ˥֥åޡѹ줿ȤΤޤ
     * <p>
     * Υ᥽åɤƤӽФȤˤꡢ٤ƤΥɥ
     * ֥åޡ˥塼ޤ
     */
    public synchronized void bookmarkChanged() {
        for (int i = 0; i < windows.size(); i++) {
            ((HawkWindow) windows.elementAt(i)).bookmarkChanged();
        }
    }
}
