/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.awt.StatusBarIcon;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.rendering.RequestList;
import net.hizlab.kagetaka.viewer.event.ContextEvent;
import net.hizlab.kagetaka.viewer.event.ContextFocusEvent;
import net.hizlab.kagetaka.viewer.event.ContextFocusListener;
import net.hizlab.kagetaka.viewer.event.ContextHistoryEvent;
import net.hizlab.kagetaka.viewer.event.ContextHistoryListener;
import net.hizlab.kagetaka.viewer.event.ContextInformationEvent;
import net.hizlab.kagetaka.viewer.event.ContextInformationListener;
import net.hizlab.kagetaka.viewer.event.ContextRequestEvent;
import net.hizlab.kagetaka.viewer.event.ContextRequestListener;
import net.hizlab.kagetaka.viewer.theme.Theme;
import net.hizlab.kagetaka.rendering.Request;

import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

/**
 * ӥ塼ѤΡ륳ƥȤμǤ
 * ΥƥȤϡ֤бޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.10 $
 */
public class ViewerContext extends ViewerBaseContext {
    private static int tagIndex;            // ѥͥ륿ѥǥå

    private static StatusBarIcon[] dummyIcons = new StatusBarIcon[0];

    private Request curRequest;             // ɽΥꥯȡRequestSet ޤ
    private Request rootRequest;            // ΥꥯȡRequest Τߡ
    private boolean isLoading;              // 椫ɤ

    // ƥȤξ
    private boolean active;
    private String  title;
    private String  address;
    private String  statusText;
    private String  statusTextPermanence;
    private Vector  statusIcons;
    private long    tabMode;

    // ꥹ
    private ContextEventManager        contextEventManager;
    private ContextFocusListener       contextFocusListener;
    private ContextHistoryListener     contextHistoryListener;
    private ContextInformationListener contextInformationListener;
    private ContextRequestListener     contextRequestListener;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  viewer        ӥ塼
     * @param  scrollbarMode Сɽ⡼
     */
    ViewerContext(HawkViewer viewer,
                  int        scrollbarMode) {
        super(viewer, String.valueOf(tagIndex++), null, scrollbarMode, null, null);

        contextEventManager = viewer.getContextEventManager();
    }

    /**
     * ֥⡼ɤޤ
     *
     * @return ֥⡼
     *         {@link HawkViewer}  TABMODE_*
     */
    public long getTabMode() {
        return tabMode;
    }

    /**
     * ֥⡼ɤɲäޤ
     *
     * @param  mode ɲä륿֥⡼
     *              {@link HawkViewer}  TABMODE_*
     */
    public void addTabMode(long mode) {
        tabMode |= mode;
    }

    /**
     * ֥⡼ɤޤ
     *
     * @param  mode 륿֥⡼
     *              {@link HawkViewer}  TABMODE_*
     */
    public void removeTabMode(long mode) {
        tabMode &= ~mode;
    }

    /**
     * ޤ
     *
     * @param  num 
     */
    public void back(int num) {
        Request request = curRequest;
        Request r;
        while (num-- > 0 && (r = request.getPrevious()) != null) {
            request = r;
        }

        if (request == null || request == curRequest) {
            return;
        }

        request.setUseCache(Request.CACHE_SOFT);
        load(request, true);
    }

    /**
     * 뤫ɤ֤ޤ
     *
     * @return  <code>true</code>
     *         ʤ <code>false</code>
     */
    public boolean canBack() {
        return (curRequest != null && curRequest.getPrevious() != null);
    }

    /**
     * ؿʤߤޤ
     *
     * @param  num ʤ
     */
    public void forward(int num) {
        Request request = curRequest;
        Request r;
        while (num-- > 0 && (r = request.getNext()) != null) {
            request = r;
        }

        if (request == null || request == curRequest) {
            return;
        }

        request.setUseCache(Request.CACHE_SOFT);
        load(request, true);
    }

    /**
     * ؿʤ뤫ɤ֤ޤ
     *
     * @return ؿʤ <code>true</code>
     *         ʤʤ <code>false</code>
     */
    public boolean canForward() {
        return (curRequest != null && curRequest.getNext() != null);
    }

    /**
     * ɹޤ
     *
     * @param  mode ɤ߹ߤΥ⡼
     *              {@link net.hizlab.kagetaka.awt.panel.PanelListener}
     *                κɤ߹ߥ⡼ɡ
     */
    public void reload(int mode) {
        synchronized (lock) {
            Request request = curRequest;
            if (request != null) {
                request.setUseCache(mode);
                if (request instanceof RequestSet) {
                    ((RequestSet) request).setReload(true);
                }
                load(request, true);
            }
        }
    }

    /**
     * ɹޤ
     *
     * @param  force Ū˺ɤ߹ߤ <code>true</code>
     *               ̾κɤ߹ߤ <code>false</code>
     */
    public void reload(boolean force) {
        reload(force ? Request.CACHE_NONE
                     : Request.CACHE_CHECK);
    }

    /**
     * ɹǤ뤫ɤ֤ޤ
     *
     * @return ɹ <code>true</code>
     *         ʤ <code>false</code>
     */
    public boolean canReload() {
        return (curRequest != null);
    }

    /**
     * ߤޤ
     */
    public void stop() {
        synchronized (lock) {
            super.stop();
        }
    }

    /**
     * ߤǤ뤫ɤ֤ޤ
     *
     * @return ߽ <code>true</code>
     *         ʤ <code>false</code>
     */
    public boolean canStop() {
        return isLoading;
    }

    /**
     * ƥȤ˴ޤ
     */
    public void dispose() {
        synchronized (lock) {
            super.dispose();
        }
    }

    /* ѥͥե졼Ѥ˥åȥå */
    /** {@inheritDoc} */
    public void setupPanel(Document document, FrameItem rootItem) {
        addStatusBarIcon(null);

        super.setupPanel(document, rootItem);

        // ɲ
        if (document.content instanceof ViewerContent) {
            SSLCertification certification = ((ViewerContent) document.content).getSSLCertification();
            if (certification != null) {
                addStatusBarIcon(new SSLIcon(certification));
            }
        }
    }

//### package
    /**
     * ƥ֤ꤷޤ
     *
     * @param  active ƥ֤ˤʤä <code>true</code>
     *                ʳξ <code>false</code>
     */
    void setActived(boolean active) {
        synchronized (lock) {
            this.active = active;

            dispatchContextEvent(new ContextFocusEvent(this,
                                                       (active
                                                        ? ContextFocusEvent.CONTEXT_FOCUS_GAINED
                                                        : ContextFocusEvent.CONTEXT_FOCUS_LOST),
                                                       isLoading,
                                                       curRequest));


            if (active) {
                historyChanged(curRequest, false);
                titleChanged     (title  );
                addressChanged   (address);
                statusChanged    (statusText, true, true);
                statusIconChanged();
            }
        }
    }

    /**
     * ɥ쥹ꤷޤ
     *
     * @param  address ɥ쥹
     */
    void setAddress(String address) {
        synchronized (lock) {
            this.address = address;
        }
    }

//### package override
    /* ꥯȤ */
    /** {@inheritDoc} */
    void load(Request request, boolean notify) {
        synchronized (lock) {
            if (request != curRequest) {
                // ΥꥯȤ¸
                rootRequest = (request instanceof RequestSet
                               ? ((RequestSet) request).getFrameset().request
                               : request);
                setAddress(request.url.toString());
            }

            super.load(request, notify);
        }
    }

    /* ꥯȤμդץå */
    /** {@inheritDoc} */
    Request requestAccepted(Request request) {
        // ߤΥե졼֤¸
        if (curRequest != null) {
            RequestSet.Frameset frameset = getRequestSetItem();
            boolean reload = (curRequest == request);
            if (frameset == null) {
                if (curRequest instanceof RequestSet) {
                    curRequest = RequestList.replace(curRequest, ((RequestSet) curRequest).getFrameset().request);
                }
            } else {
                if (curRequest instanceof RequestSet) {
                    ((RequestSet) curRequest).setFrameset(frameset);
                } else {
                    curRequest = RequestList.replace(curRequest, new RequestSet(curRequest, frameset));
                }
            }

            // ɤ߹ߤξϥꥯȤ֤
            if (reload) {
               request = curRequest;
            }
        }

        return request;
    }

    /* ѹץå */
    /** {@inheritDoc} */
    void historyChanged(Request request, boolean addChain) {
        if (addChain) {
            // ꥯȥɲ
            if (!request.isChain()) {
                // 롼ȥƥȤǤϤʤ硢ʥåץåȤʪ
                if (request != loadRequest) {
                    request = new RequestSet(viewRequest, null);
                }
                RequestList.append(curRequest, request);
            }
            curRequest = request;
        }

        dispatchContextEvent(new ContextHistoryEvent(this,
                                                     ContextHistoryEvent.CONTEXT_HISTORY_CHANGED,
                                                     request));
    }

    /* ȥ */
    /** {@inheritDoc} */
    void titleChanged(String title) {
        this.title = title;
        dispatchContextEvent(new ContextInformationEvent(this,
                                                         ContextInformationEvent.CONTEXT_INFORMATION_TITLE,
                                                         title));
    }

    /* ɥ쥹ץå */
    /** {@inheritDoc} */
    void addressChanged(String address) {
        this.address = address;
        dispatchContextEvent(new ContextInformationEvent(this,
                                                         ContextInformationEvent.CONTEXT_INFORMATION_ADDRESS,
                                                         address));
    }

    /* ơС */
    /** {@inheritDoc} */
    void statusChanged(String status, boolean isPermanence, boolean force) {
        synchronized (lock) {
            if (!isPermanence && status == null) {
                status = statusTextPermanence;
            }
            if (!force
                    && (status == statusText
                     || (status     != null
                      && statusText != null
                      && status.compareTo(statusText) == 0))) {
                return;
            }
            dispatchContextEvent(new ContextInformationEvent(this,
                                                             ContextInformationEvent.CONTEXT_INFORMATION_STATUS,
                                                             status));
            this.statusText = status;
            if (isPermanence) {
                this.statusTextPermanence = status;
            }
        }
    }

    /* ꥯȤΥɾ֤ѹץå */
    /** {@inheritDoc} */
    void loadStatusChanged(boolean isLoading) {
        dispatchContextEvent(new ContextRequestEvent(this,
                                                     (isLoading
                                                      ? ContextRequestEvent.CONTEXT_REQUEST_ACCEPTED
                                                      : ContextRequestEvent.CONTEXT_REQUEST_DONE),
                                                     rootRequest));
        this.isLoading = isLoading;
    }

//### private
    /** ơС˥ɲ */
    private void addStatusBarIcon(StatusBarIcon icon) {
        synchronized (lock) {
            if (icon != null) {
                if (statusIcons == null) {
                    statusIcons = new Vector();
                }
                statusIcons.addElement(icon);
            } else {
                if (statusIcons != null) {
                    statusIcons.removeAllElements();
                }
            }

            statusIconChanged();
        }
    }

    /** ơСѹ줿ץå */
    private void statusIconChanged() {
        StatusBarIcon[] icons;

        if (statusIcons == null || statusIcons.size() == 0) {
            icons = dummyIcons;
        } else {
            icons = new StatusBarIcon[statusIcons.size()];
            statusIcons.copyInto(icons);
        }

        dispatchContextEvent(new ContextInformationEvent(this,
                                                         ContextInformationEvent.CONTEXT_INFORMATION_STATUS,
                                                         icons));
    }

//### ꥹ
    /**
     * ƥȥեꥹʤɲäޤ
     *
     * @param  l ƥȥեꥹ
     */
    public void addContextFocusListener(ContextFocusListener l) {
        contextFocusListener = ContextEventMulticaster.add(contextFocusListener, l);
    }

    /**
     * ƥȥեꥹʤޤ
     *
     * @param  l ƥȥեꥹ
     */
    public void removeContextFocusListener(ContextFocusListener l) {
        contextFocusListener = ContextEventMulticaster.remove(contextFocusListener, l);
    }

    /**
     * ƥȥҥȥꥹʤɲäޤ
     *
     * @param  l ƥȥҥȥꥹ
     */
    public void addContextHistoryListener(ContextHistoryListener l) {
        contextHistoryListener = ContextEventMulticaster.add(contextHistoryListener, l);
    }

    /**
     * ƥȥҥȥꥹʤޤ
     *
     * @param  l ƥȥҥȥꥹ
     */
    public void removeContextHistoryListener(ContextHistoryListener l) {
        contextHistoryListener = ContextEventMulticaster.remove(contextHistoryListener, l);
    }

    /**
     * ƥȥե᡼ꥹʤɲäޤ
     *
     * @param  l ƥȥե᡼ꥹ
     */
    public void addContextInformationListener(ContextInformationListener l) {
        contextInformationListener = ContextEventMulticaster.add(contextInformationListener, l);
    }

    /**
     * ƥȥե᡼ꥹʤޤ
     *
     * @param  l ƥȥե᡼ꥹ
     */
    public void removeContextInformationListener(ContextInformationListener l) {
        contextInformationListener = ContextEventMulticaster.remove(contextInformationListener, l);
    }

    /**
     * ƥȥꥯȥꥹʤɲäޤ
     *
     * @param  l ƥȥꥯȥꥹ
     */
    public void addContextRequestListener(ContextRequestListener l) {
        contextRequestListener = ContextEventMulticaster.add(contextRequestListener, l);
    }

    /**
     * ƥȥꥯȥꥹʤޤ
     *
     * @param  l ƥȥꥯȥꥹ
     */
    public void removeContextRequestListener(ContextRequestListener l) {
        contextRequestListener = ContextEventMulticaster.remove(contextRequestListener, l);
    }

    /**
     * ƥȥ٥Ȥۿޤ
     *
     * @param  e ٥
     */
    public final void dispatchContextEvent(ContextEvent e) {
        contextEventManager.dispatch(e);
    }

    /**
     * ƥȥ٥Ȥ򸵤˥ꥹʡƤӽФޤ
     *
     * @param  e ƥȥ٥
     */
    protected void processContextEvent(ContextEvent e) {
        if (e instanceof ContextFocusEvent) {
            processContextFocusEvent      ((ContextFocusEvent      ) e);
        } else if (e instanceof ContextHistoryEvent) {
            processContextHistoryEvent    ((ContextHistoryEvent    ) e);
        } else if (e instanceof ContextInformationEvent) {
            processContextInformationEvent((ContextInformationEvent) e);
        } else if (e instanceof ContextRequestEvent    ) {
            processContextRequestEvent    ((ContextRequestEvent    ) e);
        }
    }

    /**
     * ƥȥե٥Ȥ򸵤˥ꥹʡƤӽФޤ
     *
     * @param  e ƥȥե٥
     */
    protected void processContextFocusEvent(ContextFocusEvent e) {
        ContextFocusListener contextFocusListener = this.contextFocusListener;
        if (contextFocusListener != null) {
            switch (e.getID()) {
            case ContextFocusEvent.CONTEXT_FOCUS_GAINED:
                contextFocusListener.focusGained(e);
                break;
            case ContextFocusEvent.CONTEXT_FOCUS_LOST  :
                contextFocusListener.focusLost  (e);
                break;
            default: // AVOID
            }
        }
    }

    /**
     * ƥȥҥȥꥤ٥Ȥ򸵤˥ꥹʡƤӽФޤ
     *
     * @param  e ƥȥҥȥꥤ٥
     */
    protected void processContextHistoryEvent(ContextHistoryEvent e) {
        ContextHistoryListener contextHistoryListener = this.contextHistoryListener;
        if (contextHistoryListener != null) {
            switch (e.getID()) {
            case ContextHistoryEvent.CONTEXT_HISTORY_CHANGED:
                contextHistoryListener.historyChanged(e);
                break;
            default: // AVOID
            }
        }
    }

    /**
     * ƥȥե᡼󥤥٥Ȥ򸵤˥ꥹʡƤӽФޤ
     *
     * @param  e ƥȥե᡼󥤥٥
     */
    protected void processContextInformationEvent(ContextInformationEvent e) {
        ContextInformationListener contextInformationListener = this.contextInformationListener;
        if (contextInformationListener != null) {
            switch (e.getID()) {
            case ContextInformationEvent.CONTEXT_INFORMATION_ADDRESS:
                contextInformationListener.addressChanged(e);
                break;
            case ContextInformationEvent.CONTEXT_INFORMATION_TITLE  :
                contextInformationListener.titleChanged  (e);
                break;
            case ContextInformationEvent.CONTEXT_INFORMATION_STATUS :
                contextInformationListener.statusChanged (e);
                break;
            default: // AVOID
            }
        }
    }

    /**
     * ƥȥꥯȥ٥Ȥ򸵤˥ꥹʡƤӽФޤ
     *
     * @param  e ƥȥꥯȥ٥
     */
    protected void processContextRequestEvent(ContextRequestEvent e) {
        ContextRequestListener contextRequestListener = this.contextRequestListener;
        if (contextRequestListener != null) {
            switch (e.getID()) {
            case ContextRequestEvent.CONTEXT_REQUEST_ACCEPTED:
                contextRequestListener.requestAccepted(e);
                break;
            case ContextRequestEvent.CONTEXT_REQUEST_DONE    :
                contextRequestListener.requestDone    (e);
                break;
            default: // AVOID
            }
        }
    }

//### SSLIcon
    /** SSL 򼨤ơС */
    private final class SSLIcon implements StatusBarIcon {
        private SSLCertification certification;
        private MouseListener    listener;

        /** 󥹥󥹤 */
        private SSLIcon(SSLCertification certification) {
            this.certification = certification;
            this.listener = new MouseAdapter() {
                /** å줿 */
                public void mouseClicked(MouseEvent e) {
                    // Υ֥륯å
                    if ((e.getModifiers() & MouseEvent.BUTTON1_MASK) != 0
                            && e.getClickCount() >= 2) {
                        SSLIcon.this.certification.show(viewer);
                    }
                }
            };
        }

        /** ֤ */
        public Image getIcon() {
            return viewer.getTheme().getImage(Theme.BROWSER_STATUSBAR_KEY, getToolkit());
        }

        /** ޥꥹʤ֤ */
        public MouseListener getMouseListener() {
            return listener;
        }
    }
}
