/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.awt.TabPanel;
import net.hizlab.kagetaka.awt.panel.PanelListener;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.HawkEngine;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.util.StringUtils;
import net.hizlab.kagetaka.viewer.download.Download;
import net.hizlab.kagetaka.viewer.history.History;
import net.hizlab.kagetaka.viewer.history.HistoryManager;
import net.hizlab.kagetaka.viewer.option.ViewerOption;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ӥ塼Ρƥե졼б륳ƥȤμǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.10 $
 */
public class ViewerBaseContext implements HawkContext {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resources";

    // ɸե졼̾
    private static final String TARGET_BLANK  = "_blank" ;
    private static final String TARGET_SELF   = "_self"  ;
    private static final String TARGET_TOP    = "_top"   ;
    private static final String TARGET_PARENT = "_parent";

    /** @serial ݡȥץȥ */
    private static Hashtable supportProtocol = new Hashtable();
    {
        StringTokenizer st = new StringTokenizer(Resource.getMessage("config.support.protocol", null), ",; ");
        while (st.hasMoreTokens()) {
            supportProtocol.put(st.nextToken(), "");
        }
    }

    // ꥯȡ
    /*
     *      |  | ɹ | ɹλ | ɽ |
     * load      +-----------------------------------...
     * view .........+ +-------------------------...
     */
    /** ɤ߹Υꥯ */
    Request loadRequest;
    /** ɽΥڡΥꥯ */
    Request viewRequest;
    /** å֥ */
    Object  lock;
    /** ӥ塼 */
    HawkViewer viewer;

    private String            tag;           // ̥
    private String            name;          // å̾
    private ViewerContext     rootContext;   // 롼ȥƥ
    private ViewerBaseContext parentContext; // ƥƥ
    private ViewerReporter    reporter;      // ݡ

    private ViewerOption      option;
    private LocalizedOption   localizedOption;
    private HistoryManager    historyManager;
    private Connector         connector;
    private HawkEngine        hawkEngine;
    private ViewerPanel       viewerPanel;
    private Vector            contexts;
    private EngineListener    engineListener;
    private TabPanel.Tab      tab;

    private boolean notifyRequest;          // ꥯȴϢΥ٥Ȥ롼ȥƥȤΤ뤫
    private boolean loadCompleted;          // ɤ˽λƤ뤫
    private boolean viewMoved;              // ɽΥڡư줿
    private History viewHistory;            // ɽΥڡ

    // ե졼
    private FrameItem rootFrameItem;        // ֥ƥȤɽե졼ॢƥ
    private FrameItem curFrameItem;         // ʬȤɽե졼

    // в
    private long profConnectStart;
    private long profRenderStart;

    // for loadStatusChanged
    private boolean isOneselfLoading;       // ʬȤɤ߹椫
    private boolean areChildrenLoading;     // ֤Τ줫ɤ߹椫

    /**
     * 󥹥󥹤ޤ
     *
     * @param  viewer        ӥ塼
     * @param  tag           
     * @param  name          ̾
     * @param  scrollbarMode Сɽ⡼
     * @param  parentContext ƥƥȡ
     *                       롼ȥƥȤ <code>null</code>
     * @param  frameItem     ʬȤɽե졼ॢƥࡢ
     *                       ե졼ǤϤʤ <code>null</code>
     */
    ViewerBaseContext(HawkViewer        viewer,
                      String            tag,
                      String            name,
                      int               scrollbarMode,
                      ViewerBaseContext parentContext,
                      FrameItem         frameItem) {
        this.viewer = viewer;
        this.tag    = tag;
        this.name   = name;
        if (parentContext != null) {
            this.rootContext   = parentContext.rootContext;
            this.parentContext = parentContext;
            this.reporter      = (ViewerReporter) rootContext.getReporter();
            this.lock          = rootContext.lock;
        } else {
            ViewerContext vc = (ViewerContext) this;
            this.rootContext   = vc;
            this.parentContext = null;
            this.reporter      = new ViewerReporter(viewer, vc);
            this.lock          = new Object();
        }
        this.curFrameItem = frameItem;

        // 
        option          = viewer.getOption();
        localizedOption = new LocalizedOption(option);
        historyManager  = option.getHistoryManager();
        connector       = new Connector  (viewer, option, reporter);
        hawkEngine      = new HawkEngine (this);
        viewerPanel     = new ViewerPanel(this, option, scrollbarMode, viewer.getDnDListener());

        // ꥹʤϿ
        hawkEngine .setEngineListener(engineListener = new ViewerEngineListener());
        viewerPanel.setPanelListener (new ViewerPanelListener ());
    }

    /**
     * ̥ޤ
     *
     * @return 
     */
    public String getTag() {
        return tag;
    }

    /**
     * ֤ޤ
     *
     * @return 
     */
    TabPanel.Tab getTab() {
        return tab;
    }

    /**
     * ֤ꤷޤ
     *
     * @param  tab 
     */
    void setTab(TabPanel.Tab tab) {
        this.tab = tab;
    }

//### package
    /**
     * ꥯȤɤޤ
     *
     * @param  request ꥯ
     * @param  notify  ɥ٥Ȥ
     *                 롼ȥƥȤΤ <code>true</code>
     *                 ʳξ <code>false</code>
     */
    void load(Request request, boolean notify) {
        synchronized (lock) {
            notifyRequest = notify;
            if (notify) {
                request = requestAccepted(request);
            }
            loadRequest = request;

            // ƱڡΥե󥹤ˤưǺɤ߹ߤʤ
            if (loadCompleted                                          // ΥɤλƤ
                    && request.postData == null                        // POST ꥯȤǤϤʤ
                    && viewRequest != request                          // ɤ߹ߤǤϤʤ
                    && request.getUseCache() >= Request.CACHE_NORMAL   // åѲ
                    && contexts == null                                // ե졼ǤϤʤ
                    && !(request instanceof RequestSet)                // ե졼ưǤϤʤ
                    && !viewRequest.getContentURL().equals(request.url) // URL 㤦
                    && StringUtils.sameFile(viewRequest.getContentURL(), request.url)) { // եƱ
                request.copyFrom(viewRequest);
                moveRequest (request);
                movePosition(true   );
                setStatus   (Resource.getMessage("engine.status.load.complete", null));
                return;
            }
//Debug.out.println("URL=["+url+"]");
            loadStatusChangedForOneself(true);

            hawkEngine.load(request);
        }
    }

    /**
     * ꥯȤޤ
     *
     * @return ꥯ
     */
    Request getRequest() {
        return viewRequest;
    }

    /**
     * ꤵ줿ƥĤߤΥꥯǤåޤ
     *
     * @param  content ƥ
     *
     * @return ߤΥꥯξ <code>true</code>
     *         ʳξ <code>false</code>
     */
    boolean containsRequest(Content content) {
        synchronized (lock) {
            Request request = loadRequest;
            if (request != null && request.contains(content)) {
                return true;
            }
            if (contexts == null) {
                return false;
            }
            for (Enumeration e = contexts.elements(); e.hasMoreElements();) {
                if (((ViewerBaseContext) e.nextElement()).containsRequest(content)) {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * ȥޤ
     *
     * @return ȥ
     */
    String getTitle() {
        if (viewRequest == null) {
            return "";
        }

        String title = viewRequest.getDocument().getTitle();

        return (title != null ? title : "");
    }

    /**
     * URL ޤ
     *
     * @return URL
     */
    URL getURL() {
        return (viewRequest != null ? viewRequest.url : null);
    }

    /**
     * 󥰰ΥݡͥȤ֤ޤ
     *
     * @return ݡͥ
     */
    Component getComponent() {
        return viewerPanel;
    }

    /**
     * ΥƥȤбե졼ॢƥ֤ޤ
     *
     * @return ե졼ॢƥ
     */
    FrameItem getFrameItem() {
        return curFrameItem;
    }

//### nested
    /* ץå*/
    /**
     * ˴ޤ
     */
    void dispose() {
        dispose(true);
    }

    /* ץå*/
    /**
     * ֥ƥȤޤơߤޤ
     */
    void stop() {
        hawkEngine.stop();

        if (contexts == null) {
            return;
        }
        for (Enumeration e = contexts.elements(); e.hasMoreElements();) {
            ((ViewerBaseContext) e.nextElement()).stop();
        }
    }

    /* ץå*/
    /**
     * ֥ƥȤޤƥåȤõĤäɤޤ
     *
     * @param  request ꥯ
     *
     * @return åȤĤä <code>true</code>
     *         Ĥʤä <code>false</code>
     */
    boolean searchAndLoad(Request request) {
        // åȤʬȤξ
        if (name != null && name.compareTo(request.target) == 0) {
            load(request, true);
            return true;
        }

        // ֥ƥȤõ
        if (contexts != null) {
            for (Enumeration e = contexts.elements(); e.hasMoreElements();) {
                if (((ViewerBaseContext) e.nextElement()).searchAndLoad(request)) {
                    return true;
                }
            }
        }
        return false;
    }

    /* ץå*/
    /**
     * ߤΥե졼֤ΥʥåץåȤޤ
     *
     * @return ʥåץå
     */
    RequestSet.Frameset getRequestSetItem() {
        if (rootFrameItem == null) {
            return null;
        }

        return getRequesetSetItemFrameset(rootFrameItem.getItems(), contexts.elements());
    }

    /** ߤΥե졼ॻåȾ֤ΥʥåץåȤץå */
    private RequestSet.Frameset getRequesetSetItemFrameset(FrameItem[][] items,
                                                           Enumeration contextEnum) {
        FrameItem       [][] children;
        RequestSet.Frame[][] frames = new RequestSet.Frame[items.length][];
        for (int i = 0; i < items.length; i++) {
            frames[i] = new RequestSet.Frame[items[i].length];
            for (int j = 0; j < items[i].length; j++) {
                frames[i][j] = ((children = items[i][j].getItems()) != null
                                ? getRequesetSetItemFrameset(children, contextEnum)
                                : ((ViewerBaseContext) contextEnum.nextElement()).getRequesetSetItemFrame());
            }
        }
        return new RequestSet.Frameset(rootFrameItem,
                                       (loadRequest instanceof RequestSet
                                        ? ((RequestSet) loadRequest).getFrameset().request
                                        : loadRequest),
                                       frames);
    }

    /** ߤΥե졼ࡦե졼ॻåȾ֤ΥʥåץåȤץå */
    private RequestSet.Frame getRequesetSetItemFrame() {
        // ʬե졼ȥե졼ॻåȤεǽľ
        if (rootFrameItem != null) {
            return new RequestSet.Frame(curFrameItem,
                                        new RequestSet(loadRequest,
                                                       getRequestSetItem()));
        }

        // ʬե졼ȤƤεǽľ
        if (curFrameItem != null) {
            return new RequestSet.Frame(curFrameItem, loadRequest);
        }

        return null;
    }

//### ե졼
    /* ץå*/
    /**
     * ե졼ॢƥȤƤΥ֥ƥȤ֤ޤ
     *
     * @param  item ե졼ॢƥ
     *
     * @return ֥ƥ
     */
    ViewerBaseContext createSubContext(FrameItem item) {
        // setupPanel -> viewerPanel.setup ƤӽФƤ뤿 lock Ѥ
        String newTag = this.tag + "-" + contexts.size();
        ViewerBaseContext c = new ViewerBaseContext(viewer,
                                                    newTag,
                                                    item.getName(),
                                                    item.getScrolling(),
                                                    this,
                                                    item);
        contexts.addElement(c);
        viewerPanel.add(c.viewerPanel);
        return c;
    }

    /* ץå*/
    /**
     * ƤΥ֥ƥȤ˴ޤ
     */
    void removeAllSubContexts() {
        // setupPanel -> viewerPanel.setup ƤӽФƤ뤿 lock Ѥ
        dispose(false);
    }

//### HawkContext
    /* 륦ɥѤα륳ƥȤ */
    /** {@inheritDoc} */
    public Reporter getReporter() {
        return reporter;
    }

    /* ġ륭åȤ֤ */
    /** {@inheritDoc} */
    public Toolkit getToolkit() {
        return viewerPanel.getToolkit();
    }

    /* ꤷꥯȤɽ */
    /** {@inheritDoc} */
    public void openHawk(Request request) {
        String protocol = request.url.getProtocol();

        if (!supportProtocol.containsKey(protocol)) {
            MessageBox.show(viewer,
                            getMessage("message.unknownprotocol.text" , new String[]{protocol}),
                            getMessage("message.unknownprotocol.title", null),
                            MessageBox.BUTTON_OK | MessageBox.ICON_EXCLAMATION);
            return;
        }

//Debug.out.println(name+","+request.target);
        // ƱƥȤǳϡåȤ򸡺
        if (request.openMode == Request.OPEN_DEFAULT) {
            synchronized (lock) {
                ViewerBaseContext loadContext;      // оݥƥ
                if (request.target == null) {
                    loadContext = this;
                } else {
                    // å̾
                    String targetLC = request.target.toLowerCase();
                    // ɥʤޤϥ֡
                    if (TARGET_BLANK.compareTo(targetLC) == 0) {
                        loadContext = null;
                        //### TODO ɥ֤ϥץ˻
                        request     = new Request(request.url, request.postData,
                                                  request.referer, null,
                                                  Request.OPEN_NEWTAB,
                                                  request.getUseCache());
                    } else
                    // ʬ
                    if (TARGET_SELF.compareTo(targetLC) == 0) {
                        loadContext = this;
                        request     = new Request(request.url, request.postData,
                                                  request.referer, null,
                                                  Request.OPEN_DEFAULT,
                                                  request.getUseCache());
                    } else
                    // ȥå
                    if (TARGET_TOP.compareTo(targetLC) == 0) {
                        loadContext = rootContext;
                        request     = new Request(request.url, request.postData,
                                                  request.referer, null,
                                                  Request.OPEN_DEFAULT,
                                                  request.getUseCache());
                    } else
                    // 
                    if (TARGET_PARENT.compareTo(targetLC) == 0) {
                        loadContext = parentContext;
                        request     = new Request(request.url, request.postData,
                                                  request.referer, null,
                                                  Request.OPEN_DEFAULT,
                                                  request.getUseCache());
                    } else
                    // Ƥ鸡ƸĤä
                    if (rootContext.searchAndLoad(request)) {
                        return;
                    } else {
                        loadContext = null;
                        request     = new Request(request.url, request.postData,
                                                  request.referer, request.target,
                                                  Request.OPEN_NEWTAB,
                                                  request.getUseCache());
                    }
                }
                // ƥȤꤷƥ
                if (loadContext != null) {
                    loadContext.load(request, true);
                    return;
                }
            }
        }
        // ̤Υɥ䥿֤ǳ
        viewer.open(request);
    }

    /* ꤵ줿 URL ΥƥĤ֤ */
    /** {@inheritDoc} */
    public Content getContent(Request request)
            throws IOException, InterruptedException {
        return connector.getContent(request);
    }

    /*  ꤵ줿ƥĤ */
    /** {@inheritDoc} */
    public void download(Content content) {
        Download.show(viewer, option, content, null);
        setStatus(null);
    }

    /* ᡼֤ޤ */
    /** {@inheritDoc} */
    public Image createImage(int width, int height) {
        return viewerPanel.createImage(width, height);
    }

    /* ǥȥå֤ */
    /** {@inheritDoc} */
    public MediaTracker getMediaTracker() {
        return viewerPanel.getMediaTracker();
    }

    /* ֥å᡼ */
    /** {@inheritDoc} */
    public int setImage(int index, int reason, int tag,
                        Image image, int width, int height, ItemMap itemMap) {
        int newIndex = viewerPanel.setImage(index, reason, tag,
                                            image, width, height, itemMap);
        if (index == -1) {
            synchronized (lock) {
                movePosition(false);
            }
        }
        return newIndex;
    }

    /* եॢƥɲ */
    /** {@inheritDoc} */
    public void addFormItem(FormItem item) {
        viewerPanel.addFormItem(item);
    }

    /* ѥͥ򥻥åȥå */
    /** {@inheritDoc} */
    public void setupPanel(Document document) {
        setupPanel(document, null);
    }

    /* ѥͥե졼Ѥ˥åȥå */
    /** {@inheritDoc} */
    public void setupPanel(Document document, FrameItem rootItem) {
        synchronized (lock) {
            // ե졼ब¸ߤϤ٤˴
            if (contexts != null) {
                dispose(false);
            }

            this.rootFrameItem = (rootItem instanceof RequestSet.Frameset
                                  ? ((RequestSet.Frameset) rootItem).frameItem
                                  : rootItem);

            String title = document.getTitle();

            viewHistory.setTitle(title);
            titleChanged        (title);

            if (rootItem == null) {
                viewerPanel.setup(document);
            } else {
                // ե졼ΰ٤Υ֥ƥȤʪѰ
                contexts = new Vector();
                viewerPanel.setup(viewRequest, document, rootItem);
            }
        }
    }

    /* ѥͥ */
    /** {@inheritDoc} */
    public void commitPanel(Document document, int tag) {
        viewerPanel.commit(document, tag);
    }

    /* ХϰϤꤷƺɽ */
    /** {@inheritDoc} */
    public void repaint(int x, int y, int width, int height) {
        viewerPanel.repaintScreen(x, y, width, height);
    }

    /* ơå */
    /** {@inheritDoc} */
    public void setStatus(String status) {
        statusChanged(status, true, false);
    }

    /* Ūʥơå */
    /** {@inheritDoc} */
    public void setTemporaryStatus(String status) {
        statusChanged(status, false, false);
    }

    /* ӥ塼ݡȤθߤΥ֤ */
    /** {@inheritDoc} */
    public Dimension getViewportSize(boolean def) {
        return viewerPanel.getViewportSize(def);
    }

    /* ץ֤ */
    /** {@inheritDoc} */
    public Option getOption() {
        return localizedOption;
    }

    /* ꤷ URL ˬ䤷Ȥ뤫ɤ֤ */
    /** {@inheritDoc} */
    public boolean haveEverVisited(URL url) {
        return historyManager.contains(url.toString());
    }

    /* å */
    /** {@inheritDoc} */
    public void setCookie(String value, URL url) {
        connector.setCookie(value, url);
    }

//### PanelListener
    /** ѥͥꥹ */
    private final class ViewerPanelListener implements PanelListener {
        /** 󥹥󥹤 */
        private ViewerPanelListener() {
        }

        /* ꤷꥯȤɽ */
        /** {@inheritDoc} */
        public void openHawk(Request request) {
            ViewerBaseContext.this.openHawk(request);
        }

        /*  */
        /** {@inheritDoc} */
        public void back() {
            rootContext.back(1);
        }

        /* 뤫ɤ */
        /** {@inheritDoc} */
        public boolean canBack() {
            return rootContext.canBack();
        }

        /* ؿʤ */
        /** {@inheritDoc} */
        public void forward() {
            rootContext.forward(1);
        }

        /* ؿʤ뤫ɤ */
        /** {@inheritDoc} */
        public boolean canForward() {
            return rootContext.canForward();
        }

        /* ɹ */
        /** {@inheritDoc} */
        public void reload(int mode) {
            rootContext.reload(mode);
        }

        /* ɹǤ뤫ɤ */
        /** {@inheritDoc} */
        public boolean canReload() {
            return (viewRequest != null);
        }

        /*  */
        /** {@inheritDoc} */
        public void stop() {
            rootContext.stop();
        }

        /* ߤǤ뤫ɤ */
        /** {@inheritDoc} */
        public boolean canStop() {
            return rootContext.canStop();
        }

        /* 襹꡼Υѹ줿 */
        /** {@inheritDoc} */
        public void screenResized(int tag) {
            // 褹
            hawkEngine.redraw(tag);
        }
    }

//### EngineListener
    /** 󥸥ꥹ */
    private final class ViewerEngineListener implements EngineListener {
        /** 󥹥󥹤 */
        private ViewerEngineListener() {
        }

        /* ³Ϥ˸ƤӽФ */
        /** {@inheritDoc} */
        public void connecting(Request request) {
            profConnectStart = System.currentTimeMillis();
        }

        /* ³λȸƤӽФ */
        /** {@inheritDoc} */
        public void connected(Request request, boolean noerror) {
        }

        /* 褬åפ줿Ȥ˸ƤӽФ */
        /** {@inheritDoc} */
        public void renderingSkipped(Request request) {
            synchronized (lock) {
                if (loadRequest != request) {
                    return;
                }

                loadStatusChangedForOneself(false);
            }
        }

        /* 褬Ϥ˸ƤӽФ */
        /** {@inheritDoc} */
        public void renderingStarted(Request request) {
            synchronized (lock) {
                if (loadRequest != request) {
                    return;
                }

                loadCompleted = false;
                moveRequest(request);
                viewerPanel.requestFocus();

                // ե졼ưξ
                if (request instanceof RequestSet) {
                    RequestSet requestSet = (RequestSet) request;
                    RequestSet.Frameset frameset = requestSet.getFrameset();

                    // ե졼ॻåȤ
                    if (frameset.frameItem != rootFrameItem) {
                        setupPanel(frameset.request.getDocument(), frameset);
                    } else {
                        RequestSet.Frame[][] frames = frameset.frames;
                        RequestSet.Frame     frame;
                        ViewerBaseContext    c;
                        int     index  = 0;
                        boolean reload = requestSet.isReload();
                        for (int i = 0; i < frames.length; i++) {
                            for (int j = 0; j < frames[i].length; j++) {
                                frame = frames[i][j];
                                c = (ViewerBaseContext) contexts.elementAt(index++);
                                if (reload || c.viewRequest != frame.request) {
                                    c.load(frame.request, false);
                                }
                            }
                        }
                    }

                    requestSet.setReload(false);
                }
            }

            profRenderStart = System.currentTimeMillis();
        }

        /* 褬λȸƤӽФ */
        /** {@inheritDoc} */
        public void renderingStopped(Request request, boolean noerror) {
            synchronized (lock) {
                if (loadRequest != request) {
                    return;
                }

                if (noerror) {
                    loadCompleted = true;
                }
                loadStatusChangedForOneself(false);
                movePosition(true);
            }

            // в֤
            long now = System.currentTimeMillis();
            reporter.report(Reporter.LOAD, Reporter.PROF, Reporter.NONE,
                            request.getDocument().content, 0, 0,
                            "TIME",
                            getMessage("prof.loadtime", new Object[]{new Long(now - profConnectStart),
                                                                     new Long(now - profRenderStart)}));
        }

        /* ꤷ URL ɽ */
        /** {@inheritDoc} */
        public void refresh(Request baseRequest, Request newRequest) {
            synchronized (lock) {
                if (viewRequest != baseRequest) {
                    return;
                }

                load(newRequest, true);
            }
        }
    }

//### private
    /** ѹץå */
    private void moveRequest(Request request) {
        // ߤɽ֤¸
        if (viewRequest != null) {
            viewRequest.save(viewerPanel.getScrollPosition());
        }

        // ɤ߹߰ʳ
        Request r = (request instanceof RequestSet
                     ? ((RequestSet) request).getFrameset().request
                     : request);
        if (viewRequest != r) {
            if (viewRequest != null) {
                viewRequest.cleanup();
            }
            viewRequest = r;
        }

        viewMoved   = false;
        viewHistory = historyManager.visited(request.url.toString(), (rootContext == this));

        addressChanged(request.getContentURL().toString());
        if (notifyRequest) {
            historyChanged(request, true);
        }
    }

    /** ݥưץå */
    private void movePosition(boolean force) {
        if (viewMoved) {
            return;
        }

        Point position;

        // 桼ư֤
        if ((position = viewRequest.getPosition()) != null) {
            // 桼ˤꥯ뤵Ƥʤ
            Point scpos = viewerPanel.getScrollPosition();
            if ((force || (scpos.x == 0 && scpos.y == 0))
                    && !viewerPanel.setScrollPosition(position.x, position.y, false)) {
                return;
            }
        } else

        // # ե󥹤ΰ֤ء307 ʤɤξǤ⡢ꥯ URL Υե󥹤Ȥ
        if (!viewerPanel.setScrollPosition(viewRequest.url.getRef(), force)) {
            return;
        }

        viewMoved = true;
    }

    /** ˴ץå*/
    private void dispose(boolean isThis) {
        if (isThis) {
            hawkEngine.dispose();
            if (viewRequest != null) {
                viewRequest.cleanup();
            }
        }
        if (contexts == null) {
            return;
        }

        // ե졼
        ViewerBaseContext c;
        for (Enumeration e = contexts.elements(); e.hasMoreElements();) {
            c = (ViewerBaseContext) e.nextElement();
            viewerPanel.remove(c.getComponent());
            c.dispose(true);
        }
        contexts      = null;
        rootFrameItem = null;
    }


    /** ꥽ʸ */
    private String getMessage(String key, Object[] args) {
        return Resource.getMessage(RESOURCE, key, args);
    }

//### ͥȽ٥ѡʻҤ
    /* ץå*/
    /**
     * ꥯȤμդΤޤ
     * ֥ƥȤξϡܰʹߤ load ƤӽФޤ
     * ޤɬפ˱ƼդꥯȤ֤ޤ
     *
     * @param  request դꥯ
     *
     * @return դꥯ
     */
    Request requestAccepted(Request request) {
        return rootContext.requestAccepted(request);
    }

    /* ץå*/
    /**
     * ѹΤޤ
     * ֥ƥȤξϡܰʹߤ moveRequest ƤӽФޤ
     *
     * @param  request  ѹȤΥʥåץå
     * @param  addChain ꥯȥɲä <code>true</code>
     *                  ɲäʤ <code>false</code>
     */
    void historyChanged(Request request, boolean addChain) {
        rootContext.historyChanged(request, addChain);
    }

    /* ץå*/
    /**
     * ӥ塼Υȥѹޤ
     *
     * @param  title ȥ
     */
    void titleChanged(String title) {
        // ̵
    }

    /* ץå*/
    /**
     * ӥ塼Υɥ쥹ѹޤ
     *
     * @param  address ɥ쥹
     */
    void addressChanged(String address) {
        // ̵
    }

    /**
     * ӥ塼Υơѹޤ
     *
     * @param  status       ơ
     * @param  isPermanence ɽĤŤ <code>true</code>
     *                      ʳξ <code>false</code>
     * @param  force        ɬ٥Ȥ <code>true</code>
     *                      ơѤʤʤ
     *                      <code>false</code>
     */
    void statusChanged(String status, boolean isPermanence, boolean force) {
        rootContext.statusChanged(status, isPermanence, force);
    }

    /* ץå*/
    /**
     * ꥯȤΥɾ֤ѹΤޤ
     *
     * @param  isLoading ɤ߹ξ <code>true</code>
     *                   ʳξ <code>false</code>
     */
    void loadStatusChanged(boolean isLoading) {
        parentContext.loadStatusChangedForChildren(isLoading);
    }

    /** ꥯȤΥɾ֤ѹ򡢼ʬȤΡץå */
    private void loadStatusChangedForOneself(boolean isLoading) {
        boolean now  = (isLoading || areChildrenLoading);
        boolean call = ((isOneselfLoading || areChildrenLoading) != now);
        isOneselfLoading = isLoading;
        if (call) {
            loadStatusChanged(now);
        }
    }

    /** ꥯȤΥɾ֤ѹ򡢻ҶƤӽФΡץå */
    private void loadStatusChangedForChildren(boolean isLoading) {
        boolean now  = (isOneselfLoading || isLoading);
        boolean call = ((isOneselfLoading || areChildrenLoading) != now);
        areChildrenLoading = isLoading;
        if (call) {
            loadStatusChanged(now);
        }
    }
}
