/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.token.Value;

import java.awt.Point;

/**
 * ե졼ˤʬޤꥯȾǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
class RequestSet extends Request {
    private Request  request;
    private Frameset frameset;
    private boolean  reload;

    /**
     * ꥯȾޤ
     *
     * @param  request   Υꥯ
     * @param  frameset  롼ȤΥե졼ॻå
     */
    RequestSet(Request request, Frameset frameset) {
        super(request.url, request.postData, request.parent,
              request.referer, request.target,
              request.openMode, request.getUseCache());
        this.request  = request;
        this.frameset = frameset;

        setIgnored(true);
    }

    /* åѥפ֤ */
    /** {@inheritDoc} */
    public int getUseCache() {
        return request.getUseCache();
    }

    /* åѥפ */
    /** {@inheritDoc} */
    public void setUseCache(int useCache) {
        request.setUseCache(useCache);
        if (frameset != null) {
            frameset.setUseCache(useCache);
        }
    }

    /* ꤷƥĤޤǤ뤫֤ */
    /** {@inheritDoc} */
    public boolean contains(Content content) {
        return request.contains(content);
    }

    /* ɥȤ֤ */
    /** {@inheritDoc} */
    public Document getDocument() {
        return request.getDocument();
    }

    /**
     * ꥯȤηƤ򥳥ԡޤ
     *
     * @param  src ԡΥꥯ
     */
    /** {@inheritDoc} */
    public void copyFrom(Request src) {
        throw new IllegalStateException("invalid call RequesetSet.copyFrom(Request)");
    }

    /**
     * ݥ֤ޤ
     *
     * @return ݥ
     */
    /** {@inheritDoc} */
    public Point getPosition() {
        throw new IllegalStateException("invalid call RequesetSet.getPosition()");
    }

    /**
     * ݥꤷޤ
     *
     * @param  position ݥ
     */
    /** {@inheritDoc} */
    public void setPosition(Point position) {
        throw new IllegalStateException("invalid call RequesetSet.setPosition(Point)");
    }

    /**
     * Ūʥ꥽ޤ
     */
    /** {@inheritDoc} */
    public synchronized void cleanup() {
        // ̵
    }

    /**
     * ե졼ॻåȤ֤ޤ
     *
     * @return ե졼ॻå
     */
    Frameset getFrameset() {
        return frameset;
    }

    /**
     * ե졼ॻåȤꤷޤ
     *
     * @param  frameset ե졼ॻå
     */
    void setFrameset(Frameset frameset) {
        this.frameset = frameset;
        frameset.setReload(reload);
    }

    /**
     * ɤɤ֤ޤ
     *
     * @return ɤξ <code>true</code>
     *         ʳξ <code>false</code>
     */
    boolean isReload() {
        return reload;
    }

    /**
     * ɤɤ֤ޤ
     *
     * @param  reload ɤξ <code>true</code>
     *                ʳξ <code>false</code>
     */
    void setReload(boolean reload) {
        this.reload = reload;
        if (frameset != null) {
            frameset.setReload(reload);
        }
    }

//### Frame
    /**
     * ե졼ɽ饹Ǥ
     */
    static class Frame implements FrameItem {
        /** ե졼ॢƥ */
        FrameItem frameItem;
        /** ꥯ */
        Request request;

        /**
         * 󥹥󥹤ޤ
         *
         * @param  frame   ե졼ॢƥ
         * @param  request ꥯ
         */
        Frame(FrameItem frame, Request request) {
            this.frameItem = frame;
            this.request   = request;
        }

        /* ҤΥե졼ॢƥ֤*/
        /** {@inheritDoc} */
        public FrameItem[][] getItems() {
            return null;
        }

        /* ե졼ॢƥ֤ */
        /** {@inheritDoc} */
        public Value getWidth() {
            return frameItem.getWidth();
        }

        /* ե졼ॢƥ */
        /** {@inheritDoc} */
        public void setWidth(Value width) {
            frameItem.setWidth(width);
        }

        /* ե졼ॢƥι⤵֤ */
        /** {@inheritDoc} */
        public Value getHeight() {
            return frameItem.getHeight();
        }

        /* ե졼ॢƥι⤵ */
        /** {@inheritDoc} */
        public void setHeight(Value height) {
            frameItem.setHeight(height);
        }

        /* ե졼ॢƥ֤̾ޤ */
        /** {@inheritDoc} */
        public String getName() {
            return frameItem.getName();
        }

        /* ե졼ॢƥ SRC ֤ޤ */
        /** {@inheritDoc} */
        public String getSrc() {
            return frameItem.getSrc();
        }

        /* ե졼बꥵǽ֤ޤ */
        /** {@inheritDoc} */
        public boolean getResize() {
            return frameItem.getResize();
        }

        /* ե졼ΥСɽ⡼ɤ֤ޤ */
        /** {@inheritDoc} */
        public int getScrolling() {
            return frameItem.getScrolling();
        }

        /* ڤȤɽ뤫֤ޤ */
        /** {@inheritDoc} */
        public boolean getBorder() {
            return frameItem.getBorder();
        }

        /* ե졼⥳ƥĤκΥޡ֤ޤ */
        /** {@inheritDoc} */
        public int getMargineWidth() {
            return frameItem.getMargineWidth();
        }

        /* ե졼⥳ƥĤξ岼Υޡ֤ޤ */
        /** {@inheritDoc} */
        public int getMargineHeight() {
            return frameItem.getMargineHeight();
        }

        /** åѥפ */
        private void setUseCache(int useCache) {
            if (request != null) {
                request.setUseCache(useCache);
            }
        }

        /** ɤɤ */
        private void setReload(boolean reload) {
            if (request instanceof RequestSet) {
                ((RequestSet) request).setReload(reload);
            }
        }
    }

    /**
     * ե졼ॻåȤɽ饹Ǥ
     */
    static class Frameset extends Frame {
        /** ҤΥե졼 */
        Frame[][] frames;

        /**
         * ե졼ॻåȤޤ
         *
         * @param  frame   ե졼ॻåȥƥ
         * @param  request ꥯ
         * @param  frames  ҤΥե졼
         */
        Frameset(FrameItem frame, Request request, Frame[][] frames) {
            super(frame, request);
            this.frames = frames;
        }

        /* ҤΥե졼ॢƥ֤*/
        /** {@inheritDoc} */
        public FrameItem[][] getItems() {
            return frames;
        }

        /* åѥפ */
        /** {@inheritDoc} */
        private void setUseCache(int useCache) {
            for (int i = 0; i < frames.length; i++) {
                for (int j = 0; j < frames[i].length; j++) {
                    frames[i][j].setUseCache(useCache);
                }
            }
        }

        /* ɤɤ */
        /** {@inheritDoc} */
        private void setReload(boolean reload) {
            for (int i = 0; i < frames.length; i++) {
                for (int j = 0; j < frames[i].length; j++) {
                    frames[i][j].setReload(reload);
                }
            }
        }
    }
}
